/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.ores.entities;

import com.draco18s.ores.OresBase;
import com.draco18s.ores.inventory.ContainerOreCart;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityOreMinecart
extends EntityMinecartContainer {
    private static final DataParameter<Byte> DIRECTION = EntityDataManager.func_187226_a(EntityOreMinecart.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Float> FULLNESS = EntityDataManager.func_187226_a(EntityOreMinecart.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final Random RANDOM = new Random();
    private BlockPos lastActivator = new BlockPos(0, 0, 0);
    private int timeOnActivator = 0;
    private DumpDir dumpingDirection;
    private float invenFullVal = 0.0f;

    public EntityOreMinecart(World worldIn) {
        super(worldIn);
    }

    public EntityOreMinecart(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.dumpingDirection = DumpDir.RIGHT;
        this.field_70180_af.func_187214_a(DIRECTION, (Object)((byte)this.dumpingDirection.ordinal()));
        this.field_70180_af.func_187214_a(FULLNESS, (Object)Float.valueOf(0.0f));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        int px = MathHelper.func_76128_c((double)this.field_70165_t);
        int py = MathHelper.func_76128_c((double)this.field_70163_u);
        int pz = MathHelper.func_76128_c((double)this.field_70161_v);
        BlockPos blockpos = new BlockPos(px, py, pz);
        IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
        if (iblockstate.func_177230_c() != Blocks.field_150408_cc || !blockpos.equals((Object)this.lastActivator)) {
            this.timeOnActivator = 0;
            this.lastActivator = blockpos;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.setInventoryFullness(Container.func_94526_b((IInventory)this));
        }
    }

    public void func_96095_a(int x, int y, int z, boolean receivingPower) {
        if (receivingPower) {
            if (this.timeOnActivator % 10 == 0) {
                if (this.dumpingDirection == DumpDir.RIGHT) {
                    EntityOreMinecart.dropInventoryItems(this.field_70170_p, this.field_70165_t + Math.signum(this.field_70179_y), this.field_70163_u, this.field_70161_v + Math.signum(this.field_70159_w), (IInventory)this);
                } else {
                    EntityOreMinecart.dropInventoryItems(this.field_70170_p, this.field_70165_t - Math.signum(this.field_70179_y), this.field_70163_u, this.field_70161_v - Math.signum(this.field_70159_w), (IInventory)this);
                }
                this.func_70296_d();
            }
            ++this.timeOnActivator;
        }
    }

    public int func_70302_i_() {
        return 20;
    }

    public EntityMinecart.Type func_184264_v() {
        return OresBase.oreCartEnum;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        this.func_184288_f(playerIn);
        return new ContainerOreCart((IInventory)playerInventory, (IInventory)this, playerIn);
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (MinecraftForge.EVENT_BUS.post((Event)new MinecartInteractEvent((EntityMinecart)this, player, hand))) {
            return true;
        }
        if (!this.field_70170_p.field_72995_K) {
            player.openGui((Object)OresBase.instance, 1, this.field_70170_p, this.func_145782_y(), -1, -1);
        }
        return true;
    }

    private static void dropInventoryItems(World worldIn, double x, double y, double z, IInventory inventory) {
        int numDropped = 0;
        for (int i = 0; numDropped < 5 && i < inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = inventory.func_70301_a(i);
            if (itemstack == null) continue;
            EntityOreMinecart.spawnItemStack(worldIn, x, y, z, itemstack);
            ++numDropped;
            inventory.func_70299_a(i, null);
        }
    }

    public static void spawnItemStack(World worldIn, double x, double y, double z, ItemStack stack) {
        if (worldIn.field_72995_K) {
            return;
        }
        float f = (float)RANDOM.nextGaussian() * 0.2f + 0.4f;
        float f1 = (float)RANDOM.nextGaussian() * 0.2f + 0.4f;
        float f2 = (float)RANDOM.nextGaussian() * 0.2f + 0.4f;
        EntityItem entityitem = new EntityItem(worldIn, (double)MathHelper.func_76128_c((double)x) + (double)f, (double)MathHelper.func_76128_c((double)y) + (double)f1, (double)MathHelper.func_76128_c((double)z) + (double)f2, stack);
        float f3 = 0.05f;
        entityitem.field_70159_w = 0.0;
        entityitem.field_70181_x = 0.0;
        entityitem.field_70179_y = 0.0;
        worldIn.func_72838_d((Entity)entityitem);
    }

    public String func_174875_k() {
        return "minecraft:chest";
    }

    public DumpDir getDumpDir() {
        return DumpDir.values()[(Byte)this.field_70180_af.func_187225_a(DIRECTION)];
    }

    public void setDumpDir(DumpDir newdir) {
        this.dumpingDirection = newdir;
        this.field_70180_af.func_187227_b(DIRECTION, (Object)((byte)this.dumpingDirection.ordinal()));
        this.func_70296_d();
    }

    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("DumpSide", this.getDumpDir().ordinal());
        compound.func_74776_a("invenFullVal", this.invenFullVal);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setDumpDir(DumpDir.values()[compound.func_74762_e("DumpSide")]);
        this.setInventoryFullness(compound.func_74760_g("invenFullVal"));
    }

    public float getInventoryFullness() {
        return ((Float)this.field_70180_af.func_187225_a(FULLNESS)).floatValue() * 0.5f;
    }

    public void setInventoryFullness(float val) {
        this.invenFullVal = val;
        this.field_70180_af.func_187227_b(FULLNESS, (Object)Float.valueOf(val));
        this.func_70296_d();
    }

    public void func_94095_a(DamageSource source) {
        this.func_70106_y();
        if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            InventoryHelper.func_180176_a((World)this.field_70170_p, (Entity)this, (IInventory)this);
            ItemStack itemstack = new ItemStack(OresBase.oreMinecart, 1);
            if (this.func_70005_c_() != null) {
                itemstack.func_151001_c(this.func_70005_c_());
            }
            this.func_70099_a(itemstack, 0.0f);
        }
    }

    public static enum DumpDir {
        LEFT,
        RIGHT;

    }
}

