/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.ores.entities;

import com.draco18s.hardlib.api.HardLibAPI;
import com.draco18s.hardlib.api.internal.BlockWrapper;
import com.draco18s.ores.OresBase;
import com.draco18s.ores.block.BlockSluice;
import com.draco18s.ores.entities.capabilities.ItemStackHandlerDirt;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityBasicSluice
extends TileEntity
implements ITickable {
    public static Item itemGravel;
    public static Item itemSand;
    public static Item itemDirt;
    public static int cycleLength;
    protected ItemStackHandler inputSlot;
    private int waterAmount;
    private AxisAlignedBB suckZone;
    private int downstremrequests;
    private int timer = 0;
    private Random rand;

    public TileEntityBasicSluice() {
        if (itemGravel == null) {
            itemGravel = Item.func_150898_a((Block)Blocks.field_150351_n);
            itemSand = Item.func_150898_a((Block)Blocks.field_150354_m);
            itemDirt = Item.func_150898_a((Block)Blocks.field_150346_d);
        }
        this.inputSlot = new ItemStackHandlerDirt();
        this.rand = new Random();
    }

    public void func_73660_a() {
        this.downstremrequests = Math.min(this.downstremrequests, 3);
        if (this.field_145850_b.field_72995_K) {
            this.downstremrequests = 0;
        }
        BlockPos p = this.field_174879_c;
        EnumFacing dir = ((EnumFacing)this.field_145850_b.func_180495_p(p).func_177229_b((IProperty)BlockSluice.FACING)).func_176734_d();
        while (this.field_145850_b.func_180495_p(p = p.func_177967_a(dir, 1)).func_177230_c() == OresBase.sluice) {
        }
        if (!this.field_174879_c.equals((Object)(p = p.func_177967_a(dir.func_176734_d(), 1))) || !this.field_145850_b.field_72995_K) {
            // empty if block
        }
        this.suckItems();
        this.updateWater();
        if (this.timer < 0) {
            ++this.timer;
        } else if (this.timer > 0) {
            --this.timer;
            if (this.timer % (cycleLength * 5) == 0) {
                this.doFilter();
            }
            if (this.timer == 0) {
                this.subtractDirt();
            }
        } else if (this.waterAmount > 0) {
            if (!this.inputSlot.getStackInSlot(0).func_190926_b()) {
                this.timer = 25 * cycleLength;
            } else {
                this.makeRequest();
                this.timer = -5 * cycleLength;
                this.downstremrequests = 0;
            }
            this.sendUpdates();
        }
        if (this.downstremrequests > 0 && !this.inputSlot.getStackInSlot(0).func_190926_b() && this.inputSlot.getStackInSlot(0).func_190916_E() > 1) {
            float rx = 0.5f;
            float ry = this.rand.nextFloat() * 0.25f + 0.25f;
            float rz = 0.5f;
            EntityItem entityItem = new EntityItem(this.field_145850_b, (double)((float)this.field_174879_c.func_177958_n() + rx), (double)((float)this.field_174879_c.func_177956_o() + ry), (double)((float)this.field_174879_c.func_177952_p() + rz), this.inputSlot.getStackInSlot(0).func_77979_a(1));
            entityItem.field_70159_w = 0.0;
            entityItem.field_70181_x = 0.0;
            entityItem.field_70179_y = 0.0;
            entityItem.func_174867_a(300);
            this.field_145850_b.func_72838_d((Entity)entityItem);
            --this.downstremrequests;
            this.sendUpdates();
        }
    }

    private void makeRequest() {
        BlockPos p = this.field_174879_c;
        EnumFacing dir = ((EnumFacing)this.field_145850_b.func_180495_p(p).func_177229_b((IProperty)BlockSluice.FACING)).func_176734_d();
        while (this.field_145850_b.func_180495_p(p = p.func_177967_a(dir, 1)).func_177230_c() == OresBase.sluice) {
        }
        TileEntity te = this.field_145850_b.func_175625_s(p = p.func_177967_a(dir.func_176734_d(), 1));
        if (te != null && te instanceof TileEntityBasicSluice && te != this) {
            ++((TileEntityBasicSluice)te).downstremrequests;
        }
    }

    private void doFilter() {
        List list = HardLibAPI.oreMachines.getRandomSluiceResults(this.rand, this.inputSlot.getStackInSlot(0).func_77973_b());
        for (Block b : list) {
            if (b == null) {
                return;
            }
            BlockWrapper ore = new BlockWrapper(b, 16);
            if (b == Blocks.field_150351_n && this.inputSlot.getStackInSlot(0).func_77973_b() == itemGravel) {
                this.mergeStacks(new ItemStack(Items.field_151145_ak));
                continue;
            }
            int best = 0;
            BlockPos bestLoc = BlockPos.field_177992_a;
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    BlockPos lookPos = this.field_174879_c.func_177982_a(16 * j, 0, 16 * k);
                    int cur = HardLibAPI.oreData.getOreData(this.field_145850_b, lookPos, ore);
                    if (cur <= best) continue;
                    bestLoc = lookPos.func_177979_c(0);
                    best = cur;
                }
            }
            if (best <= 0) continue;
            HardLibAPI.oreData.adjustOreData(this.field_145850_b, bestLoc, ore, 1);
            IBlockState oreState = ore.meta >= 0 ? ore.block.func_176203_a(ore.meta) : ore.block.func_176223_P();
            ItemStack basicDrop = new ItemStack(ore.block.func_180660_a(oreState, this.rand, 0));
            ItemStack toSpawn = HardLibAPI.oreMachines.getMillResult(basicDrop);
            if (!toSpawn.func_190926_b()) {
                toSpawn.func_77946_l();
                if (this.inputSlot.getStackInSlot(0).func_77973_b() == itemGravel) {
                    if (this.rand.nextInt(10) == 0) {
                        toSpawn = basicDrop.func_77946_l();
                    }
                } else if (this.inputSlot.getStackInSlot(0).func_77973_b() == itemSand) {
                    if (this.rand.nextInt(10) == 0) {
                        toSpawn.func_190920_e(2);
                    }
                } else {
                    int r = this.rand.nextInt(20);
                    if (r == 0) {
                        toSpawn = basicDrop.func_77946_l();
                    } else if (r == 1) {
                        toSpawn.func_190920_e(2);
                    }
                }
            } else {
                toSpawn = basicDrop;
            }
            this.mergeStacks(toSpawn);
        }
    }

    private void sendUpdates() {
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.getState(), this.getState(), 3);
        this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), 0, 0);
        this.func_70296_d();
    }

    private IBlockState getState() {
        return this.field_145850_b.func_180495_p(this.field_174879_c);
    }

    private void subtractDirt() {
        if (this.inputSlot.getStackInSlot(0).func_190916_E() > 1) {
            this.inputSlot.getStackInSlot(0).func_190918_g(1);
        } else {
            this.inputSlot.setStackInSlot(0, ItemStack.field_190927_a);
        }
        this.sendUpdates();
    }

    private void suckItems() {
        boolean flowItemsTowards;
        EntityItem ent;
        List ents = this.field_145850_b.func_72872_a(EntityItem.class, this.getAABB(this.field_174879_c));
        if (ents.size() > 0 && this.inputSlot.getStackInSlot(0).func_190926_b()) {
            for (int e = ents.size() - 1; e >= 0; --e) {
                ent = (EntityItem)ents.get(e);
                ItemStack stack = ent.func_92059_d();
                if (stack.func_77973_b() != itemGravel && stack.func_77973_b() != itemSand && (!OresBase.sluiceAllowDirt || stack.func_77973_b() != itemDirt)) continue;
                if (stack.func_190916_E() > 1) {
                    this.inputSlot.setStackInSlot(0, stack.func_77979_a(1));
                } else {
                    this.inputSlot.setStackInSlot(0, stack.func_77946_l());
                    ent.func_70106_y();
                }
                this.sendUpdates();
                break;
            }
        }
        if ((flowItemsTowards = true) && this.waterAmount >= 2) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            EnumFacing dir = ((EnumFacing)state.func_177229_b((IProperty)BlockSluice.FACING)).func_176734_d();
            IBlockState source = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(dir));
            EnumFacing dirdir = dir;
            EnumFacing dirpos = dirdir.func_176746_e();
            BlockPos pos2 = this.field_174879_c;
            if (source.func_177230_c() == Blocks.field_150355_j || source.func_177230_c() == Blocks.field_150358_i) {
                if (dirdir.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
                    dirdir = dirdir.func_176734_d();
                    pos2 = pos2.func_177967_a(dirdir, -1);
                }
                if ((dirpos = dirdir.func_176746_e()).func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
                    dirpos = dirpos.func_176734_d();
                }
                ents = this.field_145850_b.func_72872_a(EntityItem.class, this.getAABB(pos2, pos2.func_177984_a().func_177967_a(dirdir, 2).func_177972_a(dirpos)));
            } else {
                ents = this.field_145850_b.func_72872_a(EntityItem.class, this.getAABB(this.field_174879_c));
            }
            if (ents.size() > 0) {
                for (int e = ents.size() - 1; e >= 0; --e) {
                    ent = (EntityItem)ents.get(e);
                    Item it = ent.func_92059_d().func_77973_b();
                    if (it != itemGravel && it != itemSand && (!OresBase.sluiceAllowDirt || it != itemDirt)) continue;
                    ent.field_70159_w += BlockSluice.getFlowVec((IBlockState)state).field_72450_a * 0.014;
                    ent.field_70179_y += BlockSluice.getFlowVec((IBlockState)state).field_72449_c * 0.014;
                }
            }
        }
    }

    private void mergeStacks(ItemStack stack) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        float rx = 0.4f + this.rand.nextFloat() * 0.2f;
        float ry = this.rand.nextFloat() * 0.25f + 0.25f;
        float rz = 0.4f + this.rand.nextFloat() * 0.2f;
        EntityItem entityItem = new EntityItem(this.field_145850_b, (double)((float)this.field_174879_c.func_177958_n() + rx), (double)((float)this.field_174879_c.func_177956_o() + ry), (double)((float)this.field_174879_c.func_177952_p() + rz), stack);
        entityItem.field_70159_w = 0.0;
        entityItem.field_70181_x = 0.0;
        entityItem.field_70179_y = 0.0;
        entityItem.func_174867_a(10);
        this.field_145850_b.func_72838_d((Entity)entityItem);
    }

    private AxisAlignedBB getAABB(BlockPos p) {
        return new AxisAlignedBB((double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p(), (double)(p.func_177958_n() + 1), (double)p.func_177956_o() + 0.25, (double)(p.func_177952_p() + 1));
    }

    private AxisAlignedBB getAABB(BlockPos p1, BlockPos p2) {
        return new AxisAlignedBB((double)Math.min(p1.func_177958_n(), p2.func_177958_n()), (double)Math.min(p1.func_177956_o(), p2.func_177956_o()), (double)Math.min(p1.func_177952_p(), p2.func_177952_p()), (double)Math.max(p1.func_177958_n(), p2.func_177958_n()), (double)Math.max(p1.func_177956_o(), p2.func_177956_o()), (double)Math.max(p1.func_177952_p(), p2.func_177952_p()));
    }

    private AxisAlignedBB getAABB(int x, int y, int z) {
        if (this.suckZone == null) {
            this.suckZone = new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 1), (double)y + 0.25, (double)(z + 1));
        }
        return this.suckZone;
    }

    private void updateWater() {
        Material mat;
        int prevWater = this.waterAmount;
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        EnumFacing dir = ((EnumFacing)state.func_177229_b((IProperty)BlockSluice.FACING)).func_176734_d();
        IBlockState source = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(dir));
        if (source.func_177230_c() == Blocks.field_150355_j || source.func_177230_c() == Blocks.field_150358_i) {
            this.waterAmount = 8 - (Integer)source.func_177229_b((IProperty)BlockLiquid.field_176367_b);
        } else if (source.func_177230_c() == OresBase.sluice) {
            this.waterAmount = ((TileEntityBasicSluice)this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir))).getWaterAmount() - 2;
        }
        dir = dir.func_176746_e();
        Material left = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(dir)).func_185904_a();
        Material right = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(dir.func_176734_d())).func_185904_a();
        if (left == Material.field_151579_a || left == Material.field_151578_c || left == Material.field_151577_b || left == Material.field_151595_p || right == Material.field_151579_a || right == Material.field_151578_c || right == Material.field_151577_b || right == Material.field_151595_p) {
            this.waterAmount = 0;
        }
        if (prevWater != this.waterAmount) {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        }
        dir = (EnumFacing)state.func_177229_b((IProperty)BlockSluice.FACING);
        if (this.waterAmount > 0 && !this.field_145850_b.field_72995_K && (mat = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(dir).func_177977_b()).func_185904_a()) == Material.field_151579_a) {
            IBlockState st = Blocks.field_150358_i.func_176223_P().func_177226_a((IProperty)BlockDynamicLiquid.field_176367_b, (Comparable)Integer.valueOf(0));
            this.field_145850_b.func_180501_a(this.field_174879_c.func_177972_a(dir).func_177977_b(), st, 3);
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (!this.inputSlot.getStackInSlot(0).func_190926_b() && this.inputSlot.getStackInSlot(0).func_190916_E() >= (this.downstremrequests > 0 ? 1 : 0) + 1) {
                return null;
            }
            return (T)this.inputSlot;
        }
        return (T)super.getCapability(capability, facing);
    }

    public int getWaterAmount() {
        return this.waterAmount > 0 ? this.waterAmount : 0;
    }

    public int getTime() {
        return this.timer;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 3, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("harderores:inputSlot", (NBTBase)this.inputSlot.serializeNBT());
        compound.func_74768_a("harderores:timer", this.timer);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (this.inputSlot == null) {
            this.inputSlot = new ItemStackHandler();
        }
        if (compound.func_74764_b("harderores:inputSlot")) {
            this.inputSlot.deserializeNBT((NBTTagCompound)compound.func_74781_a("harderores:inputSlot"));
        }
        this.timer = compound.func_74762_e("harderores:timer");
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }
}

