/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.ores.entities;

import com.draco18s.hardlib.api.HardLibAPI;
import com.draco18s.hardlib.api.blockproperties.Props;
import com.draco18s.hardlib.api.blockproperties.ores.AxelOrientation;
import com.draco18s.hardlib.api.blockproperties.ores.MillstoneOrientation;
import com.draco18s.hardlib.api.capability.CapabilityMechanicalPower;
import com.draco18s.hardlib.api.capability.RawMechanicalPowerHandler;
import com.draco18s.hardlib.api.interfaces.IMechanicalPower;
import com.draco18s.hardlib.api.internal.inventory.OutputItemStackHandler;
import com.draco18s.ores.OresBase;
import com.draco18s.ores.entities.capabilities.MillableItemsHandler;
import com.draco18s.ores.entities.capabilities.MillstoneMechanicalPowerHandler;
import java.util.Random;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class TileEntityMillstone
extends TileEntity
implements ITickable {
    protected ItemStackHandler inputSlot = new MillableItemsHandler(1);
    protected ItemStackHandler outputSlot = new ItemStackHandler();
    private ItemStackHandler outputSlotWrapper;
    protected RawMechanicalPowerHandler powerUser = new MillstoneMechanicalPowerHandler();
    private float grindTime;
    private float powerLevel = 1.0f;

    public TileEntityMillstone() {
        this.outputSlotWrapper = new OutputItemStackHandler(this.outputSlot);
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() != this.func_145838_q()) {
            return;
        }
        MillstoneOrientation millpos = (MillstoneOrientation)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)Props.MILL_ORIENTATION);
        if (millpos == MillstoneOrientation.CENTER) {
            if (this.grindTime > 0.0f) {
                float pow = this.calcAndGetPower();
                this.grindTime -= pow;
                if (this.inputSlot.getStackInSlot(0).func_190926_b()) {
                    this.grindTime = 0.0f;
                } else if (this.grindTime <= 0.0f) {
                    IBlockState s;
                    this.grindItem(millpos);
                    if (!this.outputSlot.getStackInSlot(0).func_190926_b() && (this.outputSlot.getStackInSlot(0).func_190916_E() >= 8 || this.inputSlot.getStackInSlot(0).func_190926_b()) && !this.field_145850_b.field_72995_K && (s = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b())).func_177230_c().isAir(s, (IBlockAccess)this.field_145850_b, this.field_174879_c)) {
                        Random rand = this.field_145850_b.field_73012_v;
                        float rx = rand.nextFloat() * 0.6f + 0.2f;
                        float ry = rand.nextFloat() * 0.2f + 0.6f - 1.0f;
                        float rz = rand.nextFloat() * 0.6f + 0.2f;
                        EntityItem entityItem = new EntityItem(this.field_145850_b, (double)((float)this.field_174879_c.func_177958_n() + rx), (double)((float)this.field_174879_c.func_177956_o() + ry), (double)((float)this.field_174879_c.func_177952_p() + rz), this.outputSlot.extractItem(0, 64, false));
                        this.field_145850_b.func_72838_d((Entity)entityItem);
                        entityItem.field_70159_w = 0.0;
                        entityItem.field_70181_x = -0.2f;
                        entityItem.field_70179_y = 0.0;
                    }
                }
                this.func_70296_d();
            } else if (this.canGrind(millpos)) {
                this.grindTime = 400.0f;
                OresBase.proxy.startMillSound(this);
            }
        } else if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(millpos.offset.func_177958_n(), 0, millpos.offset.func_177952_p())).func_177230_c() == this.field_145854_h && !this.inputSlot.getStackInSlot(0).func_190926_b()) {
            TileEntity centerTE = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(millpos.offset.func_177958_n(), 0, millpos.offset.func_177952_p()));
            IItemHandler inven = (IItemHandler)centerTE.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.EAST);
            ItemStack stack = this.inputSlot.getStackInSlot(0).func_77946_l();
            stack.func_190920_e(1);
            if (inven != null && inven.insertItem(0, stack, true).func_190926_b()) {
                this.inputSlot.setStackInSlot(0, inven.insertItem(0, this.inputSlot.getStackInSlot(0), false));
            }
        }
    }

    public float getPower() {
        return this.calcAndGetPower();
    }

    private float calcAndGetPower() {
        TileEntity te;
        if (this.field_145850_b.field_72995_K) {
            return this.powerUser.getScaledPower(this.powerUser.getRawPower());
        }
        int numBlocksOut = 0;
        BlockPos p = this.field_174879_c;
        EnumFacing searchDir = EnumFacing.UP;
        do {
            if (this.field_145850_b.func_180495_p(p = p.func_177967_a(searchDir, 1)).func_177230_c() == OresBase.axel) {
                searchDir = this.field_145850_b.func_180495_p(p).func_177229_b((IProperty)Props.AXEL_ORIENTATION) == AxelOrientation.UP ? EnumFacing.UP : (EnumFacing)this.field_145850_b.func_180495_p(p).func_177229_b((IProperty)BlockHorizontal.field_185512_D);
                ++numBlocksOut;
                continue;
            }
            p = p.func_177972_a(searchDir.func_176734_d());
            numBlocksOut = 999;
        } while (numBlocksOut <= 8);
        IBlockState s = this.field_145850_b.func_180495_p(p);
        if (s.func_177230_c() == OresBase.axel && s.func_177229_b((IProperty)Props.AXEL_ORIENTATION) == AxelOrientation.HUB && (te = this.field_145850_b.func_175625_s(p)).hasCapability(CapabilityMechanicalPower.MECHANICAL_POWER_CAPABILITY, searchDir)) {
            IMechanicalPower pow = (IMechanicalPower)te.getCapability(CapabilityMechanicalPower.MECHANICAL_POWER_CAPABILITY, searchDir);
            this.powerUser.setRawPower(pow.getRawPower());
            return this.powerUser.getScaledPower(this.powerUser.getRawPower());
        }
        return 0.0f;
    }

    private void grindItem(MillstoneOrientation millpos) {
        if (this.canGrind(millpos)) {
            ItemStack result = HardLibAPI.oreMachines.getMillResult(this.inputSlot.getStackInSlot(0)).func_77946_l();
            this.outputSlot.insertItem(0, result, false);
            this.inputSlot.extractItem(0, 1, false);
            this.func_70296_d();
        }
    }

    public boolean canGrind(MillstoneOrientation millpos) {
        if (millpos != MillstoneOrientation.CENTER || this.inputSlot.getStackInSlot(0).func_190926_b()) {
            return false;
        }
        ItemStack result = HardLibAPI.oreMachines.getMillResult(this.inputSlot.getStackInSlot(0));
        return !result.func_190926_b();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        MillstoneOrientation millpos;
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            this.func_70296_d();
            if (this.field_145850_b != null && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() != this.func_145838_q()) {
                return (T)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputSlot, this.outputSlotWrapper});
            }
            if (facing == null) {
                return (T)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputSlot, this.outputSlot});
            }
            if (this.field_145850_b == null) {
                if (facing == EnumFacing.UP) {
                    return (T)this.inputSlot;
                }
                if (facing == EnumFacing.DOWN) {
                    return (T)this.outputSlotWrapper;
                }
                return (T)super.getCapability(capability, facing);
            }
            millpos = (MillstoneOrientation)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)Props.MILL_ORIENTATION);
            if (millpos.canAcceptInput && facing == EnumFacing.UP) {
                return (T)this.inputSlot;
            }
            if (millpos.canAcceptOutput && facing == EnumFacing.DOWN) {
                return (T)this.outputSlotWrapper;
            }
            if (millpos == MillstoneOrientation.CENTER && facing == EnumFacing.EAST) {
                return (T)this.inputSlot;
            }
        }
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER_CAPABILITY && (millpos = (MillstoneOrientation)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)Props.MILL_ORIENTATION)) == MillstoneOrientation.CENTER) {
            return (T)this.powerUser;
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("harderores:power", (NBTBase)this.powerUser.serializeNBT());
        compound.func_74782_a("harderores:inputSlot", (NBTBase)this.inputSlot.serializeNBT());
        compound.func_74782_a("harderores:outputSlot", (NBTBase)this.outputSlot.serializeNBT());
        compound.func_74776_a("harderores:grindTime", this.grindTime);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (this.inputSlot == null) {
            this.inputSlot = new MillableItemsHandler(1);
            this.outputSlot = new ItemStackHandler();
            this.outputSlotWrapper = new OutputItemStackHandler(this.outputSlot);
        }
        if (compound.func_74764_b("harderores:inputSlot")) {
            this.inputSlot.deserializeNBT((NBTTagCompound)compound.func_74781_a("harderores:inputSlot"));
        }
        if (compound.func_74764_b("harderores:outputSlot")) {
            this.outputSlot.deserializeNBT((NBTTagCompound)compound.func_74781_a("harderores:outputSlot"));
        }
        if (compound.func_74764_b("harderores:power")) {
            this.powerUser.deserializeNBT((NBTTagCompound)compound.func_74781_a("harderores:power"));
        }
        this.grindTime = compound.func_74760_g("harderores:grindTime");
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public float getGrindTime() {
        return this.grindTime;
    }
}

