/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.ores.entities;

import com.draco18s.hardlib.api.HardLibAPI;
import com.draco18s.hardlib.api.blockproperties.Props;
import com.draco18s.hardlib.api.blockproperties.ores.AxelOrientation;
import com.draco18s.hardlib.api.capability.CapabilityMechanicalPower;
import com.draco18s.hardlib.api.capability.RawMechanicalPowerHandler;
import com.draco18s.hardlib.api.interfaces.IMechanicalPower;
import com.draco18s.hardlib.api.internal.inventory.OutputItemStackHandler;
import com.draco18s.ores.OresBase;
import com.draco18s.ores.entities.capabilities.PackableItemsHandler;
import com.draco18s.ores.entities.capabilities.PackagerMechanicalPowerHandler;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class TileEntityPackager
extends TileEntity
implements ITickable {
    protected ItemStackHandler inputSlot = new PackableItemsHandler();
    protected ItemStackHandler outputSlot = new ItemStackHandler();
    private ItemStackHandler outputSlotWrapper;
    private float packTime = 0.0f;
    private float timeMod = 1.0f;
    protected RawMechanicalPowerHandler powerUser = new PackagerMechanicalPowerHandler();
    private int activeSlot = -1;

    public TileEntityPackager() {
        this.outputSlotWrapper = new OutputItemStackHandler(this.outputSlot);
    }

    public void func_73660_a() {
        block14: {
            block12: {
                block13: {
                    if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() != this.func_145838_q()) {
                        return;
                    }
                    if (!(this.packTime > 0.0f)) break block12;
                    float pow = this.calcAndGetPower() / this.timeMod;
                    this.packTime -= pow;
                    boolean canAnyPack = false;
                    int resetTime = -1;
                    for (int s = 0; s < this.inputSlot.getSlots(); ++s) {
                        if (!this.canPackage(s)) continue;
                        canAnyPack = true;
                        resetTime = s;
                    }
                    if (resetTime != this.activeSlot) {
                        this.activeSlot = resetTime;
                        this.packTime = 100.0f;
                    }
                    if (canAnyPack) break block13;
                    this.packTime = 0.0f;
                    break block14;
                }
                if (!(this.packTime <= 0.0f)) break block14;
                this.packItem();
                break block14;
            }
            this.activeSlot = -1;
            for (int s = 0; s < this.inputSlot.getSlots(); ++s) {
                IBlockState state;
                Block block;
                if (!this.canPackage(s)) continue;
                this.activeSlot = s;
                this.packTime = 100.0f;
                ItemStack nextResult = HardLibAPI.oreMachines.getPressurePackResult(this.inputSlot.getStackInSlot(s), true);
                float inMod = 1.0f;
                float outMod = 1.0f;
                if (this.inputSlot.getStackInSlot(s).func_77973_b() instanceof ItemBlock) {
                    try {
                        block = Block.func_149634_a((Item)this.inputSlot.getStackInSlot(s).func_77973_b());
                        state = block.func_180642_a(null, BlockPos.field_177992_a, EnumFacing.DOWN, 0.0f, 0.0f, 0.0f, nextResult.func_77960_j(), null);
                        inMod = state.func_185887_b(null, BlockPos.field_177992_a) * 2.0f;
                        if (block.getHarvestTool(state).equals("pickaxe") && block.getHarvestLevel(state) >= 0) {
                            inMod *= (float)(block.getHarvestLevel(state) + 2);
                        }
                    }
                    catch (NullPointerException e) {
                        inMod = 1.0f;
                    }
                }
                if (!nextResult.func_190926_b() && nextResult.func_77973_b() instanceof ItemBlock) {
                    try {
                        block = Block.func_149634_a((Item)nextResult.func_77973_b());
                        state = block.func_180642_a(null, BlockPos.field_177992_a, EnumFacing.DOWN, 0.0f, 0.0f, 0.0f, nextResult.func_77960_j(), null);
                        outMod = state.func_185887_b(null, BlockPos.field_177992_a);
                        if (block.getHarvestTool(state).equals("shovel") && block.getHarvestLevel(state) >= 0) {
                            outMod *= 2.0f;
                        }
                    }
                    catch (NullPointerException e) {
                        outMod = 1.0f;
                    }
                }
                this.timeMod = Math.max(inMod, outMod);
            }
        }
    }

    private float calcAndGetPower() {
        TileEntity te;
        if (this.field_145850_b.field_72995_K) {
            return this.powerUser.getScaledPower(this.powerUser.getRawPower());
        }
        int numBlocksOut = 0;
        BlockPos p = this.field_174879_c;
        EnumFacing searchDir = EnumFacing.UP;
        do {
            if (this.field_145850_b.func_180495_p(p = p.func_177967_a(searchDir, 1)).func_177230_c() == OresBase.axel) {
                searchDir = this.field_145850_b.func_180495_p(p).func_177229_b((IProperty)Props.AXEL_ORIENTATION) == AxelOrientation.UP ? EnumFacing.UP : (EnumFacing)this.field_145850_b.func_180495_p(p).func_177229_b((IProperty)BlockHorizontal.field_185512_D);
                ++numBlocksOut;
                continue;
            }
            p = p.func_177972_a(searchDir.func_176734_d());
            numBlocksOut = 999;
        } while (numBlocksOut <= 8);
        IBlockState s = this.field_145850_b.func_180495_p(p);
        if (s.func_177230_c() == OresBase.axel && s.func_177229_b((IProperty)Props.AXEL_ORIENTATION) == AxelOrientation.HUB && (te = this.field_145850_b.func_175625_s(p)).hasCapability(CapabilityMechanicalPower.MECHANICAL_POWER_CAPABILITY, searchDir)) {
            IMechanicalPower pow = (IMechanicalPower)te.getCapability(CapabilityMechanicalPower.MECHANICAL_POWER_CAPABILITY, searchDir);
            this.powerUser.setRawPower(pow.getRawPower());
            return this.powerUser.getScaledPower(this.powerUser.getRawPower());
        }
        this.func_70296_d();
        return 0.0f;
    }

    private boolean canPackage(int slot) {
        if (this.inputSlot.getStackInSlot(slot).func_190926_b()) {
            return false;
        }
        ItemStack result = HardLibAPI.oreMachines.getPressurePackResult(this.inputSlot.getStackInSlot(slot), true);
        if (result.func_190926_b()) {
            return false;
        }
        return this.outputSlot.insertItem(0, result, true).func_190926_b();
    }

    private void packItem() {
        for (int s = 0; s < this.inputSlot.getSlots(); ++s) {
            ItemStack result;
            ItemStack stack = this.inputSlot.getStackInSlot(s);
            if (stack.func_190926_b() || (result = HardLibAPI.oreMachines.getPressurePackResult(stack, true)).func_190926_b() || !this.outputSlot.insertItem(0, result, true).func_190926_b()) continue;
            this.inputSlot.extractItem(s, HardLibAPI.oreMachines.getPressurePackAmount(stack), false);
            this.outputSlot.insertItem(0, result.func_77946_l(), false);
        }
        this.func_70296_d();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            this.func_70296_d();
            if (this.field_145850_b != null && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() != this.func_145838_q()) {
                return (T)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputSlot, this.outputSlotWrapper});
            }
            if (facing == null) {
                return (T)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputSlot, this.outputSlotWrapper});
            }
            if (facing == EnumFacing.UP) {
                return (T)this.inputSlot;
            }
            if (facing == EnumFacing.DOWN) {
                return (T)this.outputSlotWrapper;
            }
        }
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER_CAPABILITY) {
            return (T)this.powerUser;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 3, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("harderores:power", (NBTBase)this.powerUser.serializeNBT());
        compound.func_74782_a("harderores:inputSlot", (NBTBase)this.inputSlot.serializeNBT());
        compound.func_74782_a("harderores:outputSlot", (NBTBase)this.outputSlot.serializeNBT());
        compound.func_74776_a("harderores:packTime", this.packTime);
        compound.func_74776_a("harderores:timeMod", this.timeMod);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (this.inputSlot == null) {
            this.inputSlot = new PackableItemsHandler();
            this.outputSlot = new ItemStackHandler();
            this.outputSlotWrapper = new OutputItemStackHandler(this.outputSlot);
        }
        if (compound.func_74764_b("harderores:inputSlot")) {
            this.inputSlot.deserializeNBT((NBTTagCompound)compound.func_74781_a("harderores:inputSlot"));
        }
        if (compound.func_74764_b("harderores:outputSlot")) {
            this.outputSlot.deserializeNBT((NBTTagCompound)compound.func_74781_a("harderores:outputSlot"));
        }
        if (compound.func_74764_b("harderores:power")) {
            this.powerUser.deserializeNBT((NBTTagCompound)compound.func_74781_a("harderores:power"));
        }
        this.packTime = compound.func_74760_g("harderores:packTime");
        this.timeMod = compound.func_74760_g("harderores:timeMod");
    }

    public float getTime() {
        return this.packTime;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }
}

