/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.ores.entities;

import com.draco18s.hardlib.api.HardLibAPI;
import com.draco18s.hardlib.api.internal.inventory.OutputItemStackHandler;
import com.draco18s.ores.entities.capabilities.SiftableItemsHandler;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class TileEntitySifter
extends TileEntity
implements ITickable {
    protected ItemStackHandler inputSlot = new SiftableItemsHandler();
    protected ItemStackHandler outputSlot = new ItemStackHandler();
    private ItemStackHandler outputSlotWrapper = new OutputItemStackHandler(this.outputSlot);
    private float siftTime;
    private int activeSlot = -1;

    public void func_73660_a() {
        block6: {
            block4: {
                block5: {
                    if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() != this.func_145838_q()) {
                        return;
                    }
                    this.suckItems();
                    if (!(this.siftTime > 0.0f)) break block4;
                    this.siftTime -= 1.0f;
                    boolean canAnySift = false;
                    int resetTime = -1;
                    for (int s = 0; s < this.inputSlot.getSlots(); ++s) {
                        if (!this.canSift(s)) continue;
                        canAnySift = true;
                        resetTime = s;
                    }
                    if (resetTime != this.activeSlot) {
                        this.activeSlot = resetTime;
                        this.siftTime = 100.0f;
                    }
                    if (canAnySift) break block5;
                    this.siftTime = 0.0f;
                    break block6;
                }
                if (!(this.siftTime <= 0.0f)) break block6;
                this.siftItem();
                break block6;
            }
            this.activeSlot = -1;
            for (int s = 0; s < this.inputSlot.getSlots(); ++s) {
                if (!this.canSift(s)) continue;
                this.siftTime = 40.0f;
                this.activeSlot = s;
            }
        }
    }

    private boolean canSift(int slot) {
        if (this.inputSlot.getStackInSlot(slot) == null) {
            return false;
        }
        ItemStack result = HardLibAPI.oreMachines.getSiftResult(this.inputSlot.getStackInSlot(slot), true);
        if (result.func_190926_b()) {
            return false;
        }
        return this.outputSlot.insertItem(0, result, true).func_190926_b();
    }

    private void siftItem() {
        for (int s = 0; s < this.inputSlot.getSlots(); ++s) {
            ItemStack result;
            ItemStack stack = this.inputSlot.getStackInSlot(s);
            if (stack.func_190926_b() || (result = HardLibAPI.oreMachines.getSiftResult(stack, true)).func_190926_b() || !this.outputSlot.insertItem(0, result, true).func_190926_b()) continue;
            this.inputSlot.extractItem(s, HardLibAPI.oreMachines.getSiftAmount(stack), false);
            this.outputSlot.insertItem(0, result.func_77946_l(), false);
        }
    }

    private void suckItems() {
        List ents = this.field_145850_b.func_72872_a(EntityItem.class, this.getAABB(this.field_174879_c));
        if (ents.size() > 0) {
            for (int e = ents.size() - 1; e >= 0; --e) {
                EntityItem ent = (EntityItem)ents.get(e);
                ItemStack stack = ent.func_92059_d().func_77946_l();
                if (HardLibAPI.oreMachines.getSiftResult(stack, false) == null) continue;
                if (!(stack = this.inputSlot.insertItem(0, stack, false)).func_190926_b()) {
                    stack = this.inputSlot.insertItem(1, stack, false);
                }
                if (!stack.func_190926_b()) {
                    ent.func_92058_a(stack);
                } else {
                    ent.func_70106_y();
                }
                this.func_70296_d();
            }
        }
    }

    private AxisAlignedBB getAABB(BlockPos p) {
        return new AxisAlignedBB((double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p(), (double)(p.func_177958_n() + 1), (double)p.func_177956_o() + 1.25, (double)(p.func_177952_p() + 1));
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            this.func_70296_d();
            if (this.field_145850_b != null && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() != this.func_145838_q()) {
                return (T)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputSlot, this.outputSlotWrapper});
            }
            if (facing == null) {
                return (T)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputSlot, this.outputSlotWrapper});
            }
            if (facing == EnumFacing.UP) {
                return (T)this.inputSlot;
            }
            if (facing == EnumFacing.DOWN) {
                return (T)this.outputSlotWrapper;
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 3, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("harderores:inputSlot", (NBTBase)this.inputSlot.serializeNBT());
        compound.func_74782_a("harderores:outputSlot", (NBTBase)this.outputSlot.serializeNBT());
        compound.func_74776_a("harderores:siftTime", this.siftTime);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (this.inputSlot == null) {
            this.inputSlot = new SiftableItemsHandler();
            this.outputSlot = new ItemStackHandler();
            this.outputSlotWrapper = new OutputItemStackHandler(this.outputSlot);
        }
        if (compound.func_74764_b("harderores:inputSlot")) {
            this.inputSlot.deserializeNBT((NBTTagCompound)compound.func_74781_a("harderores:inputSlot"));
            this.outputSlot.deserializeNBT((NBTTagCompound)compound.func_74781_a("harderores:outputSlot"));
        }
        this.siftTime = compound.func_74760_g("harderores:siftTime");
    }

    public float getTime() {
        return this.siftTime;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }
}

