/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.ores.recipes;

import com.draco18s.hardlib.api.interfaces.IHardOreProcessing;
import com.draco18s.ores.entities.TileEntityBasicSluice;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class OreProcessingRecipes
implements IHardOreProcessing {
    private static Map<ItemStack, ItemStack> millRecipes = Maps.newHashMap();
    private static Map<ItemStack, ItemStack> siftRecipes = Maps.newHashMap();
    private static Map<ItemStack, ItemStack> packingRecipes = Maps.newHashMap();
    private static List<Block> sluiceRecipes = new ArrayList<Block>();

    public void addSiftRecipe(ItemStack input, ItemStack output, boolean registerOutput) {
        siftRecipes.put(input, output);
        if (registerOutput && input != output) {
            output = output.func_77946_l();
            output.func_190920_e(1);
            siftRecipes.put(output, output);
        }
    }

    public void addSiftRecipe(ItemStack input, ItemStack output) {
        this.addSiftRecipe(input, output, true);
    }

    public void addSiftRecipe(String input, int stackSize, ItemStack output, boolean registerOutput) {
        NonNullList stk = OreDictionary.getOres((String)input);
        for (ItemStack stack : stk) {
            ItemStack s = stack.func_77946_l();
            s.func_190920_e(stackSize);
            this.addSiftRecipe(s, output, registerOutput);
        }
    }

    public void addSiftRecipe(String input, int stackSize, ItemStack output) {
        this.addSiftRecipe(input, stackSize, output, true);
    }

    public void addMillRecipe(ItemStack input, ItemStack output) {
        millRecipes.put(input, output);
    }

    public int getSiftAmount(ItemStack stack) {
        Map.Entry<ItemStack, ItemStack> entry;
        Iterator<Map.Entry<ItemStack, ItemStack>> iterator = siftRecipes.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return 0;
        } while (!this.compareItemStacks(stack, (entry = iterator.next()).getKey()));
        return entry.getKey().func_190916_E();
    }

    @Nonnull
    public ItemStack getSiftResult(ItemStack stack, boolean checkStackSize) {
        for (Map.Entry<ItemStack, ItemStack> entry : siftRecipes.entrySet()) {
            if (!this.compareItemStacks(stack, entry.getKey(), checkStackSize)) continue;
            return entry.getValue();
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack getMillResult(ItemStack stack) {
        for (Map.Entry<ItemStack, ItemStack> entry : millRecipes.entrySet()) {
            if (!this.compareItemStacks(stack, entry.getKey())) continue;
            return entry.getValue();
        }
        return ItemStack.field_190927_a;
    }

    private boolean compareItemStacks(ItemStack stack1, ItemStack stack2) {
        return this.compareItemStacks(stack1, stack2, false);
    }

    private boolean compareItemStacks(ItemStack key, ItemStack entry, boolean keyStackBiggerThanEntry) {
        return !(entry.func_77973_b() != key.func_77973_b() || entry.func_77960_j() != Short.MAX_VALUE && entry.func_77960_j() != key.func_77960_j() || keyStackBiggerThanEntry && key.func_190916_E() < entry.func_190916_E());
    }

    public void addSluiceRecipe(Block output) {
        sluiceRecipes.add(output);
    }

    @Nonnull
    public Block getRandomSluiceResult(Random rand, Item item) {
        Block oreAttempt;
        boolean isDirtOrSand = item == TileEntityBasicSluice.itemSand || item == TileEntityBasicSluice.itemDirt;
        do {
            oreAttempt = this.getRandomSluiceResult(rand, isDirtOrSand);
        } while (isDirtOrSand && oreAttempt == Blocks.field_150351_n);
        return oreAttempt;
    }

    private Block getRandomSluiceResult(Random rand) {
        return sluiceRecipes.get(rand.nextInt(sluiceRecipes.size()));
    }

    private Block getRandomSluiceResult(Random rand, Boolean skipGravel) {
        int v = (int)Math.ceil((float)sluiceRecipes.size() * 0.75f);
        return sluiceRecipes.get(rand.nextInt(v));
    }

    public List<Block> getRandomSluiceResults(Random rand, Item item) {
        ArrayList<Block> list = new ArrayList<Block>();
        for (int i = sluiceRecipes.size(); i >= 0; i -= 12) {
            list.add(this.getRandomSluiceResult(rand, item));
        }
        return list;
    }

    public void addPressurePackRecipe(ItemStack input, ItemStack output) {
        packingRecipes.put(input, output);
    }

    @Nonnull
    public ItemStack getPressurePackResult(ItemStack stack, boolean checkStackSize) {
        for (Map.Entry<ItemStack, ItemStack> entry : packingRecipes.entrySet()) {
            if (!this.compareItemStacks(stack, entry.getKey(), checkStackSize)) continue;
            return entry.getValue();
        }
        return ItemStack.field_190927_a;
    }

    public int getPressurePackAmount(ItemStack stack) {
        Map.Entry<ItemStack, ItemStack> entry;
        Iterator<Map.Entry<ItemStack, ItemStack>> iterator = packingRecipes.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return 0;
        } while (!this.compareItemStacks(stack, (entry = iterator.next()).getKey()));
        return entry.getKey().func_190916_E();
    }
}

