/*
 * Decompiled with CFR 0.152.
 */
package org.mystia.craft.instantlava.config;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import org.mystia.craft.instantlava.config.Configurator;

public final class ConfigCommands {
    private ConfigCommands() {
    }

    public static void init() {
        Helpers.init();
    }

    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        LiteralArgumentBuilder literalArgumentBuilder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"instantlava").requires(commandSource -> commandSource.func_197034_c(2));
        ConfigCommands.addBooleanOption(literalArgumentBuilder, "enabled", "InstantLava", () -> Configurator.options.enabled, bl -> {
            Configurator.options.enabled = bl;
        });
        ConfigCommands.addBooleanOption(literalArgumentBuilder, "netherOnly", "InstantLava: Nether-only mode", () -> Configurator.options.netherOnly, bl -> {
            Configurator.options.netherOnly = bl;
        });
        commandDispatcher.register(literalArgumentBuilder);
    }

    private static void addBooleanOption(ArgumentBuilder<CommandSource, ?> argumentBuilder, String string, String string2, Supplier<Boolean> supplier, Consumer<Boolean> consumer) {
        argumentBuilder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)string).executes(commandContext -> {
            boolean bl = (Boolean)supplier.get();
            ((CommandSource)commandContext.getSource()).func_197030_a(ConfigCommands.makeText(string2, false, bl), false);
            return ConfigCommands.toInt(bl);
        })).then(Commands.func_197056_a((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(commandContext -> {
            boolean bl = BoolArgumentType.getBool((CommandContext)commandContext, (String)"value");
            consumer.accept(bl);
            Configurator.save();
            ((CommandSource)commandContext.getSource()).func_197030_a(ConfigCommands.makeText(string2, true, bl), true);
            return ConfigCommands.toInt(bl);
        })));
    }

    private static int toInt(boolean bl) {
        return bl ? 1 : 0;
    }

    private static ITextComponent makeText(String string, boolean bl, boolean bl2) {
        ITextComponent iTextComponent = Helpers.newStringTextComponent(string + " is " + (bl ? "now" : "currently") + " [");
        iTextComponent.func_150257_a(Helpers.newStringTextComponent(bl2 ? "enabled" : "disabled").func_211708_a(bl2 ? TextFormatting.GREEN : TextFormatting.RED));
        iTextComponent.func_150257_a(Helpers.newStringTextComponent("]"));
        return iTextComponent;
    }

    private static final class Helpers {
        private static final MethodHandle newStringTextComponent;

        private Helpers() {
        }

        public static void init() {
        }

        public static ITextComponent newStringTextComponent(String string) {
            try {
                return newStringTextComponent.invokeExact(string);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        static {
            try {
                Class<?> clazz;
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                try {
                    clazz = Class.forName("net.minecraft.util.text.TextComponentString");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    clazz = Class.forName("net.minecraft.util.text.StringTextComponent");
                }
                newStringTextComponent = lookup.unreflectConstructor(clazz.getConstructor(String.class)).asType(MethodType.methodType(ITextComponent.class, String.class));
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                throw new RuntimeException(reflectiveOperationException);
            }
        }
    }
}

