/*
 * Decompiled with CFR 0.152.
 */
package org.mystia.craft.instantlava.hook;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.LavaFluid;
import net.minecraft.world.dimension.Dimension;
import org.mystia.craft.instantlava.config.ConfigOptions;
import org.mystia.craft.instantlava.config.Configurator;

public final class FlowingFluidHook {
    private FlowingFluidHook() {
    }

    public static void init() {
        Helpers.init();
    }

    public static boolean canSourcesMultiplyHook(FlowingFluid flowingFluid, Object object) {
        boolean bl = Helpers.canSourcesMultiply(flowingFluid);
        if (flowingFluid instanceof LavaFluid) {
            ConfigOptions configOptions = Configurator.options;
            if (configOptions.enabled && (!configOptions.netherOnly || Helpers.isInNether(object))) {
                bl = true;
            }
        }
        return bl;
    }

    private static final class Helpers {
        private static final MethodHandle getDimension;
        private static final MethodHandle canSourcesMultiply;

        private Helpers() {
        }

        public static void init() {
        }

        private static Dimension getDimension(Object object) {
            try {
                return getDimension.invokeExact(object);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        public static boolean canSourcesMultiply(FlowingFluid flowingFluid) {
            try {
                return canSourcesMultiply.invokeExact(flowingFluid);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        public static boolean isInNether(Object object) {
            return Helpers.getDimension(object).func_186058_p().func_186068_a() == -1;
        }

        static {
            try {
                Class<?> clazz;
                try {
                    clazz = Class.forName("net.minecraft.world.IWorldReaderBase");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    clazz = Class.forName("net.minecraft.world.IWorldReader");
                }
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                getDimension = lookup.unreflect(clazz.getDeclaredMethod("func_201675_m", new Class[0])).asType(MethodType.methodType(Dimension.class, Object.class));
                Method method = FlowingFluid.class.getDeclaredMethod("func_205579_d", new Class[0]);
                method.setAccessible(true);
                canSourcesMultiply = lookup.unreflect(method);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                throw new RuntimeException(reflectiveOperationException);
            }
        }
    }
}

