/** Copyright © 2020 parly. All rights reserved. */

var Opcodes = Java.type('org.objectweb.asm.Opcodes');
var VarInsnNode = Java.type('org.objectweb.asm.tree.VarInsnNode');

function initializeCoreMod() {
	return {
		instantlava: {
			target: {
				type: 'CLASS',
				name: 'net.minecraft.fluid.FlowingFluid'
			},
			transformer: function (classNode) {
				var methodNode = null;
				Java.from(classNode.methods).some(function (method) {
					if (method.name !== 'func_205576_a') {
						return;
					}
					methodNode = method;
					return true;
				});
				if (!methodNode) {
					return classNode;
				}
				var insns = methodNode.instructions;
				var iter = insns.iterator();
				var pos = -1;
				var i = -1;
				var j = 0;
				var insn;
				while (iter.hasNext()) {
					i++;
					insn = iter.next();
					var op = insn.getOpcode();
					if (j === 0 && op === Opcodes.ALOAD && insn.var === 0) {
						j++;
					} else if (j === 1 && op === Opcodes.INVOKEVIRTUAL && insn.name === 'func_205579_d') {
						pos = i;
						break;
					} else {
						i -= j;
						j = 0;
					}
				}
				if (pos === -1) {
					return classNode;
				}
				insns.insertBefore(insn, new VarInsnNode(Opcodes.ALOAD, 1));
				insn.setOpcode(Opcodes.INVOKESTATIC);
				insn.owner = 'org/mystia/craft/instantlava/hook/FlowingFluidHook';
				insn.name = 'canSourcesMultiplyHook';
				insn.desc = '(Lnet/minecraft/fluid/FlowingFluid;Ljava/lang/Object;)Z';
				insn.itf = false;
				return classNode;
			}
		}
	};
}
