/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.inventoryspam.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigData {
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static boolean showItemAdditions;
    public static boolean showItemRemovals;
    public static boolean drawIcon;
    public static boolean drawName;
    public static int drawOffsetHorizontal;
    public static int drawOffsetVertical;
    public static DrawPosition drawPosition;
    public static double drawScale;
    public static double iconScale;
    public static int softLimit;
    public static int fadeLimit;
    public static Set<String> ignoreItems;
    public static Set<String> ignoreSubitemChanges;

    public static void bake() {
        showItemAdditions = (Boolean)ConfigData.CLIENT.showItemAdditions.get();
        showItemRemovals = (Boolean)ConfigData.CLIENT.showItemRemovals.get();
        drawIcon = (Boolean)ConfigData.CLIENT.drawIcon.get();
        drawName = (Boolean)ConfigData.CLIENT.drawName.get();
        drawOffsetHorizontal = (Integer)ConfigData.CLIENT.drawOffsetHorizontal.get();
        drawOffsetVertical = (Integer)ConfigData.CLIENT.drawOffsetVertical.get();
        drawScale = (Double)ConfigData.CLIENT.drawScale.get();
        iconScale = (Double)ConfigData.CLIENT.iconScale.get();
        softLimit = (Integer)ConfigData.CLIENT.softLimit.get();
        fadeLimit = (Integer)ConfigData.CLIENT.fadeLimit.get();
        drawPosition = DrawPosition.valueOf((String)ConfigData.CLIENT.drawPosition.get());
        ignoreItems = Sets.newHashSet((Iterable)((Iterable)ConfigData.CLIENT.ignoreItems.get()));
        ignoreSubitemChanges = Sets.newHashSet((Iterable)((Iterable)ConfigData.CLIENT.ignoreSubitemChanges.get()));
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (ClientConfig)specPair.getLeft();
        showItemAdditions = true;
        showItemRemovals = true;
        drawIcon = true;
        drawName = true;
        drawPosition = DrawPosition.BottomRight;
        drawScale = 1.0;
        iconScale = 0.6;
        softLimit = 10;
        fadeLimit = 5;
        ignoreItems = Sets.newHashSet();
        ignoreSubitemChanges = Sets.newHashSet();
    }

    public static enum DrawPosition {
        BottomRight,
        Bottom,
        BottomLeft,
        Left,
        TopLeft,
        Top,
        TopRight,
        Right,
        Center;

    }

    private static class ClientConfig {
        private static final Set<String> DRAW_POSITIONS = Arrays.stream(DrawPosition.values()).map(Enum::toString).collect(Collectors.toSet());
        ForgeConfigSpec.BooleanValue showItemAdditions;
        ForgeConfigSpec.BooleanValue showItemRemovals;
        ForgeConfigSpec.BooleanValue drawIcon;
        ForgeConfigSpec.BooleanValue drawName;
        ForgeConfigSpec.ConfigValue<String> drawPosition;
        ForgeConfigSpec.IntValue drawOffsetHorizontal;
        ForgeConfigSpec.IntValue drawOffsetVertical;
        ForgeConfigSpec.DoubleValue drawScale;
        ForgeConfigSpec.DoubleValue iconScale;
        ForgeConfigSpec.IntValue softLimit;
        ForgeConfigSpec.IntValue fadeLimit;
        ForgeConfigSpec.ConfigValue<List<? extends String>> ignoreItems;
        ForgeConfigSpec.ConfigValue<List<? extends String>> ignoreSubitemChanges;

        ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            this.ignoreItems = builder.comment("Items to ignore when finding changes").translation("text.inventoryspam.config.ignore_items").defineList("ignore_items", (List)Lists.newArrayList(), o -> o instanceof String);
            this.ignoreSubitemChanges = builder.comment("Items for which to ignore NBT changes").translation("text.inventoryspam.config.ignore_subitems").defineList("ignore_subitem_changes", (List)Lists.newArrayList(), o -> o instanceof String);
            this.showItemAdditions = builder.comment("Show gained items in the overlay").translation("text.inventoryspam.config.show_item_additions").define("show_item_additions", true);
            this.showItemRemovals = builder.comment("Show lost items in the overlay").translation("text.inventoryspam.config.show_item_removals").define("show_item_removals", true);
            this.drawIcon = builder.comment("Draw item icon in the overlay").translation("text.inventoryspam.config.draw_icon").define("draw_icon", true);
            this.drawName = builder.comment("Draw item name in the overlay").translation("text.inventoryspam.config.draw_name").define("draw_name", true);
            this.drawPosition = builder.comment("Which corner/edge of the screen to base the overlay position on").translation("text.inventoryspam.config.draw_position").define("draw_position", DrawPosition.BottomRight::toString, e -> e instanceof String && DRAW_POSITIONS.contains(e));
            this.drawOffsetHorizontal = builder.comment("Horizontal offset from the chosen position to draw the overlay on").translation("text.inventoryspam.config.draw_offset_horizontal").defineInRange("draw_offset_horizontal", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.drawOffsetVertical = builder.comment("Vertical offset from the chosen position to draw the overlay on").translation("text.inventoryspam.config.draw_offset_vertical").defineInRange("draw_offset_vertical", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.drawScale = builder.comment("Size of the overlay relative to the GUI scale").translation("text.inventoryspam.config.draw_scale").defineInRange("draw_scale", 1.0, 0.001, 1000.0);
            this.iconScale = builder.comment("Size of the icons relative to the overlay size").translation("text.inventoryspam.config.icon_scale").defineInRange("icon_scale", 0.6, 0.001, 1000.0);
            this.softLimit = builder.comment("Number items to show in the overlay before older items start to get forcefully faded").translation("text.inventoryspam.config.soft_limit").defineInRange("soft_limit", 10, 1, 30);
            this.fadeLimit = builder.comment("Number of items to show progressively faded, when the soft limit is reached").translation("text.inventoryspam.config.fade_limit").defineInRange("fade_limit", 5, 0, 15);
            builder.pop();
        }
    }
}

