/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import team.creative.creativecore.CreativeCore;

public class ClientCommandRegistry {
    private static Minecraft mc = Minecraft.func_71410_x();
    private static CommandDispatcher<ISuggestionProvider> clientDispatcher = new CommandDispatcher();
    private static CombinedCommandDispatcher<ISuggestionProvider> combined = null;

    public static CommandDispatcher<ISuggestionProvider> getDispatcher(CommandDispatcher<ISuggestionProvider> vanillaDispatcher) {
        if (combined == null || combined.is(vanillaDispatcher, clientDispatcher)) {
            combined = new CombinedCommandDispatcher<ISuggestionProvider>(vanillaDispatcher, clientDispatcher);
        }
        return combined;
    }

    public static LiteralCommandNode<ISuggestionProvider> register(LiteralArgumentBuilder<ISuggestionProvider> command) {
        return clientDispatcher.register(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int handleCommand(CommandSource source, String command) {
        int n;
        StringReader stringreader = new StringReader(command);
        if (stringreader.canRead() && stringreader.peek() == '/') {
            stringreader.skip();
        }
        mc.func_213239_aq().func_76320_a(command);
        try {
            ParseResults parse = clientDispatcher.parse(stringreader, (Object)source);
            int n2 = clientDispatcher.execute(parse);
            return n2;
        }
        catch (CommandException commandexception) {
            source.func_197021_a(commandexception.func_197003_a());
            int n3 = 0;
            return n3;
        }
        catch (CommandSyntaxException commandsyntaxexception) {
            if (commandsyntaxexception.getType() == CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand()) {
                int n4 = -1;
                return n4;
            }
            source.func_197021_a(TextComponentUtils.func_202465_a((Message)commandsyntaxexception.getRawMessage()));
            if (commandsyntaxexception.getInput() != null && commandsyntaxexception.getCursor() >= 0) {
                int k = Math.min(commandsyntaxexception.getInput().length(), commandsyntaxexception.getCursor());
                ITextComponent itextcomponent1 = new StringTextComponent("").func_211708_a(TextFormatting.GRAY).func_211710_a(p_211705_1_ -> p_211705_1_.func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, command)));
                if (k > 10) {
                    itextcomponent1.func_150258_a("...");
                }
                itextcomponent1.func_150258_a(commandsyntaxexception.getInput().substring(Math.max(0, k - 10), k));
                if (k < commandsyntaxexception.getInput().length()) {
                    ITextComponent itextcomponent2 = new StringTextComponent(commandsyntaxexception.getInput().substring(k)).func_211709_a(new TextFormatting[]{TextFormatting.RED, TextFormatting.UNDERLINE});
                    itextcomponent1.func_150257_a(itextcomponent2);
                }
                itextcomponent1.func_150257_a(new TranslationTextComponent("command.context.here", new Object[0]).func_211709_a(new TextFormatting[]{TextFormatting.RED, TextFormatting.ITALIC}));
                source.func_197021_a(itextcomponent1);
            }
        }
        catch (Exception exception) {
            StringTextComponent stringtextcomponent;
            StringTextComponent itextcomponent = stringtextcomponent = new StringTextComponent(exception.getMessage() == null ? exception.getClass().getName() : exception.getMessage());
            if (CreativeCore.LOGGER.isDebugEnabled()) {
                StackTraceElement[] astacktraceelement = exception.getStackTrace();
                for (int j = 0; j < Math.min(astacktraceelement.length, 3); ++j) {
                    itextcomponent.func_150258_a("\n\n").func_150258_a(astacktraceelement[j].getMethodName()).func_150258_a("\n ").func_150258_a(astacktraceelement[j].getFileName()).func_150258_a(":").func_150258_a(String.valueOf(astacktraceelement[j].getLineNumber()));
                }
            }
            source.func_197021_a(new TranslationTextComponent("command.failed", new Object[0]).func_211710_a(arg_0 -> ClientCommandRegistry.lambda$handleCommand$1((ITextComponent)itextcomponent, arg_0)));
            int n5 = 0;
            return n5;
        }
        {
            n = 0;
        }
        return n;
        finally {
            mc.func_213239_aq().func_76319_b();
        }
    }

    private static /* synthetic */ void lambda$handleCommand$1(ITextComponent itextcomponent, Style p_211704_1_) {
        p_211704_1_.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, itextcomponent));
    }

    public static class CombinedCommandDispatcher<T>
    extends CommandDispatcher<T> {
        public final CommandDispatcher<T> first;
        public final CommandDispatcher<T> second;

        public CombinedCommandDispatcher(CommandDispatcher<T> first, CommandDispatcher<T> second) {
            this.first = first;
            this.second = second;
            RootCommandNode root = this.getRoot();
            for (CommandNode node : first.getRoot().getChildren()) {
                root.addChild(node);
            }
            for (CommandNode node : second.getRoot().getChildren()) {
                root.addChild(node);
            }
        }

        public boolean is(CommandDispatcher<T> first, CommandDispatcher<T> second) {
            return this.first == first && this.second == second;
        }
    }
}

