/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.vec;

import net.minecraft.util.Direction;

public abstract class Vector<T extends Vector> {
    public Vector() {
    }

    public Vector(T vec) {
        this.set(vec);
    }

    public abstract void set(T var1);

    public double get(Direction.Axis axis) {
        return this.get(axis.ordinal());
    }

    public void set(Direction.Axis axis, double value) {
        this.set(axis.ordinal(), value);
    }

    public abstract double get(int var1);

    public abstract void set(int var1, double var2);

    public abstract int dimensions();

    public abstract T copy();

    public abstract void add(T var1);

    public abstract void sub(T var1);

    public abstract void scale(double var1);

    public void invert() {
        this.scale(-1.0);
    }

    public abstract boolean equals(Object var1);

    public abstract double length();

    public abstract double lengthSquared();

    public void normalize() {
        this.scale(1.0 / this.length());
    }

    public abstract double angle(T var1);

    public abstract void cross(T var1, T var2);

    public abstract double dot(T var1);

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (int i = 0; i < this.dimensions(); ++i) {
            if (i > 0) {
                builder.append(",");
            }
            builder.append(this.get(i));
        }
        builder.append("]");
        return builder.toString();
    }
}

