/*
 * Decompiled with CFR 0.152.
 */
package snownee.lightingwand.common;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import snownee.lightingwand.common.CommonRegistry;
import snownee.lightingwand.common.ModConstants;
import vazkii.psi.api.cad.ICAD;

public class LightBlock
extends Block
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final IntegerProperty LIGHT = IntegerProperty.func_177719_a((String)"light", (int)1, (int)15);

    public LightBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151579_a).func_200951_a(15).func_200947_a(SoundType.field_185859_l));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)LIGHT, (Comparable)Integer.valueOf(15)));
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    public int func_149750_m(BlockState state) {
        return (Integer)state.func_177229_b((IProperty)LIGHT);
    }

    public boolean func_196261_e(BlockState state) {
        return true;
    }

    public boolean isAir(BlockState state, IBlockReader world, BlockPos pos) {
        return false;
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return EffectiveSide.get() == LogicalSide.CLIENT && LightBlock.hasItem() ? VoxelShapes.func_197868_b() : VoxelShapes.func_197880_a();
    }

    public VoxelShape func_220071_b(BlockState p_220071_1_, IBlockReader p_220071_2_, BlockPos p_220071_3_, ISelectionContext p_220071_4_) {
        return VoxelShapes.func_197880_a();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (LightBlock.hasItem()) {
            float x = (float)pos.func_177958_n() + 0.3f + rand.nextFloat() * 0.4f;
            float y = (float)pos.func_177956_o() + 0.5f;
            float z = (float)pos.func_177952_p() + 0.3f + rand.nextFloat() * 0.4f;
            worldIn.func_195594_a((IParticleData)new RedstoneParticleData(1.0f, 1.0f, 0.0f, 1.0f), (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
        }
        super.func_180655_c(stateIn, worldIn, pos, rand);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean hasItem() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return false;
        }
        Item main = player.func_184614_ca().func_77973_b();
        Item off = player.func_184592_cb().func_77973_b();
        if (main == ModConstants.WAND || off == ModConstants.WAND) {
            return true;
        }
        return CommonRegistry.psiCompat && (main instanceof ICAD || off instanceof ICAD);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{WATERLOGGED, LIGHT});
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : Fluids.field_204541_a.func_207188_f();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        context.func_195991_k();
        context.func_195995_a();
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)super.func_196258_a(context).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }
}

