/*
 * Decompiled with CFR 0.152.
 */
package snownee.lightingwand.common;

import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.IProperty;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import snownee.lightingwand.common.LightBlock;
import snownee.lightingwand.common.ModConstants;

public class LightEntity
extends ThrowableEntity {
    public LightEntity(World worldIn) {
        super(ModConstants.LIGHT_ENTITY_TYPE, worldIn);
    }

    public LightEntity(World worldIn, LivingEntity throwerIn) {
        super(ModConstants.LIGHT_ENTITY_TYPE, throwerIn, worldIn);
    }

    public LightEntity(World worldIn, double x, double y, double z) {
        super(ModConstants.LIGHT_ENTITY_TYPE, x, y, z, worldIn);
    }

    protected float func_70185_h() {
        return 0.01f;
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        this.func_213293_j(x / (double)f * (double)velocity, y / (double)f * (double)velocity, z / (double)f * (double)velocity);
    }

    protected void func_70184_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K && result != null) {
            this.func_70106_y();
            BlockPos pos = null;
            switch (result.func_216346_c()) {
                case MISS: {
                    return;
                }
                case ENTITY: {
                    pos = new BlockPos(result.func_216347_e());
                    break;
                }
                case BLOCK: {
                    pos = ((BlockRayTraceResult)result).func_216350_a().func_177972_a(((BlockRayTraceResult)result).func_216354_b());
                }
            }
            if (this.field_70170_p.func_180495_p(pos).func_185904_a().func_76222_j()) {
                IFluidState ifluidstate = this.field_70170_p.func_204610_c(pos);
                if (this.field_70170_p.func_180501_a(pos, (BlockState)ModConstants.LIGHT.func_176223_P().func_206870_a((IProperty)LightBlock.WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206884_a(FluidTags.field_206959_a) && ifluidstate.func_206882_g() == 8)), 11)) {
                    this.field_70170_p.func_184133_a(null, pos, SoundEvents.field_187884_fr, SoundCategory.BLOCKS, 1.0f, this.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f);
                }
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && !this.field_174854_a) {
            Vec3d motion = this.func_213322_ci();
            for (int k = 0; k < 2; ++k) {
                this.field_70170_p.func_195594_a((IParticleData)new RedstoneParticleData(1.0f, 1.0f, 0.0f, 1.0f), this.func_226277_ct_() + motion.field_72450_a * (double)k / 2.0, this.func_226278_cu_() + motion.field_72448_b * (double)k / 2.0, this.func_226281_cx_() + motion.field_72449_c * (double)k / 2.0, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void func_70088_a() {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

