/*
 * Decompiled with CFR 0.152.
 */
package snownee.lightingwand.compat;

import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import snownee.lightingwand.common.LightBlock;
import snownee.lightingwand.common.ModConstants;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.core.helpers.SpellHelpers;

public class ConjureInvisibleLightPieceTrick
extends PieceTrick {
    SpellParam<Vector3> position;
    SpellParam<Number> light;

    public ConjureInvisibleLightPieceTrick(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam((SpellParam)this.position);
        this.light = new ParamNumber("psi.spellparam.number", SpellParam.RED, true, false);
        this.addParam((SpellParam)this.light);
    }

    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        double lightVal = SpellHelpers.ensurePositiveAndNonzero((SpellPiece)this, this.light, (double)15.0);
        if (lightVal > 15.0) {
            throw new SpellCompilationException("psi.spellerror.lightingwand.light", this.x, this.y);
        }
        meta.addStat(EnumSpellStat.POTENCY, 40);
        meta.addStat(EnumSpellStat.COST, 120);
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 positionVal = (Vector3)this.getParamValue(context, this.position);
        Number lightVal = (Number)this.getParamValue(context, this.light);
        if (positionVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        if (!context.isInRadius(positionVal)) {
            throw new SpellRuntimeException("psi.spellerror.outsideradius");
        }
        BlockPos pos = positionVal.toBlockPos();
        World world = context.caster.func_130014_f_();
        if (!world.func_175660_a(context.caster, pos)) {
            return null;
        }
        if (world.func_180495_p(pos).func_177230_c() != ModConstants.LIGHT) {
            BlockState state = ModConstants.LIGHT.func_176223_P();
            if (lightVal != null) {
                state = (BlockState)state.func_206870_a((IProperty)LightBlock.LIGHT, (Comparable)Integer.valueOf(MathHelper.func_76143_f((double)lightVal.doubleValue())));
            }
            ConjureInvisibleLightPieceTrick.conjure(world, pos, context.caster, state);
        }
        return null;
    }

    public static boolean conjure(World world, BlockPos pos, PlayerEntity player, BlockState state) {
        if (!world.func_195588_v(pos) || !world.func_175660_a(player, pos)) {
            return false;
        }
        BlockState inWorld = world.func_180495_p(pos);
        if (inWorld.isAir((IBlockReader)world, pos) || inWorld.func_185904_a().func_76222_j()) {
            return world.func_175656_a(pos, state);
        }
        return false;
    }
}

