/*
 * Decompiled with CFR 0.152.
 */
package net.immortallis.mkmmod.config;

import net.immortallis.mkmmod.KillMessageMod;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="mkmmod")
@Config(modid="mkmmod", name="mobkillmessages")
public class KillMessageConfig {
    @Config.Name(value="Broadcast Settings")
    @Config.Comment(value={"If true, sends mob kill messages to all players in the world, instead of just the player that got the kill.\nSet to false by default.\nFor LAN worlds, this only works if the owner of the world has this set to true - the guest players' settings are irrelevant."})
    public static BroadcastConfig broadcastConfig = new BroadcastConfig(false);
    @Config.Name(value="Mob Kill Messages Config")
    @Config.Comment(value={"Create your own custom kill messages here, or in the Config Manager GUI in-game.\n<mob> will be replaced with the mob's name\n<player> will be replaced with the player's name\n<empty> means that there is no kill message in that slot, which will not be used. It's really just a placeholder to show you where to put new kill messages.\nYou can also increase the list size, whether by simply adding a new line to the config file directly, or by using the in-game config manager GUI to do it instead. Emptying a kill message list will disable kill messages for that source.\nNotes:\nMelee kill messages are also the default messages for miscellaneous damage sources (e.g. cactus pricking) or anything else not on this list.\n\"Projectile\" kill messages occur for projectiles that aren't arrows. In vanilla this is limited (example: snowballs killing blazes) but there are plenty of other mods that add such projectile weapons.\nVoid kill messages are seldom actually used due to hostile mobs that fall in there often despawning instead of actually dying actually dying, but mobs that don't despawn or are close enough to death when they fall in will still +trigger them."})
    public static ParentConfig parentConfig = new ParentConfig();

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("mkmmod")) {
            ConfigManager.sync((String)"mkmmod", (Config.Type)Config.Type.INSTANCE);
            KillMessageMod.manager.loadKillMessagesFromConfig();
        }
    }

    public static class ParentConfig {
        @Config.Name(value="Melee/miscellaneous kill messages")
        public MeleeKillMessages meleeKillMessages = new MeleeKillMessages("<mob> was rekt by <player>", "<mob> was ripped to shreds by <player>", "<mob> was no match for <player>", "<player> defeated <mob> in close combat", "<empty>");
        @Config.Name(value="Bow kill messages")
        public BowKillMessages bowKillMessages = new BowKillMessages("<mob> was shot through the heart, <player> is to blame", "<mob> was sniped by <player>", "<mob> was no-scoped by <player>", "<mob> was bowed down by <player>", "<empty>");
        @Config.Name(value="Projectile kill messages")
        public ProjectileKillMessages projectileKillMessages = new ProjectileKillMessages("<mob> was pummeled by <player>", "<mob> was smacked from a distance by <player>", "<mob> was obliterated by <player>'s weapon", "<mob> lost the duel to <player>", "<empty>");
        @Config.Name(value="Fire kill messages")
        public FireKillMessages fireKillMessages = new FireKillMessages("<mob> is now a pile of ashes, courtesy of <player>", "<mob> was roasted by <player>", "<mob> burnt to a crisp while fighting <player>", "<player> is now selling <mob> BBQ strips", "<empty>");
        @Config.Name(value="Fall damage kill messages")
        public FallKillMessages fallKillMessages = new FallKillMessages("<mob> was thrown off a cliff by <player>", "<mob> smacked the ground way too hard", "<mob> went skydiving without a parachute", "<empty>", "<empty>");
        @Config.Name(value="Explosion kill messages")
        public ExplosionKillMessages explosionKillMessages = new ExplosionKillMessages("<mob> went KAWHOOM due to <player>", "<mob> was Bomberman'd by <player>", "<mob> was nuked by <player>", "<empty>", "<empty>");
        @Config.Name(value="Void kill messages")
        public VoidKillMessages voidKillMessages = new VoidKillMessages("<mob> went too far past y = -64.0", "<mob> fell into the endless abyss", "<mob> was never seen again", "<empty>", "<empty>");

        public class VoidKillMessages {
            @Config.Name(value="messages")
            @Config.LangKey(value="mkmmod.config.void")
            public String[] messages = new String[5];

            public VoidKillMessages(String m1, String m2, String m3, String m4, String m5) {
                this.messages[0] = m1;
                this.messages[1] = m2;
                this.messages[2] = m3;
                this.messages[3] = m4;
                this.messages[4] = m5;
            }
        }

        public class ExplosionKillMessages {
            @Config.Name(value="messages")
            @Config.LangKey(value="mkmmod.config.explosion")
            public String[] messages = new String[5];

            public ExplosionKillMessages(String m1, String m2, String m3, String m4, String m5) {
                this.messages[0] = m1;
                this.messages[1] = m2;
                this.messages[2] = m3;
                this.messages[3] = m4;
                this.messages[4] = m5;
            }
        }

        public class FallKillMessages {
            @Config.Name(value="messages")
            @Config.LangKey(value="mkmmod.config.fall")
            public String[] messages = new String[5];

            public FallKillMessages(String m1, String m2, String m3, String m4, String m5) {
                this.messages[0] = m1;
                this.messages[1] = m2;
                this.messages[2] = m3;
                this.messages[3] = m4;
                this.messages[4] = m5;
            }
        }

        public class FireKillMessages {
            @Config.Name(value="messages")
            @Config.LangKey(value="mkmmod.config.fire")
            public String[] messages = new String[5];

            public FireKillMessages(String m1, String m2, String m3, String m4, String m5) {
                this.messages[0] = m1;
                this.messages[1] = m2;
                this.messages[2] = m3;
                this.messages[3] = m4;
                this.messages[4] = m5;
            }
        }

        public class ProjectileKillMessages {
            @Config.Name(value="messages")
            @Config.LangKey(value="mkmmod.config.projectile")
            public String[] messages = new String[5];

            public ProjectileKillMessages(String m1, String m2, String m3, String m4, String m5) {
                this.messages[0] = m1;
                this.messages[1] = m2;
                this.messages[2] = m3;
                this.messages[3] = m4;
                this.messages[4] = m5;
            }
        }

        public class BowKillMessages {
            @Config.Name(value="messages")
            @Config.LangKey(value="mkmmod.config.bow")
            public String[] messages = new String[5];

            public BowKillMessages(String m1, String m2, String m3, String m4, String m5) {
                this.messages[0] = m1;
                this.messages[1] = m2;
                this.messages[2] = m3;
                this.messages[3] = m4;
                this.messages[4] = m5;
            }
        }

        public class MeleeKillMessages {
            @Config.Name(value="Messages")
            @Config.LangKey(value="mkmmod.config.melee")
            public String[] messages = new String[5];

            public MeleeKillMessages(String m1, String m2, String m3, String m4, String m5) {
                this.messages[0] = m1;
                this.messages[1] = m2;
                this.messages[2] = m3;
                this.messages[3] = m4;
                this.messages[4] = m5;
            }
        }
    }

    public static class BroadcastConfig {
        @Config.Name(value="Broadcast Kill Messages")
        public boolean broadcast;

        public BroadcastConfig(boolean bc) {
            this.broadcast = bc;
        }
    }
}

