/*
 * Decompiled with CFR 0.152.
 */
package net.immortallis.mkmmod.event;

import net.immortallis.mkmmod.KillMessageMod;
import net.immortallis.mkmmod.config.KillMessageConfig;
import net.immortallis.mkmmod.manager.KillMessageManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class KillMessageEvent {
    private static final int MAX_LIST_SIZE = 2048;

    @SubscribeEvent
    public void addKillMessage(LivingDeathEvent event) {
        if (!event.getEntity().func_130014_f_().field_72995_K) {
            EntityLivingBase mob = event.getEntityLiving();
            DamageSource source = event.getSource();
            if (mob != null && KillMessageMod.entitiesHitByPlayer.contains(mob)) {
                int index = KillMessageMod.entitiesHitByPlayer.indexOf(mob);
                EntityPlayer player = KillMessageMod.playerSyncList.get(index);
                String mobName = mob.func_70005_c_();
                String playerName = player.getDisplayNameString();
                String killMessage = KillMessageManager.createKillMessage(mobName, playerName, source);
                if (killMessage.equals("")) {
                    return;
                }
                if (KillMessageConfig.broadcastConfig.broadcast) {
                    for (EntityPlayer e : player.func_130014_f_().field_73010_i) {
                        e.func_145747_a((ITextComponent)new TextComponentString(killMessage));
                    }
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString(killMessage));
                }
                try {
                    KillMessageMod.entitiesHitByPlayer.remove(mob);
                    KillMessageMod.playerSyncList.remove(player);
                }
                catch (IndexOutOfBoundsException e) {
                    KillMessageMod.entitiesHitByPlayer.clear();
                    KillMessageMod.playerSyncList.clear();
                }
            }
        }
    }

    @SubscribeEvent
    public void livingHurt(LivingHurtEvent event) {
        if (!event.getEntity().func_130014_f_().field_72995_K) {
            Entity player = event.getSource().func_76346_g();
            EntityLivingBase mob = event.getEntityLiving();
            if (player != null && player instanceof EntityPlayer) {
                EntityPlayer castedPlayer = (EntityPlayer)player;
                if (mob != null && !KillMessageMod.entitiesHitByPlayer.contains(mob)) {
                    if (KillMessageMod.entitiesHitByPlayer.size() < 2048 && KillMessageMod.playerSyncList.size() < 2048) {
                        KillMessageMod.entitiesHitByPlayer.add(mob);
                        KillMessageMod.playerSyncList.add(castedPlayer);
                    } else {
                        KillMessageMod.entitiesHitByPlayer.clear();
                        KillMessageMod.playerSyncList.clear();
                    }
                }
            }
        }
    }
}

