/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.morecauldrons.config;

import com.mrbysco.morecauldrons.MoreCauldrons;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class MoreCauldronsConfig {
    public static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
        MoreCauldrons.LOGGER.debug("Loaded More Cauldron's config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfig.Reloading configEvent) {
        MoreCauldrons.LOGGER.debug("More Cauldron's config just got changed on the file system!");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public final ForgeConfigSpec.BooleanValue liquidDropping;

        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Server settings").push("Server");
            this.liquidDropping = builder.comment("When enabled the cauldron will drop the liquid that's in if it breaks while full. (when Inspirations isn't installed) [default: false]").define("liquidDropping", false);
            builder.pop();
        }
    }
}

