/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.morecauldrons.generator;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mrbysco.morecauldrons.init.CauldronRegistry;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CauldronBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;

@Mod.EventBusSubscriber(modid="morecauldrons", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CauldronGenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.func_200390_a((IDataProvider)new Loots(generator));
        }
        if (event.includeClient()) {
            generator.func_200390_a((IDataProvider)new BlockStates(generator, helper));
            generator.func_200390_a((IDataProvider)new ItemModels(generator, helper));
        }
    }

    private static class BlockStates
    extends BlockStateProvider {
        public BlockStates(DataGenerator gen, ExistingFileHelper helper) {
            super(gen, "morecauldrons", helper);
        }

        protected void registerStatesAndModels() {
            this.makeCauldron((Block)CauldronRegistry.ACACIA_CAULDRON.get(), this.mcLoc("block/acacia_planks"));
            this.makeCauldron((Block)CauldronRegistry.DARK_OAK_CAULDRON.get(), this.mcLoc("block/dark_oak_planks"));
            this.makeCauldron((Block)CauldronRegistry.BIRCH_CAULDRON.get(), this.mcLoc("block/birch_planks"));
            this.makeCauldron((Block)CauldronRegistry.JUNGLE_CAULDRON.get(), this.mcLoc("block/jungle_planks"));
            this.makeCauldron((Block)CauldronRegistry.OAK_CAULDRON.get(), this.mcLoc("block/oak_planks"));
            this.makeCauldron((Block)CauldronRegistry.SPRUCE_CAULDRON.get(), this.mcLoc("block/spruce_planks"));
            this.makeCauldron((Block)CauldronRegistry.GOLD_CAULDRON.get(), this.mcLoc("block/gold_block"));
            this.makeCauldron((Block)CauldronRegistry.DIAMOND_CAULDRON.get(), this.mcLoc("block/diamond_block"));
            this.makeCauldron((Block)CauldronRegistry.COBBLE_CAULDRON.get(), this.mcLoc("block/cobblestone"));
            this.makeCauldron((Block)CauldronRegistry.OBSIDIAN_CAULDRON.get(), this.mcLoc("block/obsidian"));
            this.makeCauldron((Block)CauldronRegistry.BRICK_CAULDRON.get(), this.mcLoc("block/bricks"));
            this.makeCauldron((Block)CauldronRegistry.STONE_CAULDRON.get(), this.mcLoc("block/stone"));
            this.makeCauldron((Block)CauldronRegistry.GRANITE_CAULDRON.get(), this.mcLoc("block/granite"));
            this.makeCauldron((Block)CauldronRegistry.POLISHED_GRANITE_CAULDRON.get(), this.mcLoc("block/polished_granite"));
            this.makeCauldron((Block)CauldronRegistry.DIORITE_CAULDRON.get(), this.mcLoc("block/diorite"));
            this.makeCauldron((Block)CauldronRegistry.POLISHED_DIORITE_CAULDRON.get(), this.mcLoc("block/polished_diorite"));
            this.makeCauldron((Block)CauldronRegistry.ANDESITE_CAULDRON.get(), this.mcLoc("block/andesite"));
            this.makeCauldron((Block)CauldronRegistry.POLISHED_ANDESITE_CAULDRON.get(), this.mcLoc("block/polished_andesite"));
        }

        private void makeCauldron(Block block, ResourceLocation textureLocation) {
            ModelBuilder cauldron = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(block.getRegistryName().func_110623_a())).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/cauldron")))).texture("particle", textureLocation)).texture("top", textureLocation)).texture("bottom", textureLocation)).texture("side", textureLocation)).texture("inside", textureLocation);
            ModelBuilder cauldron1 = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(block.getRegistryName().func_110623_a() + "_level1")).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/cauldron_level1")))).texture("particle", textureLocation)).texture("top", textureLocation)).texture("bottom", textureLocation)).texture("side", textureLocation)).texture("inside", textureLocation);
            ModelBuilder cauldron2 = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(block.getRegistryName().func_110623_a() + "_level2")).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/cauldron_level2")))).texture("particle", textureLocation)).texture("top", textureLocation)).texture("bottom", textureLocation)).texture("side", textureLocation)).texture("inside", textureLocation);
            ModelBuilder cauldron3 = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(block.getRegistryName().func_110623_a() + "_level3")).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/cauldron_level3")))).texture("particle", textureLocation)).texture("top", textureLocation)).texture("bottom", textureLocation)).texture("side", textureLocation)).texture("inside", textureLocation);
            this.getVariantBuilder(block).forAllStates(arg_0 -> BlockStates.lambda$makeCauldron$0((ModelFile)cauldron, (ModelFile)cauldron1, (ModelFile)cauldron2, (ModelFile)cauldron3, arg_0));
        }

        private static /* synthetic */ ConfiguredModel[] lambda$makeCauldron$0(ModelFile cauldron, ModelFile cauldron1, ModelFile cauldron2, ModelFile cauldron3, BlockState state) {
            int LEVEL = (Integer)state.func_177229_b((Property)CauldronBlock.field_176591_a);
            switch (LEVEL) {
                default: {
                    return ConfiguredModel.builder().modelFile(cauldron).build();
                }
                case 1: {
                    return ConfiguredModel.builder().modelFile(cauldron1).build();
                }
                case 2: {
                    return ConfiguredModel.builder().modelFile(cauldron2).build();
                }
                case 3: 
            }
            return ConfiguredModel.builder().modelFile(cauldron3).build();
        }
    }

    private static class ItemModels
    extends ItemModelProvider {
        public ItemModels(DataGenerator gen, ExistingFileHelper helper) {
            super(gen, "morecauldrons", helper);
        }

        protected void registerModels() {
            this.makeCauldron((Block)CauldronRegistry.ACACIA_CAULDRON.get());
            this.makeCauldron((Block)CauldronRegistry.DARK_OAK_CAULDRON.get());
            this.makeCauldron((Block)CauldronRegistry.BIRCH_CAULDRON.get());
            this.makeCauldron((Block)CauldronRegistry.JUNGLE_CAULDRON.get());
            this.makeCauldron((Block)CauldronRegistry.OAK_CAULDRON.get());
            this.makeCauldron((Block)CauldronRegistry.SPRUCE_CAULDRON.get());
            this.makeCauldron((Block)CauldronRegistry.GOLD_CAULDRON.get());
            this.makeCauldron((Block)CauldronRegistry.DIAMOND_CAULDRON.get());
            this.makeCauldron((Block)CauldronRegistry.COBBLE_CAULDRON.get());
            this.makeCauldron((Block)CauldronRegistry.GLASS_CAULDRON.get());
            this.makeCauldron((Block)CauldronRegistry.OBSIDIAN_CAULDRON.get());
            this.makeCauldron((Block)CauldronRegistry.BRICK_CAULDRON.get());
            this.makeCauldron((Block)CauldronRegistry.STONE_CAULDRON.get());
            this.makeCauldron((Block)CauldronRegistry.GRANITE_CAULDRON.get());
            this.makeCauldron((Block)CauldronRegistry.POLISHED_GRANITE_CAULDRON.get());
            this.makeCauldron((Block)CauldronRegistry.DIORITE_CAULDRON.get());
            this.makeCauldron((Block)CauldronRegistry.POLISHED_DIORITE_CAULDRON.get());
            this.makeCauldron((Block)CauldronRegistry.ANDESITE_CAULDRON.get());
            this.makeCauldron((Block)CauldronRegistry.POLISHED_ANDESITE_CAULDRON.get());
        }

        private void makeCauldron(Block block) {
            String path = block.getRegistryName().func_110623_a();
            ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("item/generated")))).texture("layer0", this.modLoc("item/" + path));
        }

        public String func_200397_b() {
            return "Item Models";
        }
    }

    private static class Loots
    extends LootTableProvider {
        public Loots(DataGenerator gen) {
            super(gen);
        }

        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
            return ImmutableList.of((Object)Pair.of(() -> new Blocks(), (Object)LootParameterSets.field_216267_h));
        }

        protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
            map.forEach((name, table) -> LootTableManager.func_227508_a_((ValidationTracker)validationtracker, (ResourceLocation)name, (LootTable)table));
        }

        private class Blocks
        extends BlockLootTables {
            private Blocks() {
            }

            protected void addTables() {
                this.func_218492_c((Block)CauldronRegistry.ACACIA_CAULDRON.get());
                this.func_218492_c((Block)CauldronRegistry.DARK_OAK_CAULDRON.get());
                this.func_218492_c((Block)CauldronRegistry.BIRCH_CAULDRON.get());
                this.func_218492_c((Block)CauldronRegistry.JUNGLE_CAULDRON.get());
                this.func_218492_c((Block)CauldronRegistry.OAK_CAULDRON.get());
                this.func_218492_c((Block)CauldronRegistry.SPRUCE_CAULDRON.get());
                this.func_218492_c((Block)CauldronRegistry.GOLD_CAULDRON.get());
                this.func_218492_c((Block)CauldronRegistry.DIAMOND_CAULDRON.get());
                this.func_218492_c((Block)CauldronRegistry.COBBLE_CAULDRON.get());
                this.func_218466_b((Block)CauldronRegistry.GLASS_CAULDRON.get());
                this.func_218492_c((Block)CauldronRegistry.OBSIDIAN_CAULDRON.get());
                this.func_218492_c((Block)CauldronRegistry.BRICK_CAULDRON.get());
                this.func_218492_c((Block)CauldronRegistry.STONE_CAULDRON.get());
                this.func_218492_c((Block)CauldronRegistry.GRANITE_CAULDRON.get());
                this.func_218492_c((Block)CauldronRegistry.POLISHED_GRANITE_CAULDRON.get());
                this.func_218492_c((Block)CauldronRegistry.DIORITE_CAULDRON.get());
                this.func_218492_c((Block)CauldronRegistry.POLISHED_DIORITE_CAULDRON.get());
                this.func_218492_c((Block)CauldronRegistry.ANDESITE_CAULDRON.get());
                this.func_218492_c((Block)CauldronRegistry.POLISHED_ANDESITE_CAULDRON.get());
            }

            protected Iterable<Block> getKnownBlocks() {
                return CauldronRegistry.BLOCKS.getEntries().stream().map(RegistryObject::get)::iterator;
            }
        }
    }
}

