/*
 * Decompiled with CFR 0.152.
 */
package alhetta.notenoughscaffold.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BaseBlockScaffold
extends Block {
    private static final AxisAlignedBB COLLISION_AABB = new AxisAlignedBB(0.03125, 0.0, 0.03125, 0.96875, 1.0, 0.96875);

    BaseBlockScaffold(Material material, float hardness, float resistance) {
        super(material);
        this.func_149711_c(hardness);
        this.func_149752_b(resistance);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState upBlock;
        if (facing == EnumFacing.UP) {
            return false;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b()) {
            return false;
        }
        Block handBlock = Block.func_149634_a((Item)stack.func_77973_b());
        if (handBlock != state.func_177230_c()) {
            return false;
        }
        BlockPos playerPos = new BlockPos(Math.floor(player.field_70165_t), player.field_70163_u - 0.5, Math.floor(player.field_70161_v));
        if (playerPos.equals((Object)pos)) {
            return false;
        }
        BlockPos newPos = new BlockPos((Vec3i)pos);
        while ((upBlock = world.func_180495_p(newPos = newPos.func_177984_a())).func_177230_c() == state.func_177230_c()) {
        }
        if (!this.func_176196_c(world, newPos)) {
            return false;
        }
        world.func_175656_a(newPos, state);
        if (!player.func_184812_l_()) {
            stack.func_190918_g(1);
        }
        world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), this.field_149762_H.func_185841_e(), SoundCategory.BLOCKS, 1.0f, 1.0f, true);
        return true;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entityIn) {
        if (!(entityIn instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase entity = (EntityLivingBase)entityIn;
        entity.field_70143_R = 0.0f;
        double limit = 0.15;
        entity.field_70159_w = this.limit(entity.field_70159_w, -limit, limit);
        entity.field_70179_y = this.limit(entity.field_70179_y, -limit, limit);
        entity.field_70181_x = entity.func_70093_af() && entity instanceof EntityPlayer ? (entity.func_70090_H() ? 0.02 : 0.08) : (entity.field_70123_F ? this.getMotionSpeed() : Math.max(entity.field_70181_x, -0.07));
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        if (!this.canBlockStay(worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    private boolean canBlockStay(World world, BlockPos pos) {
        BlockPos nearPos;
        int i;
        if (this.checkDownBlock(world, pos.func_177977_b())) {
            return true;
        }
        int sideBlockAvailable = this.getSideBlockAvailable();
        for (i = 1; i <= sideBlockAvailable && this.checkSideBlock(world, nearPos = pos.func_177982_a(i, 0, 0)); ++i) {
            if (!this.checkDownBlock(world, nearPos.func_177977_b())) continue;
            return true;
        }
        for (i = -1; i >= -sideBlockAvailable && this.checkSideBlock(world, nearPos = pos.func_177982_a(i, 0, 0)); --i) {
            if (!this.checkDownBlock(world, nearPos.func_177977_b())) continue;
            return true;
        }
        for (i = 1; i <= sideBlockAvailable && this.checkSideBlock(world, nearPos = pos.func_177982_a(0, 0, i)); ++i) {
            if (!this.checkDownBlock(world, nearPos.func_177977_b())) continue;
            return true;
        }
        for (i = -1; i >= -sideBlockAvailable && this.checkSideBlock(world, nearPos = pos.func_177982_a(0, 0, i)); --i) {
            if (!this.checkDownBlock(world, nearPos.func_177977_b())) continue;
            return true;
        }
        return false;
    }

    private boolean checkSideBlock(World world, BlockPos pos) {
        IBlockState sideBlock = world.func_180495_p(pos);
        return sideBlock.func_177230_c() == this;
    }

    private boolean checkDownBlock(World world, BlockPos pos) {
        IBlockState bottomBlock = world.func_180495_p(pos);
        Material material = bottomBlock.func_185904_a();
        return material.func_76220_a();
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return super.func_176196_c(world, pos) && !world.func_189509_E(pos) && this.canBlockStay(world, pos);
    }

    private double limit(double value, double min, double max) {
        if (Double.isNaN(value) || value <= min) {
            return min;
        }
        return Math.min(value, max);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        return COLLISION_AABB;
    }

    protected abstract double getMotionSpeed();

    protected abstract int getSideBlockAvailable();
}

