/*
 * Decompiled with CFR 0.152.
 */
package alhetta.notenoughscaffold.handler;

import alhetta.notenoughscaffold.config.Config;
import alhetta.notenoughscaffold.registry.EnchantmentRegistry;
import alhetta.notenoughscaffold.util.IdentityUtil;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentEventHandler {
    public static EnchantmentEventHandler INSTANCE = new EnchantmentEventHandler();

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        World world;
        EntityPlayer player = event.getPlayer();
        if (player.func_70093_af()) {
            return;
        }
        ItemStack toolStack = player.func_184614_ca();
        boolean isShovel = IdentityUtil.isShovel(toolStack);
        boolean isPickaxe = IdentityUtil.isPickaxe(toolStack);
        if (!isShovel && !isPickaxe) {
            return;
        }
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)toolStack);
        if (!enchantments.containsKey(EnchantmentRegistry.BIG_HOLES)) {
            return;
        }
        Enchantment unbreaking = (Enchantment)Enchantment.field_185264_b.func_82594_a((Object)Enchantments.field_185307_s.getRegistryName());
        int chance = 100;
        if (enchantments.containsKey(unbreaking)) {
            chance /= (Integer)enchantments.get(unbreaking) + 1;
        }
        if (!this.canHarvest(world = event.getWorld(), event.getPos(), isShovel, isPickaxe)) {
            return;
        }
        Config config = EnchantmentRegistry.config;
        BlockPos pos = event.getPos();
        EnumFacing side = EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)player);
        Random random = new Random();
        int damage = 0;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0) {
                    if (!this.isAdditionallyDamage(config, random)) continue;
                    damage += config.penaltyDurability;
                    continue;
                }
                pos = side == EnumFacing.DOWN || side == EnumFacing.UP ? event.getPos().func_177982_a(i, 0, j) : (side == EnumFacing.EAST || side == EnumFacing.WEST ? event.getPos().func_177982_a(0, i, j) : event.getPos().func_177982_a(i, j, 0));
                if (!this.canHarvest(world, pos, isShovel, isPickaxe)) continue;
                IBlockState blockState = world.func_180495_p(pos);
                Block block = blockState.func_177230_c();
                block.func_180657_a(world, player, pos, blockState, null, toolStack);
                world.func_175698_g(pos);
                if (player.func_184812_l_()) continue;
                if (random.nextInt(100) <= chance) {
                    ++damage;
                }
                if (!this.isAdditionallyDamage(config, random)) continue;
                damage += config.penaltyDurability;
            }
        }
        toolStack.func_77964_b(toolStack.func_77952_i() + damage);
    }

    private boolean canHarvest(World world, BlockPos pos, boolean isShovel, boolean isPickaxe) {
        return isShovel && this.canHarvestByShovel(world, pos) || isPickaxe && this.canHarvestByPickaxe(world, pos);
    }

    private boolean canHarvestByPickaxe(World world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        String requiredTool = block.getHarvestTool(blockState);
        return block != Blocks.field_150343_Z && !block.hasTileEntity(blockState) && requiredTool != null && requiredTool.equals("pickaxe");
    }

    private boolean canHarvestByShovel(World world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        String requiredTool = blockState.func_177230_c().getHarvestTool(blockState);
        return requiredTool != null && requiredTool.equals("shovel");
    }

    private boolean isAdditionallyDamage(Config config, Random random) {
        return config.chancePenalty > 0.0f && random.nextFloat() <= config.chancePenalty;
    }
}

