/*
 * Decompiled with CFR 0.152.
 */
package alhetta.notenoughscaffold.registry;

import alhetta.notenoughscaffold.registry.BlockRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemRegistry {
    private static List<Item> itemList;

    public static void init() {
        itemList = new ArrayList<Item>();
        ItemRegistry.registerItem(BlockRegistry.WOODEN_SCAFFOLD);
        ItemRegistry.registerItem(BlockRegistry.IRON_SCAFFOLD);
    }

    public static void registerItems(IForgeRegistry<Item> registry) {
        registry.registerAll((IForgeRegistryEntry[])itemList.toArray(new Item[0]));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRenders() {
        for (Item item : itemList) {
            ItemRegistry.registerRender(item);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRender(Item item) {
        ModelResourceLocation resourceLocation = new ModelResourceLocation(item.getRegistryName(), "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)resourceLocation);
    }

    private static Item registerItem(Block block) {
        ItemBlock item = new ItemBlock(block);
        item.setRegistryName(block.getRegistryName());
        item.func_77655_b(block.getRegistryName().func_110623_a());
        itemList.add((Item)item);
        return item;
    }
}

