/*
 * Decompiled with CFR 0.152.
 */
package com.ebiggz.postalservice;

import com.ebiggz.postalservice.apis.guiAPI.GUIListener;
import com.ebiggz.postalservice.apis.guiAPI.GUIManager;
import com.ebiggz.postalservice.backend.database.Database;
import com.ebiggz.postalservice.backend.database.MySQL;
import com.ebiggz.postalservice.commands.MailCommands;
import com.ebiggz.postalservice.commands.MailTabCompleter;
import com.ebiggz.postalservice.commands.MailboxCommands;
import com.ebiggz.postalservice.commands.MailboxTabCompleter;
import com.ebiggz.postalservice.config.Config;
import com.ebiggz.postalservice.config.Language;
import com.ebiggz.postalservice.listeners.MailboxListener;
import com.ebiggz.postalservice.listeners.PlayerListener;
import com.ebiggz.postalservice.mail.MailManager;
import com.ebiggz.postalservice.mail.mailtypes.Experience;
import com.ebiggz.postalservice.mail.mailtypes.Letter;
import com.ebiggz.postalservice.mail.mailtypes.Package;
import com.ebiggz.postalservice.mail.mailtypes.Payment;
import com.ebiggz.postalservice.mailbox.MailboxManager;
import com.ebiggz.postalservice.permissions.PermissionHandler;
import com.ebiggz.postalservice.utils.Metrics;
import com.ebiggz.postalservice.utils.UUIDUtils;
import com.ebiggz.postalservice.utils.Updater;
import com.ebiggz.postalservice.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitScheduler;

public class PostalService
extends JavaPlugin {
    private static Plugin plugin;
    private static Database database;
    private double serverVersion;
    private static Updater updater;
    private BukkitRunnable updateCheckTask;
    public static Economy economy;
    public static Permission permission;
    private static boolean vaultEnabled;
    private static boolean hasPermPlugin;
    private static boolean hasEconPlugin;
    private static final int projectId = 93931;
    private static File file;

    static {
        economy = null;
        permission = null;
        vaultEnabled = false;
        hasPermPlugin = false;
        hasEconPlugin = false;
    }

    public void onEnable() {
        block8: {
            plugin = this;
            file = this.getFile();
            new Utils();
            String vString = PostalService.getVersion().replace("v", "");
            this.serverVersion = 0.0;
            if (!vString.isEmpty()) {
                String[] array = vString.split("_");
                this.serverVersion = Double.parseDouble(String.valueOf(array[0]) + "." + array[1]);
            }
            if (this.serverVersion == 1.6 || this.serverVersion == 1.5 || this.serverVersion == 1.4 || this.serverVersion == 1.3) {
                this.getLogger().severe("Sorry! PostalService is compatible with Bukkit 1.7 and above.");
                Bukkit.getPluginManager().disablePlugin((Plugin)this);
            }
            if (this.setupVault()) {
                vaultEnabled = true;
            }
            PermissionHandler.registerPermissions();
            Bukkit.getPluginManager().registerEvents((Listener)new GUIListener(), (Plugin)this);
            Bukkit.getPluginManager().registerEvents((Listener)new MailboxListener(), (Plugin)this);
            Bukkit.getPluginManager().registerEvents((Listener)new PlayerListener(), (Plugin)this);
            Config.loadFile();
            Language.loadFile();
            UUIDUtils.loadFile();
            PostalService.getMailManager().clearMailTypes();
            PostalService.getMailManager().registerMailType(new Letter());
            PostalService.getMailManager().registerMailType(new Experience());
            PostalService.getMailManager().registerMailType(new Package());
            if (vaultEnabled && hasEconPlugin) {
                PostalService.getMailManager().registerMailType(new Payment());
            }
            BukkitScheduler scheduler = Bukkit.getServer().getScheduler();
            scheduler.scheduleSyncDelayedTask(PostalService.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    PostalService.this.unregisterCommand(Language.Phrases.COMMAND_MAIL.toString());
                    PostalService.this.unregisterCommand(Language.Phrases.COMMAND_MAILBOX.toString());
                    PostalService.this.registerCommand(new String[]{Language.Phrases.COMMAND_MAIL.toString(), "mail", "m", "ps", "postalservice"});
                    PostalService.this.getCommand(Language.Phrases.COMMAND_MAIL.toString()).setExecutor((CommandExecutor)new MailCommands());
                    PostalService.this.getCommand(Language.Phrases.COMMAND_MAIL.toString()).setTabCompleter((TabCompleter)new MailTabCompleter());
                    PostalService.this.registerCommand(new String[]{Language.Phrases.COMMAND_MAILBOX.toString(), "mailbox", "mb"});
                    PostalService.this.getCommand(Language.Phrases.COMMAND_MAILBOX.toString()).setExecutor((CommandExecutor)new MailboxCommands());
                    PostalService.this.getCommand(Language.Phrases.COMMAND_MAILBOX.toString()).setTabCompleter((TabCompleter)new MailboxTabCompleter());
                }
            }, 20L);
            if (!this.loadDatabase()) {
                this.getLogger().severe("Unable to connect to the database! Please check your database settings and try again.");
                Bukkit.getPluginManager().disablePlugin((Plugin)this);
                return;
            }
            this.getLogger().info("Sucessfully connected to the database!");
            if (!this.getServer().getOnlineMode() && Config.USE_UUIDS && !Config.FORCE_UUIDS) {
                Config.USE_UUIDS = false;
                this.getLogger().warning("UUIDs are enabled but the server is running in Offline Mode. UUIDs have been disabled. To force the use of UUIDs while in Offline mode, set \"use-uuids\" to \"always\" in the config.");
            }
            scheduler.scheduleSyncDelayedTask(PostalService.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    MailboxManager.getInstance().loadMailboxes();
                }
            }, 20L);
            this.scheduleTasks();
            try {
                Metrics metrics = new Metrics((Plugin)this);
                metrics.start();
            }
            catch (IOException e) {
                if (!Config.ENABLE_DEBUG) break block8;
                e.printStackTrace();
            }
        }
        this.getLogger().info("Enabled!");
    }

    public void onDisable() {
        GUIManager.getInstance().closeAllGUIs();
        this.unregisterCommand(Language.Phrases.COMMAND_MAIL.toString());
        this.unregisterCommand(Language.Phrases.COMMAND_MAILBOX.toString());
        PostalService.getMailManager().deregisterAllMailTypes();
        this.getLogger().info("Disabled!");
    }

    private boolean setupVault() {
        Plugin vault = this.getServer().getPluginManager().getPlugin("Vault");
        if (vault != null) {
            this.getLogger().info("Hooked into Vault!");
            if (!this.setupEconomy()) {
                this.getLogger().warning("No plugin to handle currency. Payment mail type will be not be available!");
            }
            if (!this.setupPermissions()) {
                this.getLogger().warning("No plugin to handle permission groups. Permission group settings will be ignored!");
            }
            return true;
        }
        this.getLogger().warning("Vault plugin not found. The Payment mailtype and permission group features will be not be functional!");
        return false;
    }

    private boolean setupEconomy() {
        RegisteredServiceProvider economyProvider = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (economyProvider != null) {
            hasEconPlugin = true;
            economy = (Economy)economyProvider.getProvider();
        }
        return economy != null;
    }

    private boolean setupPermissions() {
        RegisteredServiceProvider permissionProvider = this.getServer().getServicesManager().getRegistration(Permission.class);
        if (permissionProvider != null && ((Permission)permissionProvider.getProvider()).hasGroupSupport()) {
            hasPermPlugin = true;
            permission = (Permission)permissionProvider.getProvider();
        }
        return permission != null;
    }

    public boolean loadDatabase() {
        this.reloadConfig();
        database = new MySQL((Plugin)this, this.getConfig().getString("database.host", "127.0.0.1"), this.getConfig().getString("database.port", "3306"), this.getConfig().getString("database.database", "someName"), this.getConfig().getString("database.user", "user"), this.getConfig().getString("database.password", "password"));
        try {
            database.openConnection();
            return database.checkConnection();
        }
        catch (Exception e) {
            if (Config.ENABLE_DEBUG) {
                e.printStackTrace();
            }
            return false;
        }
    }

    public static Updater getUpdater() {
        return updater;
    }

    public static MailManager getMailManager() {
        return MailManager.getInstance();
    }

    public static MailboxManager getMailboxManager() {
        return MailboxManager.getInstance();
    }

    public static Plugin getPlugin() {
        return plugin;
    }

    public static Database getPSDatabase() {
        return database;
    }

    public int getProjectID() {
        return 93931;
    }

    public static boolean vaultHooked() {
        return vaultEnabled;
    }

    public static boolean foundPermPlugin() {
        return hasPermPlugin;
    }

    public static boolean foundEconPlugin() {
        return hasEconPlugin;
    }

    private static String getVersion() {
        String[] array = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",");
        if (array.length == 4) {
            return String.valueOf(array[3]) + ".";
        }
        return "";
    }

    private void scheduleTasks() {
        this.cancelTasks();
        this.updateCheckTask = new UpdateCheckTask(this);
        this.updateCheckTask.runTaskTimerAsynchronously((Plugin)this, 40L, 432000L);
    }

    private void cancelTasks() {
        if (this.updateCheckTask != null) {
            this.updateCheckTask.cancel();
        }
    }

    public static void manualUpdateCheck(final CommandSender sender) {
        updater = new Updater(plugin, 93931, file, Updater.UpdateType.NO_DOWNLOAD, new Updater.UpdateCallback(){

            @Override
            public void onFinish(Updater updater) {
                if (updater.getResult() == Updater.UpdateResult.UPDATE_AVAILABLE) {
                    Utils.getUpdateAvailableMessage().sendTo(sender);
                } else {
                    sender.sendMessage(Language.Phrases.ERORR_UPDATE_DOWNLOAD_FAIL.toPrefixedString());
                }
            }
        }, true);
    }

    public static void downloadUpdate(final CommandSender sender) {
        if (updater.getResult() == Updater.UpdateResult.UPDATE_AVAILABLE) {
            updater = new Updater(plugin, 93931, file, Updater.UpdateType.NO_VERSION_CHECK, new Updater.UpdateCallback(){

                @Override
                public void onFinish(Updater updater) {
                    if (updater.getResult() == Updater.UpdateResult.SUCCESS) {
                        sender.sendMessage(Language.Phrases.ALERT_UPDATE_DOWNLOAD_SUCCESS.toPrefixedString());
                    } else {
                        sender.sendMessage(Language.Phrases.ERORR_UPDATE_DOWNLOAD_FAIL.toPrefixedString());
                    }
                }
            }, true);
        }
    }

    private void unregisterCommand(String cmd) {
        block4: {
            try {
                HashMap<String, Command> knownCommands = PostalService.getKnownCommands();
                if (knownCommands.containsKey(cmd.trim())) {
                    Utils.debugMessage("\"" + cmd + "\" command is registered by another plugin. Unregistering...");
                    Command pCmd = knownCommands.get(cmd);
                    knownCommands.remove(cmd);
                    for (String alias : pCmd.getAliases()) {
                        if (!knownCommands.containsKey(alias) || !knownCommands.get(alias).toString().contains(this.getName())) continue;
                        knownCommands.remove(alias);
                    }
                }
            }
            catch (Exception e) {
                if (!Config.ENABLE_DEBUG) break block4;
                e.printStackTrace();
            }
        }
    }

    private void registerCommand(String ... aliases) {
        PluginCommand command = PostalService.getCommand(aliases[0], (Plugin)this);
        command.setAliases(Arrays.asList(aliases));
        PostalService.getCommandMap().register("PostalService", (Command)command);
    }

    private static PluginCommand getCommand(String name, Plugin plugin) {
        PluginCommand command;
        block2: {
            command = null;
            try {
                Constructor c = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
                c.setAccessible(true);
                command = (PluginCommand)c.newInstance(name, plugin);
            }
            catch (Exception e) {
                if (!Config.ENABLE_DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return command;
    }

    private static CommandMap getCommandMap() {
        CommandMap commandMap;
        block2: {
            commandMap = null;
            try {
                Field f = Bukkit.getPluginManager().getClass().getDeclaredField("commandMap");
                f.setAccessible(true);
                commandMap = (CommandMap)f.get(Bukkit.getPluginManager());
            }
            catch (Exception e) {
                if (!Config.ENABLE_DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return commandMap;
    }

    private static HashMap<String, Command> getKnownCommands() {
        HashMap knownCommands;
        block2: {
            knownCommands = null;
            try {
                knownCommands = (HashMap)PostalService.getPrivateField(PostalService.getCommandMap(), "knownCommands");
            }
            catch (Exception e) {
                if (!Config.ENABLE_DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return knownCommands;
    }

    private static Object getPrivateField(Object object, String field) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Class<?> clazz = object.getClass();
        Field objectField = clazz.getDeclaredField(field);
        objectField.setAccessible(true);
        Object result = objectField.get(object);
        objectField.setAccessible(false);
        return result;
    }

    private class UpdateCheckTask
    extends BukkitRunnable {
        PostalService plugin;

        private UpdateCheckTask(PostalService plugin) {
            this.plugin = plugin;
        }

        public void run() {
            if (Config.CHECK_FOR_UPDATES) {
                this.plugin.getLogger().info("Checking for updates...");
                switch (Config.AUTO_DOWNLOAD_TYPE) {
                    case BUGFIXES: {
                        PostalService.updater = new Updater((Plugin)this.plugin, this.plugin.getProjectID(), this.plugin.getFile(), Updater.UpdateType.BUGFIX_ONLY, true);
                        break;
                    }
                    case NONE: {
                        PostalService.updater = new Updater((Plugin)this.plugin, this.plugin.getProjectID(), this.plugin.getFile(), Updater.UpdateType.NO_DOWNLOAD, true);
                        break;
                    }
                    default: {
                        PostalService.updater = new Updater((Plugin)this.plugin, this.plugin.getProjectID(), this.plugin.getFile(), Updater.UpdateType.DEFAULT, true);
                    }
                }
                switch (updater.getResult()) {
                    case DISABLED: {
                        this.plugin.getLogger().info("Update checking has been disabled in the config.");
                        this.plugin.updateCheckTask.cancel();
                        break;
                    }
                    case NO_UPDATE: {
                        this.plugin.getLogger().info("You are up to date!");
                        break;
                    }
                    case SUCCESS: {
                        this.plugin.getLogger().info("An update was succussfully downloaded and will be available after the next server restart.");
                        this.plugin.getLogger().info("Read the update notes here: " + updater.getLatestReleaseNotesLink());
                        break;
                    }
                    case UPDATE_AVAILABLE: {
                        this.plugin.getLogger().info("There is a new version available! (New version: " + updater.getLatestName() + " Current version: " + this.plugin.getDescription().getVersion() + ")");
                        this.plugin.getLogger().info("Read the update notes here: " + updater.getLatestReleaseNotesLink());
                        this.plugin.getLogger().info("Or type \"/" + Language.Phrases.COMMAND_MAIL.toString() + " " + Language.Phrases.COMMAND_ARG_DOWNLOAD.toString() + "\" to download the update now.");
                        break;
                    }
                }
            }
        }
    }
}

