/*
 * Decompiled with CFR 0.152.
 */
package com.ebiggz.postalservice.apis.InteractiveMessageAPI;

import org.bukkit.ChatColor;

public class FormattedText {
    private String text;
    private ChatColor color;
    private boolean isBold = false;
    private boolean isItalic = false;
    private boolean isStrikethrough = false;
    private boolean isUnderlined = false;
    private boolean isObfuscated = false;

    public FormattedText(String text) {
        this(text, null);
    }

    public FormattedText(String text, ChatColor color) {
        if (text != null) {
            this.text = ChatColor.translateAlternateColorCodes((char)'&', (String)text);
        }
        this.color = color;
    }

    public String getString() {
        return this.text;
    }

    public FormattedText setString(String text) {
        if (text != null) {
            this.text = ChatColor.translateAlternateColorCodes((char)'&', (String)text);
        }
        return this;
    }

    public boolean hasColor() {
        return this.color != null;
    }

    public ChatColor getColor() {
        return this.color;
    }

    public FormattedText setColor(ChatColor color) {
        if (color != null && color.isColor()) {
            this.color = color;
        }
        return this;
    }

    public FormattedText setFormat(ChatColor color) {
        if (color != null) {
            switch (color) {
                case BOLD: {
                    this.setBold(true);
                    break;
                }
                case ITALIC: {
                    this.setItalic(true);
                    break;
                }
                case MAGIC: {
                    this.setObfuscated(true);
                    break;
                }
                case STRIKETHROUGH: {
                    this.setStrikethrough(true);
                    break;
                }
                case UNDERLINE: {
                    this.setUnderlined(true);
                    break;
                }
            }
        }
        return this;
    }

    public boolean hasFormat() {
        return this.isBold || this.isItalic || this.isStrikethrough || this.isUnderlined || this.isObfuscated;
    }

    public boolean isBold() {
        return this.isBold;
    }

    public FormattedText setBold(boolean isBold) {
        this.isBold = isBold;
        return this;
    }

    public boolean isItalic() {
        return this.isItalic;
    }

    public FormattedText setItalic(boolean isItalic) {
        this.isItalic = isItalic;
        return this;
    }

    public boolean isStrikethrough() {
        return this.isStrikethrough;
    }

    public FormattedText setStrikethrough(boolean isStrikethrough) {
        this.isStrikethrough = isStrikethrough;
        return this;
    }

    public boolean isUnderlined() {
        return this.isUnderlined;
    }

    public FormattedText setUnderlined(boolean isUnderlined) {
        this.isUnderlined = isUnderlined;
        return this;
    }

    public boolean isObfuscated() {
        return this.isObfuscated();
    }

    public FormattedText setObfuscated(boolean isObfuscated) {
        this.isObfuscated = isObfuscated;
        return this;
    }

    public String getJSONString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\"text\": \"" + this.text.replace("\"", "\\\"") + "\"");
        if (this.hasColor()) {
            sb.append(",");
            sb.append("\"color\": \"" + this.color.name().toLowerCase() + "\"");
        }
        if (this.hasFormat()) {
            if (this.isBold) {
                sb.append(",");
                sb.append("\"bold\": \"true\"");
            }
            if (this.isItalic) {
                sb.append(",");
                sb.append("\"italic\": \"true\"");
            }
            if (this.isStrikethrough) {
                sb.append(",");
                sb.append("\"strikethrough\": \"true\"");
            }
            if (this.isUnderlined) {
                sb.append(",");
                sb.append("\"underlined\": \"true\"");
            }
            if (this.isObfuscated) {
                sb.append(",");
                sb.append("\"obfuscated\": \"true\"");
            }
        }
        return sb.toString();
    }
}

