/*
 * Decompiled with CFR 0.152.
 */
package com.ebiggz.postalservice.apis.InteractiveMessageAPI;

import com.ebiggz.postalservice.apis.InteractiveMessageAPI.FormattedText;
import com.ebiggz.postalservice.apis.InteractiveMessageAPI.InteractiveMessageElement;
import java.util.LinkedList;
import java.util.Queue;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class InteractiveMessage {
    private Queue<InteractiveMessageElement> elements = new LinkedList<InteractiveMessageElement>();

    public InteractiveMessage() {
    }

    public InteractiveMessage(InteractiveMessageElement element) {
        this.elements.add(element);
    }

    public InteractiveMessage addElement(String text) {
        this.elements.add(new InteractiveMessageElement(text));
        return this;
    }

    public InteractiveMessage addElement(String text, ChatColor color) {
        this.elements.add(new InteractiveMessageElement(new FormattedText(text, color)));
        return this;
    }

    public InteractiveMessage addElement(FormattedText text) {
        this.elements.add(new InteractiveMessageElement(text));
        return this;
    }

    public InteractiveMessage addElement(InteractiveMessageElement element) {
        this.elements.add(element);
        return this;
    }

    public void sendTo(Player player) {
        Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), this.getFormattedCommand(player.getName()));
    }

    public void sendTo(CommandSender sender) {
        if (!(sender instanceof Player)) {
            return;
        }
        Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), this.getFormattedCommand(sender.getName()));
    }

    private String getFormattedCommand(String playerName) {
        StringBuilder sb = new StringBuilder();
        sb.append("tellraw " + playerName + " {\"text\":\"\",\"extra\":[");
        int count = this.elements.size();
        for (InteractiveMessageElement element : this.elements) {
            sb.append("{");
            sb.append(element.getMainText().getJSONString());
            if (element.hasClickEvent()) {
                sb.append(",");
                sb.append("\"clickEvent\": {");
                sb.append("\"action\": \"" + element.getClickEventType().toString().toLowerCase() + "\",");
                sb.append("\"value\": \"" + element.getCommand() + "\"");
                sb.append("}");
            }
            if (element.hasHoverEvent()) {
                sb.append(",");
                sb.append("\"hoverEvent\": {");
                sb.append("\"action\": \"" + element.getHoverEventType().toString().toLowerCase() + "\",");
                sb.append("\"value\": {");
                sb.append("\"text\": \"\",");
                sb.append("\"extra\": [{");
                sb.append(element.getHoverText().getJSONString());
                sb.append("}]}}");
            }
            sb.append("}");
            if (--count <= 0) continue;
            sb.append(",");
        }
        sb.append("]}");
        return sb.toString();
    }
}

