/*
 * Decompiled with CFR 0.152.
 */
package com.ebiggz.postalservice.apis.InteractiveMessageAPI;

import com.ebiggz.postalservice.apis.InteractiveMessageAPI.FormattedText;

public class InteractiveMessageElement {
    private FormattedText text;
    private HoverEvent hoverEventType;
    private FormattedText hoverText;
    private ClickEvent clickEventType;
    private String command;

    public InteractiveMessageElement(String text) {
        this(text, HoverEvent.NONE, null, ClickEvent.NONE, null);
    }

    public InteractiveMessageElement(FormattedText text) {
        this(text, HoverEvent.NONE, null, ClickEvent.NONE, null);
    }

    public InteractiveMessageElement(String textString, HoverEvent hoverEventType, String hoverTextString, ClickEvent clickEventType, String command) {
        this(new FormattedText(textString), hoverEventType, new FormattedText(hoverTextString), clickEventType, command);
    }

    public InteractiveMessageElement(FormattedText text, HoverEvent hoverEventType, FormattedText hoverText, ClickEvent clickEventType, String command) {
        this.text = text;
        this.hoverEventType = hoverEventType;
        this.hoverText = hoverText;
        this.clickEventType = clickEventType;
        this.command = command;
    }

    public FormattedText getMainText() {
        return this.text;
    }

    public HoverEvent getHoverEventType() {
        return this.hoverEventType;
    }

    public boolean hasHoverEvent() {
        return this.hoverEventType != HoverEvent.NONE;
    }

    public FormattedText getHoverText() {
        return this.hoverText;
    }

    public ClickEvent getClickEventType() {
        return this.clickEventType;
    }

    public boolean hasClickEvent() {
        return this.clickEventType != ClickEvent.NONE;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public static enum ClickEvent {
        SUGGEST_COMMAND,
        RUN_COMMAND,
        OPEN_URL,
        NONE;

    }

    public static enum HoverEvent {
        SHOW_TEXT,
        NONE;

    }
}

