/*
 * Decompiled with CFR 0.152.
 */
package com.ebiggz.postalservice.apis.guiAPI;

import com.ebiggz.postalservice.PostalService;
import com.ebiggz.postalservice.apis.guiAPI.GUI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitScheduler;

public class GUIManager {
    private HashMap<Player, GUI> openGUIs = new HashMap();
    private HashMap<GUI, List<ItemStack>> guiInvs = new HashMap();
    private static GUIManager instance = null;

    protected GUIManager() {
    }

    public static GUIManager getInstance() {
        if (instance == null) {
            instance = new GUIManager();
        }
        return instance;
    }

    public void showGUI(GUI gui, Player player) {
        if (gui == null || player == null) {
            return;
        }
        player.closeInventory();
        Inventory inv = gui.createBaseInventory(player);
        this.openGUIs.put(player, gui);
        this.guiInvs.put(gui, Arrays.asList(inv.getContents()));
        player.openInventory(inv);
        BukkitScheduler scheduler = Bukkit.getServer().getScheduler();
        scheduler.runTaskAsynchronously(PostalService.getPlugin(), new Runnable(){
            private GUI gui;
            private Player player;

            @Override
            public void run() {
                ItemStack[] contents = this.gui.loadContents(this.player);
                BukkitScheduler scheduler = Bukkit.getServer().getScheduler();
                scheduler.runTask(PostalService.getPlugin(), new Runnable(){
                    private ItemStack[] contents;

                    @Override
                    public void run() {
                        if (GUIManager.getInstance().playerIsViewingGUI(player, gui)) {
                            GUIManager.this.guiInvs.put(gui, Arrays.asList(this.contents));
                            player.getOpenInventory().getTopInventory().setContents(this.contents);
                        }
                    }

                    public Runnable init(ItemStack[] contents) {
                        this.contents = contents;
                        return this;
                    }
                }.init(contents));
            }

            public Runnable init(GUI gui, Player player) {
                this.gui = gui;
                this.player = player;
                return this;
            }
        }.init(gui, player));
    }

    public void playerClosedGUI(Player player) {
        this.guiInvs.remove(this.getPlayersCurrentGUI(player));
        this.openGUIs.remove(player);
    }

    public List<ItemStack> getGUIsCurrentInv(GUI gui) {
        if (this.guiInvs.containsKey(gui)) {
            return this.guiInvs.get(gui);
        }
        return null;
    }

    public void setGUIInv(GUI gui, List<ItemStack> items) {
        if (this.guiInvs.containsKey(gui)) {
            this.guiInvs.remove(gui);
            this.guiInvs.put(gui, items);
        }
    }

    public GUI getPlayersCurrentGUI(Player player) {
        if (this.openGUIs.containsKey(player)) {
            return this.openGUIs.get(player);
        }
        return null;
    }

    public boolean playerIsViewingGUI(Player player, GUI gui) {
        GUI openGUI = this.getPlayersCurrentGUI(player);
        return openGUI != null && openGUI.equals(gui);
    }

    public void closeAllGUIs() {
        for (Player player : this.openGUIs.keySet()) {
            player.closeInventory();
        }
    }

    public boolean playerHasGUIOpen(Player player) {
        return this.openGUIs.containsKey(player);
    }
}

