/*
 * Decompiled with CFR 0.152.
 */
package com.ebiggz.postalservice.backend;

import com.ebiggz.postalservice.backend.DBUser;
import com.ebiggz.postalservice.backend.User;
import com.ebiggz.postalservice.config.Config;
import java.util.UUID;
import org.bukkit.entity.Player;

public class UserFactory {
    public static User getUser(String name) {
        if (Config.USE_DATABASE) {
            return new DBUser(name);
        }
        return null;
    }

    public static User getUser(Player player) {
        if (Config.USE_DATABASE) {
            if (Config.USE_UUIDS) {
                return new DBUser(player.getUniqueId());
            }
            return new DBUser(player.getName());
        }
        return null;
    }

    public static User getUserFromIdentifier(String identifier) {
        if (Config.USE_DATABASE) {
            if (Config.USE_UUIDS) {
                return new DBUser(UUID.fromString(identifier));
            }
            return new DBUser(identifier);
        }
        return null;
    }
}

