/*
 * Decompiled with CFR 0.152.
 */
package com.ebiggz.postalservice.backend.database;

import com.ebiggz.postalservice.PostalService;
import com.ebiggz.postalservice.config.Config;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.bukkit.plugin.Plugin;

public abstract class Database {
    protected Connection connection;
    protected Plugin plugin;

    protected Database(Plugin plugin) {
        this.plugin = plugin;
        this.connection = null;
    }

    public abstract Connection openConnection() throws SQLException, ClassNotFoundException;

    public boolean checkConnection() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.createTables();
            return true;
        }
        return false;
    }

    private void createTables() {
        block2: {
            try {
                this.createTable("ps_users", "PlayerID varchar(255) NOT NULL KEY, PlayerName varchar(255) NOT NULL, TimeZone varchar(255)");
                this.createTable("ps_mail", "MailID BIGINT AUTO_INCREMENT KEY, MailType varchar(255) NOT NULL, Message text, Attachments longtext, Timestamp DATETIME, SenderID varchar(255) NOT NULL, Deleted int DEFAULT 0, WorldGroup varchar(255)");
                this.createTable("ps_received", "ReceivedID BIGINT AUTO_INCREMENT KEY, RecipientID varchar(255) NOT NULL, MailID INT NOT NULL, Status INT DEFAULT 0, Deleted INT DEFAULT 0");
                this.createTable("ps_dropboxes", "DropboxID INT AUTO_INCREMENT KEY, Contents LONGBLOB, PlayerID varchar(255) NOT NULL, WorldGroup varchar(255) NOT NULL");
                this.createTable("ps_mailboxes", "Location varchar(255) NOT NULL KEY, PlayerID varchar(255) NOT NULL");
            }
            catch (Exception e) {
                PostalService.getPlugin().getLogger().severe("Unable to create tables in database, plugin may not function as intended!");
                if (!Config.ENABLE_DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    public void createTable(String name, String columns) throws SQLException {
        DatabaseMetaData dbm = this.connection.getMetaData();
        ResultSet tables = dbm.getTables(null, null, name, null);
        if (!tables.next()) {
            Statement statement = this.connection.createStatement();
            statement.executeUpdate("CREATE TABLE " + name + "(" + columns + ")");
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean closeConnection() throws SQLException {
        if (this.connection == null) {
            return false;
        }
        this.connection.close();
        return true;
    }

    public ResultSet querySQL(String query) throws SQLException, ClassNotFoundException {
        if (!this.checkConnection()) {
            this.openConnection();
        }
        Statement statement = this.connection.createStatement();
        ResultSet result = statement.executeQuery(query);
        return result;
    }

    public int updateSQL(String query) throws SQLException, ClassNotFoundException {
        if (!this.checkConnection()) {
            this.openConnection();
        }
        Statement statement = this.connection.createStatement();
        int result = statement.executeUpdate(query);
        return result;
    }
}

