/*
 * Decompiled with CFR 0.152.
 */
package com.ebiggz.postalservice.commands;

import com.ebiggz.postalservice.config.Config;
import com.ebiggz.postalservice.config.Language;
import com.ebiggz.postalservice.mail.MailManager;
import com.ebiggz.postalservice.mail.MailType;
import com.ebiggz.postalservice.permissions.PermissionHandler;
import com.ebiggz.postalservice.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class MailTabCompleter
implements TabCompleter {
    public List<String> onTabComplete(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (commandLabel.equalsIgnoreCase(Language.Phrases.COMMAND_MAIL.toString())) {
            if (args.length == 0) {
                return null;
            }
            if (args.length == 1) {
                ArrayList<String> arg1List = new ArrayList<String>();
                String[] stringArray = MailManager.getInstance().getMailTypeNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    if (PermissionHandler.playerCanMailType(name, sender)) {
                        arg1List.add(name.toLowerCase());
                    }
                    ++n2;
                }
                if (PermissionHandler.playerHasPermission(PermissionHandler.Perm.MAIL_CHECK, sender, false)) {
                    arg1List.add(Language.Phrases.COMMAND_ARG_CHECK.toString());
                }
                if (PermissionHandler.playerHasPermission(PermissionHandler.Perm.MAIL_CHECK, sender, false)) {
                    arg1List.add(Language.Phrases.COMMAND_ARG_HELP.toString());
                }
                arg1List.add(Language.Phrases.COMMAND_ARG_TIMEZONE.toString());
                return Utils.getAllStartsWith(args[0], arg1List);
            }
            if (args[0].equalsIgnoreCase(Language.Phrases.COMMAND_ARG_TIMEZONE.toString())) {
                return Utils.getAllStartsWith(args[1], Config.TIMEZONES);
            }
            List<String> matches = Utils.getNamesThatStartWith(args[args.length - 1]);
            if (!matches.isEmpty()) {
                return matches;
            }
            MailType mailType = MailManager.getInstance().getMailTypeByName(args[0]);
            if (mailType != null) {
                ArrayList<String> cmdArgs = new ArrayList<String>();
                String to = String.valueOf(Language.Phrases.COMMAND_ARG_TO.toString()) + ":";
                String message = String.valueOf(Language.Phrases.COMMAND_ARG_MESSAGE.toString()) + ":";
                String typeArg = mailType.getAttachmentCommandArgument();
                if (!this.argsContainString(args, to)) {
                    cmdArgs.add(to);
                }
                if (!this.argsContainString(args, message)) {
                    cmdArgs.add(message);
                }
                if (typeArg != null && !typeArg.isEmpty() && !this.argsContainString(args, String.valueOf(typeArg) + ":")) {
                    cmdArgs.add(String.valueOf(typeArg) + ":");
                }
                return Utils.getAllStartsWith(args[args.length - 1], cmdArgs);
            }
        }
        return null;
    }

    private boolean argsContainString(String[] args, String string) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.startsWith(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

