/*
 * Decompiled with CFR 0.152.
 */
package com.ebiggz.postalservice.commands;

import com.ebiggz.postalservice.PostalService;
import com.ebiggz.postalservice.config.Config;
import com.ebiggz.postalservice.config.Language;
import com.ebiggz.postalservice.mailbox.MailboxManager;
import com.ebiggz.postalservice.permissions.PermissionHandler;
import com.ebiggz.postalservice.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitScheduler;

public class MailboxCommands
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (!Config.ENABLE_MAILBOXES) {
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(Language.Phrases.ERROR_CONSOLE_COMMAND.toString());
            return true;
        }
        Player player = (Player)sender;
        if (Config.playerIsInBlacklistedWorld(player)) {
            if (!PermissionHandler.playerHasPermission(PermissionHandler.Perm.OVERRIDE_WORLD_BLACKLIST, sender, false)) {
                sender.sendMessage(Language.Phrases.ERROR_BLACKLISTED_WORLD.toPrefixedString());
                return true;
            }
            sender.sendMessage(Language.Phrases.ALERT_BLACKLISTED_WORLD_OVERRIDE.toPrefixedString());
        }
        if (commandLabel.equalsIgnoreCase(Language.Phrases.COMMAND_MAILBOX.toString()) || commandLabel.equalsIgnoreCase("mailbox") || commandLabel.equalsIgnoreCase("mb")) {
            if (args.length == 0) {
                Utils.fancyHelpMenu(sender, String.valueOf(Language.Phrases.COMMAND_MAIL.toString()) + " " + Language.Phrases.COMMAND_ARG_HELP.toString()).sendPage(1, sender);
            } else if (args.length >= 1) {
                if (args[0].equalsIgnoreCase(Language.Phrases.COMMAND_ARG_SET.toString())) {
                    if (!PermissionHandler.playerHasPermission(PermissionHandler.Perm.MAILBOX_SET, sender, true)) {
                        return true;
                    }
                    MailboxManager.getInstance().mailboxSelectors.put((Player)sender, MailboxManager.MailboxSelect.SET);
                    sender.sendMessage(Language.Phrases.ALERT_MAILBOX_SET.toPrefixedString());
                } else if (args[0].equalsIgnoreCase(Language.Phrases.COMMAND_ARG_REMOVE.toString())) {
                    if (!PermissionHandler.playerHasPermission(PermissionHandler.Perm.MAILBOX_REMOVE, sender, true)) {
                        return true;
                    }
                    MailboxManager.getInstance().mailboxSelectors.put((Player)sender, MailboxManager.MailboxSelect.REMOVE);
                    sender.sendMessage(Language.Phrases.ALERT_MAILBOX_REMOVE.toPrefixedString());
                } else if (args[0].equalsIgnoreCase(Language.Phrases.COMMAND_ARG_REMOVEALL.toString())) {
                    if (args.length == 1) {
                        if (!PermissionHandler.playerHasPermission(PermissionHandler.Perm.MAILBOX_REMOVEALL, sender, true)) {
                            return true;
                        }
                        MailboxManager.getInstance().removeAllMailboxes((Player)sender, sender.getName());
                        sender.sendMessage(Language.Phrases.ALERT_MAILBOX_REMOVE_ALL.toPrefixedString());
                    } else {
                        if (!PermissionHandler.playerHasPermission(PermissionHandler.Perm.MAILBOX_REMOVEALLOTHER, sender, true)) {
                            return true;
                        }
                        String completedName = Utils.completeName(args[1]);
                        if (completedName == null || completedName.isEmpty()) {
                            completedName = args[1];
                        }
                        MailboxManager.getInstance().removeAllMailboxes((Player)sender, completedName);
                        sender.sendMessage(Language.Phrases.ALERT_MAILBOX_REMOVE_ALL_OTHER.toPrefixedString().replace("%player%", completedName));
                    }
                } else if (args[0].equalsIgnoreCase(Language.Phrases.COMMAND_ARG_FIND.toString())) {
                    if (!PermissionHandler.playerHasPermission(PermissionHandler.Perm.MAILBOX_FIND, sender, true)) {
                        return true;
                    }
                    if (MailboxManager.getInstance().markNearbyMailboxes(player)) {
                        sender.sendMessage(Language.Phrases.ALERT_MAILBOX_FIND.toPrefixedString());
                    } else {
                        sender.sendMessage(Language.Phrases.ERROR_MAILBOX_FIND_NONE.toPrefixedString());
                    }
                }
                if (args[0].equalsIgnoreCase(Language.Phrases.COMMAND_ARG_SET.toString()) || args[0].equalsIgnoreCase(Language.Phrases.COMMAND_ARG_REMOVE.toString())) {
                    BukkitScheduler scheduler = Bukkit.getServer().getScheduler();
                    scheduler.scheduleSyncDelayedTask(PostalService.getPlugin(), (new Runnable(){
                        private Player player;

                        @Override
                        public void run() {
                            if (MailboxManager.getInstance().mailboxSelectors.containsKey(this.player)) {
                                MailboxManager.getInstance().mailboxSelectors.remove(this.player);
                                this.player.sendMessage(Language.Phrases.ALERT_MAILBOX_TIMEOUT.toPrefixedString());
                            }
                        }

                        private Runnable init(Player player) {
                            this.player = player;
                            return this;
                        }
                    }).init(player), 100L);
                }
            }
        }
        return true;
    }
}

