/*
 * Decompiled with CFR 0.152.
 */
package com.ebiggz.postalservice.config;

import com.ebiggz.postalservice.PostalService;
import com.ebiggz.postalservice.backend.User;
import com.ebiggz.postalservice.config.WorldGroup;
import com.ebiggz.postalservice.mail.MailManager;
import com.ebiggz.postalservice.mail.MailType;
import com.ebiggz.postalservice.utils.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class Config {
    public static boolean ENABLE_WORLD_GROUPS;
    public static List<WorldGroup> WORLD_GROUPS;
    private static List<String> MAILTYPES_IGNORE_WORLD_GROUPS;
    public static List<String> WORLD_BLACKLIST;
    private static List<String> DISABLED_MAILTYPES;
    public static boolean ENABLE_DEBUG;
    public static boolean USE_DATABASE;
    public static boolean USE_UUIDS;
    public static boolean FORCE_UUIDS;
    public static boolean CHECK_FOR_UPDATES;
    public static AutoDownloadType AUTO_DOWNLOAD_TYPE;
    public static Map<String, Integer> INBOX_SIZES;
    public static boolean UNREAD_NOTIFICATION_ON_RECEIVE;
    public static boolean UNREAD_NOTIFICATION_LOGIN;
    public static boolean HARD_ENFORCE_INBOX_LIMIT;
    public static boolean ENABLE_MAILBOXES;
    public static boolean REQUIRE_MAILBOX;
    public static Map<String, Integer> MAILBOX_LIMITS;
    public static boolean ENABLE_TRADINGPOST;
    public static boolean REQUIRE_SAME_MAILBOX;
    public static boolean ALLOW_CROSS_WORLD_TRADES;
    public static String DATE_FORMAT;
    public static String LOCALE_TAG;
    public static String DEFAULT_TIMEZONE;
    public static List<String> TIMEZONES;
    private static double CONFIG_VERSION;

    static {
        USE_DATABASE = true;
        FORCE_UUIDS = false;
        CONFIG_VERSION = 1.0;
    }

    public static void loadFile() {
        Config.loadConfig();
        Config.loadOptions();
        if (CONFIG_VERSION != 1.0) {
            PostalService.getPlugin().getLogger().warning("Your config file appears to be out of date and there may be new options. Rename your current config to have a new one generate!");
        }
    }

    private static void loadConfig() {
        Plugin plugin = PostalService.getPlugin();
        PluginManager pm = plugin.getServer().getPluginManager();
        String pluginFolder = plugin.getDataFolder().getAbsolutePath();
        new File(pluginFolder).mkdirs();
        File configFile = new File(pluginFolder, "config.yml");
        if (!configFile.exists()) {
            PostalService.getPlugin().saveResource("config.yml", true);
        }
        try {
            PostalService.getPlugin().reloadConfig();
        }
        catch (Exception e) {
            Bukkit.getLogger().log(Level.SEVERE, "Exception while loading PostalService/config.yml", e);
            pm.disablePlugin(plugin);
        }
    }

    private static void loadOptions() {
        FileConfiguration config;
        block19: {
            config = PostalService.getPlugin().getConfig();
            CONFIG_VERSION = config.getDouble("config-version");
            ENABLE_DEBUG = config.getBoolean("debug-mode", false);
            ENABLE_WORLD_GROUPS = config.getBoolean("enable-world-groups", false);
            WORLD_GROUPS = new ArrayList<WorldGroup>();
            ConfigurationSection wgConfigSec = config.getConfigurationSection("world-groups");
            if (wgConfigSec != null) {
                for (String worldGroupName : wgConfigSec.getKeys(false)) {
                    Utils.debugMessage("Loading world group: " + worldGroupName);
                    List worldNames = wgConfigSec.getStringList(worldGroupName);
                    if (worldNames.isEmpty()) {
                        Utils.debugMessage(String.valueOf(worldGroupName) + " is empty! Oh no!");
                        continue;
                    }
                    Utils.debugMessage("Added worlds: " + worldNames.toString() + " to " + worldGroupName);
                    WORLD_GROUPS.add(new WorldGroup(worldGroupName, worldNames));
                }
            }
            if (ENABLE_WORLD_GROUPS && WORLD_GROUPS.isEmpty()) {
                ENABLE_WORLD_GROUPS = false;
            }
            MAILTYPES_IGNORE_WORLD_GROUPS = config.getStringList("mail-types-that-ignore-world-groups");
            WORLD_BLACKLIST = config.getStringList("world-blacklist");
            DISABLED_MAILTYPES = new ArrayList<String>();
            ConfigurationSection mtConfigSection = config.getConfigurationSection("enabled-mail-types");
            if (mtConfigSection != null) {
                for (String mailTypeNode : mtConfigSection.getKeys(false)) {
                    if (mtConfigSection.getBoolean(mailTypeNode, true)) continue;
                    DISABLED_MAILTYPES.add(mailTypeNode);
                    MailManager.getInstance().deregisterMailTypeByName(mailTypeNode);
                }
            }
            String uuidValue = config.getString("use-uuids", "true");
            try {
                USE_UUIDS = Boolean.parseBoolean(uuidValue);
            }
            catch (Exception e) {
                USE_UUIDS = true;
                if (!uuidValue.equalsIgnoreCase("always")) break block19;
                FORCE_UUIDS = true;
            }
        }
        CHECK_FOR_UPDATES = config.getBoolean("update-checker.enabled", true);
        String autoDownloadSetting = config.getString("update-checker.auto-download", "all");
        AUTO_DOWNLOAD_TYPE = AutoDownloadType.ALL;
        if (autoDownloadSetting.equalsIgnoreCase("bugfix")) {
            AUTO_DOWNLOAD_TYPE = AutoDownloadType.BUGFIXES;
        } else if (autoDownloadSetting.equalsIgnoreCase("none") || autoDownloadSetting.equalsIgnoreCase("off") || autoDownloadSetting.equalsIgnoreCase("false")) {
            AUTO_DOWNLOAD_TYPE = AutoDownloadType.NONE;
        }
        DATE_FORMAT = config.getString("date-format", "MMM d, yyyy h:mm a");
        LOCALE_TAG = config.getString("locale-tag", "en-US");
        DEFAULT_TIMEZONE = config.getString("time-zone");
        ArrayList<String> zonesTrim = new ArrayList<String>();
        String[] stringArray = TimeZone.getAvailableIDs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String zone = stringArray[n2];
            if (zone.length() <= 3) {
                zonesTrim.add(zone);
            }
            ++n2;
        }
        Collections.sort(zonesTrim);
        TIMEZONES = zonesTrim;
        INBOX_SIZES = new HashMap<String, Integer>();
        ConfigurationSection inboxLimitsCS = config.getConfigurationSection("box-sizes");
        if (inboxLimitsCS != null) {
            for (String permGroup : inboxLimitsCS.getKeys(false)) {
                INBOX_SIZES.put(permGroup, inboxLimitsCS.getInt(permGroup, 50));
            }
        }
        if (!INBOX_SIZES.containsKey("default")) {
            INBOX_SIZES.put("default", 50);
        }
        UNREAD_NOTIFICATION_LOGIN = config.getBoolean("unread-mail-notifications.on-login", true);
        UNREAD_NOTIFICATION_ON_RECEIVE = config.getBoolean("unread-mail-notifications.on-recieve-mail", true);
        HARD_ENFORCE_INBOX_LIMIT = config.getBoolean("hard-enforce-inbox-limit", true);
        ENABLE_MAILBOXES = config.getBoolean("enable-mailboxes", true);
        REQUIRE_MAILBOX = config.getBoolean("require-mailbox", true);
        MAILBOX_LIMITS = new HashMap<String, Integer>();
        ConfigurationSection mailboxLimitsCS = config.getConfigurationSection("mailbox-limits");
        if (mailboxLimitsCS != null) {
            for (String permGroup : mailboxLimitsCS.getKeys(false)) {
                MAILBOX_LIMITS.put(permGroup, mailboxLimitsCS.getInt(permGroup, 5));
            }
        }
        if (!MAILBOX_LIMITS.containsKey("default")) {
            MAILBOX_LIMITS.put("default", 5);
        }
    }

    public static boolean mailTypeIsDisabled(MailType mailType) {
        return Config.mailTypeIsDisabled(mailType.getDisplayName());
    }

    public static boolean packagesAreEnabled() {
        return !Config.mailTypeIsDisabled("package");
    }

    public static boolean mailTypeIsDisabled(String name) {
        for (String type : DISABLED_MAILTYPES) {
            if (!type.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean playerIsInBlacklistedWorld(Player player) {
        return WORLD_BLACKLIST.contains(player.getWorld().getName());
    }

    public static int getMaxInboxSizeForPlayer(String playerName) {
        if (PostalService.foundPermPlugin()) {
            String primaryGroup = PostalService.permission.getPrimaryGroup("", playerName);
            if (primaryGroup != null) {
                if (INBOX_SIZES.containsKey(primaryGroup)) {
                    return INBOX_SIZES.get(primaryGroup);
                }
            } else if (ENABLE_DEBUG) {
                PostalService.getPlugin().getLogger().warning("Could not get the primary group for player: " + playerName);
            }
        }
        return INBOX_SIZES.get("default");
    }

    public static int getMailboxLimitForPlayer(String playerName) {
        if (PostalService.foundPermPlugin()) {
            String primaryGroup = PostalService.permission.getPrimaryGroup("", playerName);
            if (primaryGroup != null) {
                if (MAILBOX_LIMITS.containsKey(primaryGroup)) {
                    return MAILBOX_LIMITS.get(primaryGroup);
                }
            } else if (ENABLE_DEBUG) {
                PostalService.getPlugin().getLogger().warning("Could not get the primary group for player: " + playerName);
            }
        }
        return MAILBOX_LIMITS.get("default");
    }

    public static WorldGroup getCurrentWorldGroupForUser(User user) {
        Player player = Utils.getPlayerFromIdentifier(user.getIdentifier());
        if (player != null && player.isOnline()) {
            return Config.getWorldGroupFromWorld(player.getWorld());
        }
        return new WorldGroup("None", new ArrayList<String>());
    }

    public static WorldGroup getWorldGroupFromWorld(String worldName) {
        if (!ENABLE_WORLD_GROUPS) {
            return new WorldGroup("None", new ArrayList<String>());
        }
        for (WorldGroup worldGroup : WORLD_GROUPS) {
            if (!worldGroup.hasWorld(worldName)) continue;
            return worldGroup;
        }
        return new WorldGroup("None", new ArrayList<String>());
    }

    public static WorldGroup getWorldGroupFromWorld(World world) {
        if (world == null) {
            Utils.debugMessage("null world passed. No world group will be found.");
            return new WorldGroup("None", new ArrayList<String>());
        }
        return Config.getWorldGroupFromWorld(world.getName());
    }

    public static boolean containsMailTypesThatIgnoreWorldGroups() {
        return MAILTYPES_IGNORE_WORLD_GROUPS != null && !MAILTYPES_IGNORE_WORLD_GROUPS.isEmpty();
    }

    public static List<String> getMailTypesThatIgnoreWorldGroups() {
        return MAILTYPES_IGNORE_WORLD_GROUPS;
    }

    public static WorldGroup getWorldGroupFromGroupName(String string) {
        if (!ENABLE_WORLD_GROUPS) {
            return new WorldGroup("None", new ArrayList<String>());
        }
        for (WorldGroup worldGroup : WORLD_GROUPS) {
            if (!worldGroup.getName().equalsIgnoreCase(string)) continue;
            Utils.debugMessage("Found: " + worldGroup.getName());
            return worldGroup;
        }
        return new WorldGroup("None", new ArrayList<String>());
    }

    public static enum AutoDownloadType {
        BUGFIXES,
        ALL,
        NONE;

    }
}

