/*
 * Decompiled with CFR 0.152.
 */
package com.ebiggz.postalservice.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ConfigAccessor {
    private Plugin plugin = Bukkit.getServer().getPluginManager().getPlugin("PostalService");
    private final String fileName;
    private File configFile;
    private FileConfiguration fileConfiguration;
    private String folderPath;

    public ConfigAccessor(String fileName) {
        if (this.plugin == null) {
            throw new IllegalArgumentException("plugin cannot be null");
        }
        this.fileName = fileName;
        this.folderPath = this.plugin.getDataFolder().getAbsolutePath();
        this.configFile = new File(String.valueOf(this.folderPath) + File.separator + fileName);
    }

    public void reloadConfig() {
        this.fileConfiguration = YamlConfiguration.loadConfiguration((File)this.configFile);
        InputStream defConfigStream = this.plugin.getResource(this.fileName);
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((InputStream)defConfigStream);
            this.fileConfiguration.setDefaults((Configuration)defConfig);
        }
    }

    public FileConfiguration getConfig() {
        if (this.fileConfiguration == null) {
            this.reloadConfig();
        }
        return this.fileConfiguration;
    }

    public void saveConfig() {
        if (this.fileConfiguration == null || this.configFile == null) {
            return;
        }
        try {
            this.getConfig().save(this.configFile);
        }
        catch (IOException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save config to " + this.configFile, ex);
        }
    }

    public void saveDefaultConfig() {
        if (!this.configFile.exists()) {
            this.plugin.saveResource(this.fileName, false);
        }
    }
}

