/*
 * Decompiled with CFR 0.152.
 */
package com.ebiggz.postalservice.listeners;

import com.ebiggz.postalservice.apis.guiAPI.GUIManager;
import com.ebiggz.postalservice.backend.UserFactory;
import com.ebiggz.postalservice.config.Language;
import com.ebiggz.postalservice.events.PlayerOpenMailMenuEvent;
import com.ebiggz.postalservice.exceptions.MailboxException;
import com.ebiggz.postalservice.mailbox.Mailbox;
import com.ebiggz.postalservice.mailbox.MailboxManager;
import com.ebiggz.postalservice.permissions.PermissionHandler;
import com.ebiggz.postalservice.screens.MainMenuGUI;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class MailboxListener
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockBreak(BlockBreakEvent event) {
        Mailbox mb;
        if (event.getBlock().getType() == Material.CHEST && (mb = MailboxManager.getInstance().getMailbox(event.getBlock().getLocation())) != null) {
            event.setCancelled(true);
            event.getPlayer().sendMessage(Language.Phrases.ERROR_MAILBOX_BREAK.toPrefixedString().replace("%owner%", mb.getOwner().getPlayerName()));
        }
    }

    @EventHandler
    public void onInventoryOpenEvent(InventoryOpenEvent e) {
        if (!(e.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)e.getPlayer();
        if (GUIManager.getInstance().playerHasGUIOpen(player)) {
            return;
        }
        if (e.getInventory().getHolder() instanceof Chest) {
            Chest c = (Chest)e.getInventory().getHolder();
            Mailbox mailbox = MailboxManager.getInstance().getMailbox(c.getLocation());
            if (mailbox != null) {
                e.setCancelled(true);
                if (!PermissionHandler.playerHasPermission(PermissionHandler.Perm.MAIL_READ, (CommandSender)player, true)) {
                    return;
                }
                Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerOpenMailMenuEvent(player, UserFactory.getUser(player), mailbox));
                GUIManager.getInstance().showGUI(new MainMenuGUI(UserFactory.getUser(player)), player);
            }
        }
    }

    @EventHandler
    public void onChestPlace(BlockPlaceEvent e) {
        ItemStack item = e.getItemInHand();
        if (item.getType() == Material.CHEST) {
            for (BlockFace face : Arrays.asList(BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST)) {
                Block block = e.getBlock().getRelative(face);
                if (block.getType() != Material.CHEST || !MailboxManager.getInstance().locationHasMailbox(block.getLocation())) continue;
                e.getPlayer().sendMessage(Language.Phrases.ERROR_CHEST_PLACE.toPrefixedString());
                e.setCancelled(true);
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!event.hasBlock()) {
            return;
        }
        if (event.getAction() == Action.LEFT_CLICK_BLOCK && MailboxManager.getInstance().mailboxSelectors.containsKey(event.getPlayer())) {
            if (event.getClickedBlock().getType() != Material.CHEST) {
                event.setCancelled(true);
                event.getPlayer().sendMessage(Language.Phrases.ERROR_MAILBOX_NOT_CHEST.toPrefixedString());
            } else {
                MailboxManager.MailboxSelect selectType = MailboxManager.getInstance().mailboxSelectors.get(event.getPlayer());
                MailboxManager.getInstance().mailboxSelectors.remove(event.getPlayer());
                event.setCancelled(true);
                if (selectType == MailboxManager.MailboxSelect.SET) {
                    try {
                        MailboxManager.getInstance().addMailboxAtLoc(event.getClickedBlock().getLocation(), event.getPlayer());
                        event.getPlayer().sendMessage(Language.Phrases.ALERT_MAILBOX_REG.toPrefixedString());
                    }
                    catch (MailboxException me) {
                        switch (me.getReason()) {
                            case ALREADY_EXISTS: {
                                event.getPlayer().sendMessage(Language.Phrases.ERROR_MAILBOX_ALREADY_EXISTS.toPrefixedString());
                                break;
                            }
                            case NO_PERMISSION: {
                                event.getPlayer().sendMessage(Language.Phrases.ERROR_MAILBOX_NO_PERM.toPrefixedString());
                                break;
                            }
                            case DOUBLE_CHEST: {
                                event.getPlayer().sendMessage(Language.Phrases.ERROR_MAILBOX_DOUBLE_CHEST.toPrefixedString());
                                break;
                            }
                            case MAX_REACHED: {
                                event.getPlayer().sendMessage(Language.Phrases.ERROR_MAILBOX_MAX_REACHED.toPrefixedString());
                                break;
                            }
                            default: {
                                event.getPlayer().sendMessage(Language.Phrases.ERROR_MAILBOX_UNKNOWN.toPrefixedString());
                                break;
                            }
                        }
                    }
                } else {
                    try {
                        MailboxManager.getInstance().removeMailboxAtLoc(event.getClickedBlock().getLocation(), event.getPlayer());
                        event.getPlayer().sendMessage(Language.Phrases.ALERT_MAILBOX_UNREG.toPrefixedString());
                    }
                    catch (MailboxException me) {
                        switch (me.getReason()) {
                            case DOESNT_EXIST: {
                                event.getPlayer().sendMessage(Language.Phrases.ERROR_MAILBOX_DOESNT_EXIST.toPrefixedString());
                                break;
                            }
                            case NOT_OWNER: {
                                event.getPlayer().sendMessage(Language.Phrases.ERROR_MAILBOX_NOT_OWNER.toPrefixedString());
                                break;
                            }
                            default: {
                                event.getPlayer().sendMessage(Language.Phrases.ERROR_MAILBOX_UNKNOWN.toPrefixedString());
                            }
                        }
                    }
                }
            }
        }
    }
}

