/*
 * Decompiled with CFR 0.152.
 */
package com.ebiggz.postalservice.listeners;

import com.ebiggz.postalservice.PostalService;
import com.ebiggz.postalservice.backend.User;
import com.ebiggz.postalservice.backend.UserFactory;
import com.ebiggz.postalservice.config.Config;
import com.ebiggz.postalservice.mail.MailManager;
import com.ebiggz.postalservice.permissions.PermissionHandler;
import com.ebiggz.postalservice.utils.Updater;
import com.ebiggz.postalservice.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitScheduler;

public class PlayerListener
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDrop(PlayerDropItemEvent event) {
        if (MailManager.getInstance().willDropBook.contains(event.getPlayer())) {
            event.getItemDrop().setItemStack(new ItemStack(Material.BOOK_AND_QUILL));
            event.setCancelled(true);
            MailManager.getInstance().willDropBook.remove(event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        BukkitScheduler scheduler = Bukkit.getServer().getScheduler();
        scheduler.runTaskLaterAsynchronously(PostalService.getPlugin(), (new Runnable(){
            private Player player;

            @Override
            public void run() {
                if (Config.UNREAD_NOTIFICATION_LOGIN) {
                    User user = UserFactory.getUser(this.player);
                    Utils.unreadMailAlert(user, true);
                }
                if (Config.CHECK_FOR_UPDATES && PermissionHandler.playerHasPermission(PermissionHandler.Perm.UPDATE, (CommandSender)this.player, false)) {
                    Updater.UpdateResult result = PostalService.getUpdater().getResult();
                    if (result == Updater.UpdateResult.UPDATE_AVAILABLE) {
                        Utils.getUpdateAvailableMessage().sendTo(this.player);
                    } else if (result == Updater.UpdateResult.SUCCESS) {
                        Utils.getUpdateDownloadedMessage().sendTo(this.player);
                    }
                }
            }

            private Runnable init(Player player) {
                this.player = player;
                return this;
            }
        }).init(event.getPlayer()), 20L);
    }
}

