/*
 * Decompiled with CFR 0.152.
 */
package com.ebiggz.postalservice.mail;

import com.ebiggz.postalservice.config.Config;
import com.ebiggz.postalservice.config.WorldGroup;
import com.ebiggz.postalservice.mail.MailType;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class Mail {
    private long mailID;
    private long receivedID;
    private String sender;
    private String recipient;
    private String message;
    private String attachmentData;
    private MailType type;
    private Date time;
    private MailStatus status;
    private WorldGroup worldGroup;

    public Mail(long mailID, long receivedID, String sender, String recipient, String message, String attachmentData, MailType type, Date time, MailStatus status, WorldGroup worldGroup) {
        this.mailID = mailID;
        this.receivedID = receivedID;
        this.sender = sender;
        this.recipient = recipient;
        this.message = message;
        this.time = time;
        this.status = status;
        this.worldGroup = worldGroup;
        if (attachmentData != null && !attachmentData.equalsIgnoreCase("null")) {
            this.attachmentData = attachmentData;
        }
        if (type == null) {
            return;
        }
        this.type = type;
        if (this.hasAttachments()) {
            type.loadAttachments(attachmentData);
        }
    }

    public long getMailID() {
        return this.mailID;
    }

    public long getReceivedID() {
        return this.receivedID;
    }

    public String getMessage() {
        return this.message;
    }

    public String getSender() {
        return this.sender;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public Date getTime() {
        return this.time;
    }

    public String getTimeString(String timeZone) {
        SimpleDateFormat sdf = new SimpleDateFormat(Config.DATE_FORMAT, Locale.forLanguageTag(Config.LOCALE_TAG));
        if (timeZone != null && !timeZone.equalsIgnoreCase("null") && !timeZone.isEmpty()) {
            sdf.setTimeZone(TimeZone.getTimeZone(timeZone));
        } else {
            sdf.setTimeZone(TimeZone.getTimeZone(Config.DEFAULT_TIMEZONE));
        }
        return sdf.format(this.time);
    }

    public boolean isClaimed() {
        return this.status == MailStatus.CLAIMED;
    }

    public boolean isRead() {
        return this.status != MailStatus.UNREAD;
    }

    public boolean hasAttachments() {
        return this.attachmentData != null && !this.attachmentData.isEmpty();
    }

    public MailStatus getStatus() {
        return this.status;
    }

    public MailType getType() {
        return this.type;
    }

    public WorldGroup getWorldGroup() {
        return this.worldGroup;
    }

    public static enum MailStatus {
        UNREAD,
        READ,
        CLAIMED;

    }
}

