/*
 * Decompiled with CFR 0.152.
 */
package com.ebiggz.postalservice.mail;

import com.ebiggz.postalservice.PostalService;
import com.ebiggz.postalservice.config.Config;
import com.ebiggz.postalservice.mail.Mail;
import com.ebiggz.postalservice.mail.MailType;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;

public class MailManager {
    private List<MailType> mailTypes = new ArrayList<MailType>();
    private List<MailType> mailTypesStorage = new ArrayList<MailType>();
    public List<Player> willDropBook = new ArrayList<Player>();
    private static MailManager instance = null;

    protected MailManager() {
    }

    public static MailManager getInstance() {
        if (instance == null) {
            instance = new MailManager();
        }
        return instance;
    }

    public void loadEnabledMailTypes() {
        this.deregisterAllMailTypes();
        this.mailTypes.clear();
        for (MailType newType : this.mailTypesStorage) {
            if (Config.mailTypeIsDisabled(newType)) continue;
            this.mailTypes.add(newType);
        }
    }

    public void clearMailTypes() {
        this.mailTypesStorage.clear();
        this.mailTypes.clear();
    }

    public void deregisterAllMailTypes() {
        int i = 0;
        while (i < this.mailTypes.size()) {
            MailType type = this.mailTypes.get(i);
            this.deregisterMailType(type);
            this.mailTypes.remove(type);
            ++i;
        }
    }

    public void registerMailType(MailType newType) {
        for (MailType mailType : this.mailTypesStorage) {
            if (!mailType.getDisplayName().equalsIgnoreCase(newType.getDisplayName()) && !mailType.getIdentifier().equalsIgnoreCase(newType.getIdentifier())) continue;
            PostalService.getPlugin().getLogger().warning("A plugin attempted to register a mail type named " + newType.getDisplayName() + " with the identifier " + newType.getIdentifier() + " but a mail type with that name or identifier already exists!");
            return;
        }
        this.mailTypesStorage.add(newType);
        Permission typePerm = new Permission("postalservice.mail.send." + newType.getDisplayName().toLowerCase().trim(), PermissionDefault.FALSE);
        typePerm.addParent("postalservice.mail.send.*", true);
        PostalService.getPlugin().getServer().getPluginManager().addPermission(typePerm);
        if (!Config.mailTypeIsDisabled(newType)) {
            this.mailTypes.add(newType);
        }
    }

    public void deregisterMailType(MailType mailType) {
        this.mailTypes.remove(mailType);
    }

    public void deregisterMailTypeByIdentifier(String identifier) {
        MailType typeToRemove = null;
        for (MailType type : this.mailTypes) {
            if (!type.getIdentifier().equalsIgnoreCase(identifier)) continue;
            typeToRemove = type;
        }
        if (typeToRemove != null) {
            this.mailTypes.remove(typeToRemove);
            PostalService.getPlugin().getServer().getPluginManager().removePermission("postalservice.mail.send." + typeToRemove.getDisplayName().toLowerCase());
        }
    }

    public void deregisterMailTypeByName(String name) {
        MailType typeToRemove = null;
        for (MailType type : this.mailTypes) {
            if (!type.getDisplayName().equalsIgnoreCase(name)) continue;
            typeToRemove = type;
        }
        if (typeToRemove != null) {
            this.mailTypes.remove(typeToRemove);
            PostalService.getPlugin().getServer().getPluginManager().removePermission("postalservice.mail.send." + typeToRemove.getDisplayName().toLowerCase());
        }
    }

    public String[] getMailTypeNames() {
        String[] mailTypeNames = new String[this.mailTypes.size()];
        int i = 0;
        while (i < this.mailTypes.size()) {
            mailTypeNames[i] = this.mailTypes.get(i).getDisplayName();
            ++i;
        }
        return mailTypeNames;
    }

    public MailType[] getMailTypes() {
        MailType[] types;
        block3: {
            types = new MailType[this.mailTypes.size()];
            try {
                int i = 0;
                while (i < this.mailTypes.size()) {
                    types[i] = (MailType)this.mailTypes.get(i).getClass().newInstance();
                    ++i;
                }
            }
            catch (Exception e) {
                if (!Config.ENABLE_DEBUG) break block3;
                e.printStackTrace();
            }
        }
        return types;
    }

    public String[] getMailTypeIdentifiers() {
        String[] mailTypeNames = new String[this.mailTypes.size()];
        int i = 0;
        while (i < this.mailTypes.size()) {
            mailTypeNames[i] = this.mailTypes.get(i).getIdentifier();
            ++i;
        }
        return mailTypeNames;
    }

    public MailType getMailTypeByName(String name) {
        for (MailType mailType : this.mailTypes) {
            if (!mailType.getDisplayName().equalsIgnoreCase(name)) continue;
            try {
                return (MailType)mailType.getClass().newInstance();
            }
            catch (Exception e) {
                if (!Config.ENABLE_DEBUG) continue;
                e.printStackTrace();
            }
        }
        return null;
    }

    public MailType getMailTypeByIdentifier(String identifier) {
        for (MailType mailType : this.mailTypes) {
            if (!mailType.getIdentifier().equalsIgnoreCase(identifier)) continue;
            try {
                return (MailType)mailType.getClass().newInstance();
            }
            catch (Exception e) {
                if (!Config.ENABLE_DEBUG) continue;
                e.printStackTrace();
            }
        }
        return null;
    }

    public Mail.MailStatus getMailStatusFromID(int id) {
        switch (id) {
            case 0: {
                return Mail.MailStatus.UNREAD;
            }
            case 1: {
                return Mail.MailStatus.READ;
            }
            case 2: {
                return Mail.MailStatus.CLAIMED;
            }
        }
        return null;
    }

    public int getIDforMailStatus(Mail.MailStatus status) {
        switch (status) {
            case CLAIMED: {
                return 2;
            }
            case READ: {
                return 1;
            }
            case UNREAD: {
                return 0;
            }
        }
        return 0;
    }

    public static enum BoxType {
        SENT,
        INBOX;

    }
}

