/*
 * Decompiled with CFR 0.152.
 */
package com.ebiggz.postalservice.mail.mailtypes;

import com.ebiggz.postalservice.PostalService;
import com.ebiggz.postalservice.config.Config;
import com.ebiggz.postalservice.config.Language;
import com.ebiggz.postalservice.exceptions.MailException;
import com.ebiggz.postalservice.mail.MailType;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Payment
implements MailType {
    private double amount;

    @Override
    public String getIdentifier() {
        return "Payment";
    }

    @Override
    public String getDisplayName() {
        return Language.Phrases.MAILTYPE_PAYMENT.toString();
    }

    @Override
    public Material getIcon() {
        return Material.GOLD_INGOT;
    }

    @Override
    public String getHoveroverDescription() {
        return Language.Phrases.MAILTYPE_PAYMENT_HOVERTEXT.toString();
    }

    @Override
    public boolean requireMessage() {
        return false;
    }

    @Override
    public String getAttachmentCommandArgument() {
        return Language.Phrases.COMMAND_ARG_AMOUNT.toString();
    }

    @Override
    public String handleSendCommand(Player sender, String[] commandArgs) throws MailException {
        double money = 0.0;
        try {
            money = Double.parseDouble(commandArgs[0]);
        }
        catch (Exception e) {
            throw new MailException(Language.Phrases.ERROR_MAILTYPE_PAYMENT_NOTVALID.toString());
        }
        if (money <= 0.0) {
            throw new MailException(Language.Phrases.ERROR_MAILTYPE_PAYMENT_EMPTY.toString());
        }
        double balance = PostalService.economy.getBalance(sender.getName());
        if (!(balance >= money)) {
            throw new MailException(Language.Phrases.ERROR_MAILTYPE_PAYMENT_NOTENOUGH.toString());
        }
        PostalService.economy.withdrawPlayer(sender.getName(), money);
        return Double.toString(money);
    }

    @Override
    public void loadAttachments(String attachmentData) {
        block2: {
            try {
                this.amount = Double.parseDouble(attachmentData);
            }
            catch (Exception e) {
                if (!Config.ENABLE_DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    @Override
    public void administerAttachments(Player player) throws MailException {
        PostalService.economy.depositPlayer(player.getName(), this.amount);
    }

    @Override
    public String getAttachmentClaimMessage() {
        return Language.Phrases.ALERT_MAILTYPE_PAYMENT_CLAIM.toString();
    }

    @Override
    public String getAttachmentDescription() {
        return Language.Phrases.MAILTYPE_PAYMENT_ITEMDESC.toString().replace("%count%", Double.toString(this.amount));
    }

    @Override
    public boolean useSummaryScreen() {
        return false;
    }

    @Override
    public String getSummaryScreenTitle() {
        return null;
    }

    @Override
    public String getSummaryClaimButtonTitle() {
        return null;
    }

    @Override
    public ItemStack[] getSummaryIcons() {
        return null;
    }
}

