/*
 * Decompiled with CFR 0.152.
 */
package com.ebiggz.postalservice.mailbox;

import com.ebiggz.postalservice.PostalService;
import com.ebiggz.postalservice.backend.User;
import com.ebiggz.postalservice.backend.UserFactory;
import com.ebiggz.postalservice.config.Config;
import com.ebiggz.postalservice.config.WorldGroup;
import com.ebiggz.postalservice.events.PlayerRegisterMailboxEvent;
import com.ebiggz.postalservice.events.PlayerUnregisterAllMailboxesEvent;
import com.ebiggz.postalservice.events.PlayerUnregisterMailboxEvent;
import com.ebiggz.postalservice.exceptions.MailboxException;
import com.ebiggz.postalservice.mailbox.Mailbox;
import com.ebiggz.postalservice.permissions.PermissionHandler;
import com.ebiggz.postalservice.utils.ParticleEffect;
import com.ebiggz.postalservice.utils.Utils;
import java.sql.ResultSet;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class MailboxManager {
    public HashMap<Player, MailboxSelect> mailboxSelectors = new HashMap();
    private HashMap<Location, Mailbox> mailboxes = new HashMap();
    private static MailboxManager instance = null;

    protected MailboxManager() {
    }

    public static MailboxManager getInstance() {
        if (instance == null) {
            instance = new MailboxManager();
        }
        return instance;
    }

    public boolean locationHasMailbox(Location location) {
        Mailbox mb = this.getMailbox(location);
        return mb != null;
    }

    public void loadMailboxes() {
        block5: {
            this.mailboxes.clear();
            if (Config.USE_DATABASE) {
                try {
                    ResultSet rs = PostalService.getPSDatabase().querySQL("SELECT * FROM ps_mailboxes");
                    while (rs.next()) {
                        String location = rs.getString("Location");
                        Utils.debugMessage("Loading mailbox at locaiton: " + location);
                        String playerIdentifier = rs.getString("PlayerID");
                        if (location != null || playerIdentifier != null) {
                            Location loc = Utils.stringToLocation(location);
                            Utils.debugMessage("Converted location: " + loc.toString());
                            this.mailboxes.put(loc, new Mailbox(loc, playerIdentifier));
                            continue;
                        }
                        Utils.debugMessage("Could not load mailbox. Location or player id is null");
                    }
                }
                catch (Exception e) {
                    if (!Config.ENABLE_DEBUG) break block5;
                    e.printStackTrace();
                }
            }
        }
    }

    public Mailbox getMailbox(Location loc) {
        if (this.mailboxes.containsKey(loc)) {
            return this.mailboxes.get(loc);
        }
        return null;
    }

    public void addMailboxAtLoc(Location location, Player player) throws MailboxException {
        Utils.debugMessage("location to add for new mailbox: " + location.getWorld());
        User user = UserFactory.getUser(player.getName());
        if (location.getBlock() != null && location.getBlock().getType() != Material.CHEST) {
            throw new MailboxException(MailboxException.Reason.NOT_CHEST);
        }
        if (((Chest)location.getBlock().getState()).getInventory().getHolder() instanceof DoubleChest) {
            throw new MailboxException(MailboxException.Reason.DOUBLE_CHEST);
        }
        if (this.locationHasMailbox(location)) {
            throw new MailboxException(MailboxException.Reason.ALREADY_EXISTS);
        }
        if (!PermissionHandler.playerHasPermission(PermissionHandler.Perm.MAILBOX_SETOVERRIDE, (CommandSender)player, false) && !PermissionHandler.playerCanCreateMailboxAtLoc(location, player)) {
            throw new MailboxException(MailboxException.Reason.NO_PERMISSION);
        }
        if (this.getMailboxCount(player.getName(), Config.getWorldGroupFromWorld(location.getWorld().getName())) >= Config.getMailboxLimitForPlayer(player.getName())) {
            throw new MailboxException(MailboxException.Reason.MAX_REACHED);
        }
        PlayerRegisterMailboxEvent event = new PlayerRegisterMailboxEvent(player, location);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (!event.isCanceled() && Config.USE_DATABASE) {
            try {
                Utils.debugMessage("Adding mailbox to database for location: " + Utils.locationToString(location));
                PostalService.getPSDatabase().updateSQL("INSERT INTO ps_mailboxes VALUES (\"" + Utils.locationToString(location) + "\", \"" + user.getIdentifier() + "\")");
                this.mailboxes.put(location, new Mailbox(location, user.getIdentifier()));
            }
            catch (Exception e) {
                if (Config.ENABLE_DEBUG) {
                    e.printStackTrace();
                }
                Utils.debugMessage("error saving a mailbox for " + user.getPlayerName() + " at location " + Utils.locationToString(location));
                throw new MailboxException(MailboxException.Reason.UNKOWN);
            }
        }
    }

    public void removeMailboxAtLoc(Location location, Player player) throws MailboxException {
        block6: {
            Mailbox mb = this.getMailbox(location);
            if (mb == null) {
                throw new MailboxException(MailboxException.Reason.DOESNT_EXIST);
            }
            if (location.getBlock() != null && location.getBlock().getType() != Material.CHEST) {
                throw new MailboxException(MailboxException.Reason.NOT_CHEST);
            }
            if (!mb.getOwner().getPlayerName().equals(player.getName()) && !PermissionHandler.playerHasPermission(PermissionHandler.Perm.MAILBOX_REMOVEOTHER, (CommandSender)player, false)) {
                throw new MailboxException(MailboxException.Reason.NOT_OWNER);
            }
            PlayerUnregisterMailboxEvent event = new PlayerUnregisterMailboxEvent(player, mb);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            if (!event.isCanceled() && Config.USE_DATABASE) {
                try {
                    PostalService.getPSDatabase().updateSQL("DELETE FROM ps_mailboxes WHERE Location = \"" + Utils.locationToString(mb.getLocation()) + "\"");
                    this.mailboxes.remove(location);
                }
                catch (Exception e) {
                    if (!Config.ENABLE_DEBUG) break block6;
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean markNearbyMailboxes(Player player) {
        boolean found = false;
        for (Location mailboxLoc : this.mailboxes.keySet()) {
            if (mailboxLoc.getWorld() != player.getLocation().getWorld() || !(player.getLocation().distance(mailboxLoc) < 20.0)) continue;
            Location loc = mailboxLoc.clone();
            ParticleEffect effect = new ParticleEffect(ParticleEffect.ParticleType.VILLAGER_HAPPY, 0.0, 200, 0, 4, 0);
            loc.setX(loc.getX() + 0.5);
            loc.setZ(loc.getZ() + 0.5);
            loc.setY(loc.getY() + 10.0);
            effect.sendToLocation(loc, player);
            found = true;
        }
        return found;
    }

    public void removeAllMailboxes(Player commandSender, String owner) {
        User user = UserFactory.getUser(owner);
        PlayerUnregisterAllMailboxesEvent event = new PlayerUnregisterAllMailboxesEvent(commandSender, user);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (!event.isCanceled()) {
            block5: {
                if (Config.USE_DATABASE) {
                    try {
                        PostalService.getPSDatabase().updateSQL("DELETE FROM ps_mailboxes WHERE PlayerID = \"" + user.getIdentifier() + "\"");
                    }
                    catch (Exception e) {
                        if (!Config.ENABLE_DEBUG) break block5;
                        e.printStackTrace();
                    }
                }
            }
            for (Location mailboxLoc : this.mailboxes.keySet()) {
                Mailbox mailbox = this.mailboxes.get(mailboxLoc);
                if (!mailbox.getOwner().getPlayerName().equals(owner)) continue;
                this.mailboxes.remove(mailboxLoc);
            }
        }
    }

    public int getMailboxCount(String name, WorldGroup group) {
        Utils.debugMessage("Counting mailboxes for " + name);
        int count = 0;
        for (Mailbox mailbox : this.mailboxes.values()) {
            if (mailbox == null) {
                Utils.debugMessage("Found a null mailbox! Skipping...");
                continue;
            }
            Utils.debugMessage("Checking mailbox: " + mailbox.getLocation().toString());
            if (!mailbox.getOwner().getPlayerName().equals(name) || !Config.getWorldGroupFromWorld(mailbox.getLocation().getWorld()).getName().equals(group.getName())) continue;
            ++count;
        }
        return count;
    }

    public boolean mailboxIsNearby(Location location) {
        double distance = 6.0;
        for (Location mailboxLoc : this.mailboxes.keySet()) {
            if (!location.getWorld().equals(mailboxLoc.getWorld()) || !(location.distance(mailboxLoc) < distance)) continue;
            return true;
        }
        return false;
    }

    public Mailbox getNearestMailbox(Location location) {
        double distance = 6.0;
        Mailbox nearest = null;
        double nearestDist = distance;
        for (Mailbox mailbox : this.mailboxes.values()) {
            double nextDist;
            if (!location.getWorld().equals(mailbox.getLocation().getWorld()) || (nextDist = location.distance(mailbox.getLocation())) >= distance) continue;
            if (nearest == null) {
                nearest = mailbox;
                nearestDist = nextDist;
                continue;
            }
            if (!(nextDist < nearestDist)) continue;
            nearestDist = nextDist;
            nearest = mailbox;
        }
        return nearest;
    }

    public static enum MailboxSelect {
        SET,
        REMOVE;

    }
}

