/*
 * Decompiled with CFR 0.152.
 */
package com.ebiggz.postalservice.screens;

import com.ebiggz.postalservice.PostalService;
import com.ebiggz.postalservice.apis.InteractiveMessageAPI.FormattedText;
import com.ebiggz.postalservice.apis.InteractiveMessageAPI.InteractiveMessage;
import com.ebiggz.postalservice.apis.InteractiveMessageAPI.InteractiveMessageElement;
import com.ebiggz.postalservice.apis.guiAPI.GUI;
import com.ebiggz.postalservice.apis.guiAPI.GUIManager;
import com.ebiggz.postalservice.apis.guiAPI.GUIUtils;
import com.ebiggz.postalservice.backend.User;
import com.ebiggz.postalservice.backend.UserFactory;
import com.ebiggz.postalservice.config.Config;
import com.ebiggz.postalservice.config.Language;
import com.ebiggz.postalservice.mail.MailManager;
import com.ebiggz.postalservice.mail.MailType;
import com.ebiggz.postalservice.screens.MainMenuGUI;
import com.ebiggz.postalservice.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitScheduler;

public class DropboxGUI
implements GUI {
    private boolean contentsLoaded = false;

    @Override
    public ItemStack[] loadContents(Player player) {
        String[] wrappedMessage;
        Inventory inventory = Bukkit.createInventory(null, (int)45, (String)Language.Phrases.DROPBOX_TITLE.toString());
        User user = UserFactory.getUser(player.getName());
        List<ItemStack> dbItems = user.getDropbox(Config.getWorldGroupFromWorld(player.getWorld().getName()));
        if (dbItems != null) {
            for (ItemStack item : dbItems) {
                inventory.addItem(new ItemStack[]{item});
            }
        }
        ItemStack seperator = GUIUtils.createButton(Material.STONE_BUTTON, ChatColor.STRIKETHROUGH + "---", null);
        int i = 27;
        while (i < 36) {
            inventory.setItem(i, seperator);
            ++i;
        }
        ArrayList<String> lore = new ArrayList<String>();
        String[] stringArray = wrappedMessage = Utils.wrap(Language.Phrases.DROPBOX_HELP_TEXT.toString(), 30, "\n", true).split("\n");
        int n = wrappedMessage.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            lore.add(ChatColor.WHITE + line);
            ++n2;
        }
        ItemStack infoSign = GUIUtils.createButton(Material.SIGN, Language.Phrases.DROPBOX_HELP.toString(), lore);
        inventory.setItem(39, infoSign);
        ItemStack mainMenu = GUIUtils.createButton(Material.BOOK_AND_QUILL, Language.Phrases.BUTTON_COMPOSE_PACKAGE.toString(), Arrays.asList(Language.Phrases.CLICK_ACTION_COMPOSE.toString(), Language.Phrases.CLICK_ACTION_RIGHTRETURN.toString()));
        inventory.setItem(40, mainMenu);
        this.contentsLoaded = true;
        return inventory.getContents();
    }

    @Override
    public Inventory createBaseInventory(Player player) {
        Inventory inventory = Bukkit.createInventory(null, (int)45, (String)Language.Phrases.DROPBOX_TITLE.toString());
        ItemStack seperator = GUIUtils.createButton(Material.STONE_BUTTON, ChatColor.STRIKETHROUGH + "---", null);
        int i = 27;
        while (i < 36) {
            inventory.setItem(i, seperator);
            ++i;
        }
        ItemStack infoSign = GUIUtils.createButton(Material.SIGN, Language.Phrases.DROPBOX_HELP.toString(), Arrays.asList(Language.Phrases.BUTTON_LOADING.toString()));
        inventory.setItem(39, infoSign);
        ItemStack mainMenu = GUIUtils.createButton(Material.BOOK_AND_QUILL, Language.Phrases.BUTTON_COMPOSE_PACKAGE.toString(), Arrays.asList(Language.Phrases.CLICK_ACTION_COMPOSE.toString(), Language.Phrases.CLICK_ACTION_RIGHTRETURN.toString()));
        inventory.setItem(40, mainMenu);
        return inventory;
    }

    @Override
    public void onInventoryClick(Player whoClicked, InventoryClickEvent clickedEvent) {
        if (!this.contentsLoaded) {
            clickedEvent.setCancelled(true);
            return;
        }
        ItemStack clickedItem = clickedEvent.getCurrentItem();
        if (clickedEvent.getSlot() < 27) {
            clickedEvent.setCancelled(false);
        } else if (clickedEvent.getSlot() == 40 && clickedItem != null && clickedItem.getType() != Material.AIR) {
            if (clickedEvent.getClick() == ClickType.RIGHT) {
                GUIManager.getInstance().showGUI(new MainMenuGUI(UserFactory.getUser(whoClicked)), whoClicked);
            } else {
                whoClicked.closeInventory();
                MailType type = MailManager.getInstance().getMailTypeByIdentifier("package");
                InteractiveMessage im = new InteractiveMessage();
                im.addElement(String.valueOf(Language.Phrases.COMPOSE_TEXT.toPrefixedString()) + ": ");
                InteractiveMessageElement ime = new InteractiveMessageElement(new FormattedText(ChatColor.stripColor((String)type.getDisplayName()), ChatColor.AQUA), InteractiveMessageElement.HoverEvent.SHOW_TEXT, new FormattedText(ChatColor.stripColor((String)type.getHoveroverDescription()), ChatColor.GOLD), InteractiveMessageElement.ClickEvent.SUGGEST_COMMAND, "/" + Language.Phrases.COMMAND_MAIL.toString() + " " + type.getDisplayName().toLowerCase() + " " + Language.Phrases.COMMAND_ARG_TO.toString() + ": " + Language.Phrases.COMMAND_ARG_MESSAGE.toString() + ":");
                im.addElement(ime);
                im.sendTo(whoClicked);
            }
        }
    }

    @Override
    public void onInventoryClose(Player whoClosed, InventoryCloseEvent closeEvent) {
        BukkitScheduler scheduler = Bukkit.getServer().getScheduler();
        scheduler.runTaskAsynchronously(PostalService.getPlugin(), new Runnable(){
            private Player whoClosed;
            private InventoryCloseEvent closeEvent;

            @Override
            public void run() {
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                int i = 0;
                while (i < 26) {
                    ItemStack item = this.closeEvent.getInventory().getItem(i);
                    if (item != null && item.getType() != Material.AIR) {
                        items.add(item);
                    }
                    ++i;
                }
                UserFactory.getUser(this.whoClosed).saveDropbox(items, Config.getWorldGroupFromWorld(this.whoClosed.getWorld().getName()));
            }

            public Runnable init(Player whoClosed, InventoryCloseEvent closeEvent) {
                this.whoClosed = whoClosed;
                this.closeEvent = closeEvent;
                return this;
            }
        }.init(whoClosed, closeEvent));
    }

    @Override
    public boolean ignoreForeignItems() {
        return true;
    }
}

