/*
 * Decompiled with CFR 0.152.
 */
package com.ebiggz.postalservice.screens;

import com.ebiggz.postalservice.PostalService;
import com.ebiggz.postalservice.apis.guiAPI.GUI;
import com.ebiggz.postalservice.apis.guiAPI.GUIManager;
import com.ebiggz.postalservice.apis.guiAPI.GUIUtils;
import com.ebiggz.postalservice.backend.User;
import com.ebiggz.postalservice.config.Config;
import com.ebiggz.postalservice.config.Language;
import com.ebiggz.postalservice.exceptions.MailException;
import com.ebiggz.postalservice.mail.Mail;
import com.ebiggz.postalservice.mail.MailManager;
import com.ebiggz.postalservice.screens.MainMenuGUI;
import com.ebiggz.postalservice.screens.SummaryScreenGUI;
import com.ebiggz.postalservice.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class InboxTypeGUI
implements GUI {
    private MailManager.BoxType boxType;
    private User accountOwner;
    private int pageNumber;
    private int totalPages = 1;
    private List<Mail> mails;

    public InboxTypeGUI(User accountOwner, MailManager.BoxType type, int pageNumber) {
        this.boxType = type;
        this.pageNumber = pageNumber;
        this.accountOwner = accountOwner;
    }

    public InboxTypeGUI(User accountOwner, MailManager.BoxType type, int pageNumber, int totalPages) {
        this.boxType = type;
        this.pageNumber = pageNumber;
        this.accountOwner = accountOwner;
        this.totalPages = totalPages;
    }

    public MailManager.BoxType getType() {
        return this.boxType;
    }

    @Override
    public ItemStack[] loadContents(Player player) {
        if (this.mails == null) {
            this.mails = this.accountOwner.getBoxFromType(this.boxType);
        }
        String boxTypeStr = this.boxType == MailManager.BoxType.INBOX ? Language.Phrases.BUTTON_INBOX.toString() : Language.Phrases.BUTTON_SENT.toString();
        Inventory inventory = Bukkit.createInventory(null, (int)45, (String)ChatColor.stripColor((String)boxTypeStr));
        int boxSize = this.mails.size();
        this.totalPages = (int)Math.ceil((double)boxSize / 27.0);
        if (this.totalPages == 0) {
            this.totalPages = 1;
        }
        if (this.pageNumber > this.totalPages) {
            this.pageNumber = this.totalPages;
        }
        int mailIndex = 0 + 27 * (this.pageNumber - 1);
        int invIndex = 0;
        while (mailIndex < 27 * this.pageNumber && mailIndex < boxSize) {
            inventory.setItem(invIndex, this.createMailButton(this.mails.get(mailIndex), player));
            ++mailIndex;
            ++invIndex;
        }
        ItemStack seperator = GUIUtils.createButton(Material.STONE_BUTTON, ChatColor.STRIKETHROUGH + "---", null);
        int i = 27;
        while (i < 36) {
            inventory.setItem(i, seperator);
            ++i;
        }
        ItemStack mainMenu = GUIUtils.createButton(Material.BOOK_AND_QUILL, Language.Phrases.BUTTON_MAINMENU.toString(), Arrays.asList(Language.Phrases.CLICK_ACTION_LEFTRETURN.toString()));
        inventory.setItem(40, mainMenu);
        this.totalPages = (int)Math.ceil((double)boxSize / 27.0);
        if (this.totalPages > 1) {
            if (this.pageNumber + 1 <= this.totalPages) {
                ItemStack next = GUIUtils.createButton(Material.IRON_PLATE, ChatColor.GOLD + Language.Phrases.BUTTON_NEXT.toString(), Arrays.asList(Language.Phrases.CLICK_ACTION_NEXTPAGE.toString()));
                inventory.setItem(41, next);
            }
            if (this.pageNumber - 1 >= 1) {
                ItemStack previous = GUIUtils.createButton(Material.IRON_PLATE, Language.Phrases.BUTTON_PREVIOUS.toString(), Arrays.asList(Language.Phrases.CLICK_ACTION_PREVIOUSPAGE.toString()));
                inventory.setItem(39, previous);
            }
        }
        GUIManager.getInstance().setGUIInv(this, Arrays.asList(inventory.getContents()));
        return inventory.getContents();
    }

    @Override
    public Inventory createBaseInventory(Player player) {
        String boxTypeStr = this.boxType == MailManager.BoxType.INBOX ? Language.Phrases.BUTTON_INBOX.toString() : Language.Phrases.BUTTON_SENT.toString();
        Inventory inventory = Bukkit.createInventory(null, (int)45, (String)ChatColor.stripColor((String)boxTypeStr));
        ItemStack seperator = GUIUtils.createButton(Material.STONE_BUTTON, ChatColor.STRIKETHROUGH + "---", null);
        int i = 27;
        while (i < 36) {
            inventory.setItem(i, seperator);
            ++i;
        }
        ItemStack mainMenu = GUIUtils.createButton(Material.BOOK_AND_QUILL, Language.Phrases.BUTTON_MAINMENU.toString(), Arrays.asList(Language.Phrases.CLICK_ACTION_LEFTRETURN.toString()));
        inventory.setItem(40, mainMenu);
        if (this.totalPages > 1) {
            if (this.pageNumber + 1 <= this.totalPages) {
                ItemStack next = GUIUtils.createButton(Material.IRON_PLATE, ChatColor.GOLD + Language.Phrases.BUTTON_NEXT.toString(), Arrays.asList(Language.Phrases.CLICK_ACTION_NEXTPAGE.toString()));
                inventory.setItem(41, next);
            }
            if (this.pageNumber - 1 >= 1) {
                ItemStack previous = GUIUtils.createButton(Material.IRON_PLATE, Language.Phrases.BUTTON_PREVIOUS.toString(), Arrays.asList(Language.Phrases.CLICK_ACTION_PREVIOUSPAGE.toString()));
                inventory.setItem(39, previous);
            }
        }
        GUIManager.getInstance().setGUIInv(this, Arrays.asList(inventory.getContents()));
        return inventory;
    }

    @Override
    public void onInventoryClick(Player whoClicked, InventoryClickEvent clickedEvent) {
        ItemStack clickedItem = clickedEvent.getCurrentItem();
        int clickedSlot = clickedEvent.getSlot();
        switch (clickedSlot) {
            case 39: {
                if (clickedItem == null || clickedItem.getType() == Material.AIR) break;
                --this.pageNumber;
                clickedEvent.getInventory().setContents(this.loadContents(whoClicked));
                break;
            }
            case 40: {
                if (clickedItem == null || clickedItem.getType() == Material.AIR) break;
                GUIManager.getInstance().showGUI(new MainMenuGUI(this.accountOwner), whoClicked);
                break;
            }
            case 41: {
                if (clickedItem == null || clickedItem.getType() == Material.AIR) break;
                ++this.pageNumber;
                clickedEvent.getInventory().setContents(this.loadContents(whoClicked));
                break;
            }
            default: {
                if (clickedSlot >= 27 || clickedItem == null || clickedItem.getType() == Material.AIR || !this.accountOwner.getPlayerName().equals(whoClicked.getName())) break;
                int mailIndex = clickedSlot + 27 * (this.pageNumber - 1);
                if (this.mails.size() < mailIndex + 1) {
                    whoClicked.closeInventory();
                    whoClicked.sendMessage(Language.Phrases.ERROR_INBOX.toPrefixedString());
                    PostalService.getPlugin().getLogger().warning(String.valueOf(whoClicked.getName()) + " clicked on a " + clickedItem.getType().toString() + " which index (" + mailIndex + ") doesnt exist in their " + this.boxType.toString() + " mail array!");
                    return;
                }
                Mail mail = this.mails.get(mailIndex);
                if (clickedEvent.getClick() == ClickType.LEFT) {
                    if (this.boxType != MailManager.BoxType.INBOX) break;
                    whoClicked.closeInventory();
                    whoClicked.sendMessage(this.getReplySummaryString(mail));
                    Utils.getComposeMessage(true, whoClicked).sendTo(whoClicked);
                    break;
                }
                if (clickedEvent.getClick() == ClickType.RIGHT) {
                    if (this.boxType != MailManager.BoxType.INBOX || !mail.hasAttachments() || mail.isClaimed() || mail.getWorldGroup() != Config.getWorldGroupFromWorld(whoClicked.getWorld()) && !mail.getWorldGroup().getName().equalsIgnoreCase("none") && !Config.getMailTypesThatIgnoreWorldGroups().contains(mail.getType().getDisplayName())) break;
                    if (mail.getType().useSummaryScreen()) {
                        GUIManager.getInstance().showGUI(new SummaryScreenGUI(mail, this.boxType, this.pageNumber), whoClicked);
                        break;
                    }
                    try {
                        mail.getType().administerAttachments(whoClicked);
                        this.accountOwner.markMailAsClaimed(mail);
                        whoClicked.sendMessage((Object)((Object)Language.Phrases.PREFIX) + " " + mail.getType().getAttachmentClaimMessage());
                        whoClicked.closeInventory();
                    }
                    catch (MailException e) {
                        whoClicked.closeInventory();
                        whoClicked.sendMessage(String.valueOf(Language.Phrases.PREFIX.toString()) + " " + e.getMessage());
                    }
                    break;
                }
                if (clickedEvent.getClick() != ClickType.SHIFT_RIGHT || this.boxType != MailManager.BoxType.SENT && mail.hasAttachments() && !mail.isClaimed()) break;
                this.accountOwner.markMailAsDeleted(mail, this.boxType);
                this.mails.remove(mail);
                clickedEvent.getInventory().setContents(this.loadContents(whoClicked));
            }
        }
    }

    @Override
    public void onInventoryClose(Player whoClosed, InventoryCloseEvent closeEvent) {
    }

    private String getReplySummaryString(Mail mail) {
        if (!mail.getMessage().isEmpty()) {
            return Language.Phrases.REPLY_SUMMARY_MESSAGE.toPrefixedString().replace("%sender%", mail.getSender()).replace("%mailtype%", mail.getType().getDisplayName()).replace("%timestamp%", mail.getTimeString(this.accountOwner.getTimeZone())).replace("%message%", mail.getMessage());
        }
        return Language.Phrases.REPLY_SUMMARY_NOMESSAGE.toPrefixedString().replace("%sender%", mail.getSender()).replace("%mailtype%", mail.getType().getDisplayName()).replace("%timestamp%", mail.getTimeString(this.accountOwner.getTimeZone()));
    }

    private ItemStack createMailButton(Mail mail, Player viewingPlayer) {
        ItemStack button = new ItemStack(mail.getType().getIcon());
        ArrayList<String> lore = new ArrayList<String>();
        String info = "";
        if (mail.hasAttachments()) {
            if (this.boxType == MailManager.BoxType.INBOX && mail.isClaimed()) {
                info = ChatColor.GRAY + "*" + ChatColor.stripColor((String)Language.Phrases.CLAIMED.toString()) + "*";
            } else if (mail.getType().getAttachmentDescription() != null && !mail.getType().getAttachmentDescription().isEmpty()) {
                info = ChatColor.WHITE + ChatColor.stripColor((String)mail.getType().getAttachmentDescription());
            }
        }
        if (!info.isEmpty()) {
            lore.add(info);
        }
        ItemMeta im = button.getItemMeta();
        String name = ChatColor.GOLD + ChatColor.BOLD + mail.getType().getDisplayName();
        im.setDisplayName(name);
        lore.add(ChatColor.GRAY + ChatColor.STRIKETHROUGH + "-----------");
        if (!mail.getMessage().trim().isEmpty()) {
            String[] wrappedMessage;
            String[] stringArray = wrappedMessage = Utils.wrap(mail.getMessage(), 30, "\n", true).split("\n");
            int n = wrappedMessage.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                lore.add(ChatColor.YELLOW + line);
                ++n2;
            }
        }
        lore.add(this.boxType.equals((Object)MailManager.BoxType.INBOX) ? ChatColor.GRAY + "  " + Language.Phrases.MAIL_ICON_FROM.toString() + " " + ChatColor.WHITE + mail.getSender() : ChatColor.GRAY + "  " + Language.Phrases.MAIL_ICON_TO.toString() + " " + ChatColor.WHITE + mail.getRecipient());
        lore.add("  " + ChatColor.GRAY + mail.getTimeString(this.accountOwner.getTimeZone()));
        lore.add(ChatColor.GRAY + ChatColor.STRIKETHROUGH + "-----------");
        if (this.accountOwner.getPlayerName().equals(viewingPlayer.getName())) {
            if (this.boxType.equals((Object)MailManager.BoxType.INBOX)) {
                lore.add(Language.Phrases.CLICK_ACTION_RESPOND.toString());
                if (mail.hasAttachments() && !mail.isClaimed()) {
                    if (mail.getWorldGroup() == Config.getWorldGroupFromWorld(viewingPlayer.getWorld()) || mail.getWorldGroup().getName().equalsIgnoreCase("none") || Config.getMailTypesThatIgnoreWorldGroups().contains(mail.getType().getDisplayName())) {
                        lore.add(Language.Phrases.CLICK_ACTION_RIGHTCLAIM.toString());
                    } else {
                        lore.add(Language.Phrases.MAIL_ICON_CLAIMWORLDGROUP.toString().replace("%worldgroup%", mail.getWorldGroup().getName()));
                    }
                }
            }
            if (this.boxType == MailManager.BoxType.SENT || !mail.hasAttachments() || mail.isClaimed()) {
                lore.add(Language.Phrases.CLICK_ACTION_DELETE.toString());
            }
        }
        im.setLore(lore);
        button.setItemMeta(im);
        return button;
    }

    @Override
    public boolean ignoreForeignItems() {
        return false;
    }
}

