/*
 * Decompiled with CFR 0.152.
 */
package com.ebiggz.postalservice.screens;

import com.ebiggz.postalservice.apis.guiAPI.GUI;
import com.ebiggz.postalservice.apis.guiAPI.GUIManager;
import com.ebiggz.postalservice.apis.guiAPI.GUIUtils;
import com.ebiggz.postalservice.backend.User;
import com.ebiggz.postalservice.config.Config;
import com.ebiggz.postalservice.config.Language;
import com.ebiggz.postalservice.mail.MailManager;
import com.ebiggz.postalservice.mailbox.MailboxManager;
import com.ebiggz.postalservice.permissions.PermissionHandler;
import com.ebiggz.postalservice.screens.DropboxGUI;
import com.ebiggz.postalservice.screens.InboxTypeGUI;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;

public class MainMenuGUI
implements GUI {
    private User accountOwner;

    public MainMenuGUI(User accountOwner) {
        this.accountOwner = accountOwner;
    }

    @Override
    public ItemStack[] loadContents(Player viewingPlayer) {
        int unread = this.accountOwner.getUnreadMailCount();
        int inboxSize = this.accountOwner.getBoxSizeFromType(MailManager.BoxType.INBOX);
        int percent = Math.round((float)inboxSize / (float)Config.getMaxInboxSizeForPlayer(this.accountOwner.getPlayerName()) * 100.0f);
        Inventory inventory = Bukkit.createInventory(null, (InventoryType)InventoryType.HOPPER, (String)Language.Phrases.MAINMENU_TITLE.toString());
        ItemStack infoSign = GUIUtils.createButton(Material.SIGN, Language.Phrases.BUTTON_ACCOUNTINFO.toString(), Config.ENABLE_MAILBOXES ? Arrays.asList(ChatColor.GRAY + Language.Phrases.ACCOUNT_INFO_MAILBOXES.toString() + ": " + ChatColor.WHITE + MailboxManager.getInstance().getMailboxCount(this.accountOwner.getPlayerName(), Config.getWorldGroupFromWorld(viewingPlayer.getWorld())) + "/" + Config.getMailboxLimitForPlayer(this.accountOwner.getPlayerName()), ChatColor.GRAY + Language.Phrases.ACCOUNT_INFO_INBOXSIZE.toString() + ": " + ChatColor.WHITE + inboxSize + "/" + Config.getMaxInboxSizeForPlayer(this.accountOwner.getPlayerName()), Language.Phrases.CLICK_ACTION_HELP.toString()) : Arrays.asList(ChatColor.GRAY + Language.Phrases.ACCOUNT_INFO_INBOXSIZE.toString() + ": " + ChatColor.WHITE + inboxSize + "/" + Config.getMaxInboxSizeForPlayer(this.accountOwner.getPlayerName()), Language.Phrases.CLICK_ACTION_HELP.toString()));
        ItemStack composeBook = GUIUtils.createButton(Material.BOOK_AND_QUILL, Language.Phrases.BUTTON_COMPOSE.toString(), this.accountOwner.getPlayerName().equals(viewingPlayer.getName()) ? (Config.packagesAreEnabled() ? Arrays.asList(Language.Phrases.CLICK_ACTION_COMPOSE.toString(), Language.Phrases.CLICK_ACTION_DROPBOX.toString(), Language.Phrases.DROPBOX_DESCRIPTION.toString()) : Arrays.asList(Language.Phrases.CLICK_ACTION_COMPOSE.toString())) : Arrays.asList(""));
        ItemStack inboxChest = GUIUtils.createButton(Material.CHEST, Language.Phrases.BUTTON_INBOX.toString(), Arrays.asList(ChatColor.WHITE + Language.Phrases.BUTTON_INBOX_UNREAD.toString().replace("%count%", Integer.toString(unread)), Language.Phrases.INBOX_PERCENT_FULL.toString().replace("%percent%", Integer.toString(percent)), Language.Phrases.CLICK_ACTION_OPEN.toString()));
        ItemStack sentEnderchest = GUIUtils.createButton(Material.ENDER_CHEST, Language.Phrases.BUTTON_SENT.toString(), Arrays.asList(Language.Phrases.CLICK_ACTION_OPEN.toString()));
        ItemStack tradingPost = GUIUtils.createButton(Material.FENCE, Language.Phrases.BUTTON_TRADINGPOST.toString(), Arrays.asList(ChatColor.GRAY + "*Coming Soon*"));
        inventory.setItem(0, infoSign);
        inventory.setItem(1, composeBook);
        inventory.setItem(2, inboxChest);
        inventory.setItem(3, sentEnderchest);
        inventory.setItem(4, tradingPost);
        return inventory.getContents();
    }

    @Override
    public Inventory createBaseInventory(Player viewingPlayer) {
        Inventory inventory = Bukkit.createInventory(null, (InventoryType)InventoryType.HOPPER, (String)Language.Phrases.MAINMENU_TITLE.toString());
        ItemStack infoSign = GUIUtils.createButton(Material.SIGN, Language.Phrases.BUTTON_ACCOUNTINFO.toString(), Arrays.asList(Language.Phrases.BUTTON_LOADING.toString()));
        ItemStack composeBook = GUIUtils.createButton(Material.BOOK_AND_QUILL, Language.Phrases.BUTTON_COMPOSE.toString(), Arrays.asList(Language.Phrases.BUTTON_LOADING.toString()));
        ItemStack inboxChest = GUIUtils.createButton(Material.CHEST, Language.Phrases.BUTTON_INBOX.toString(), Arrays.asList(Language.Phrases.BUTTON_LOADING.toString()));
        ItemStack sentEnderchest = GUIUtils.createButton(Material.ENDER_CHEST, Language.Phrases.BUTTON_SENT.toString(), Arrays.asList(Language.Phrases.BUTTON_LOADING.toString()));
        ItemStack tradingPost = GUIUtils.createButton(Material.FENCE, Language.Phrases.BUTTON_TRADINGPOST.toString(), Arrays.asList(Language.Phrases.BUTTON_LOADING.toString()));
        inventory.setItem(0, infoSign);
        inventory.setItem(1, composeBook);
        inventory.setItem(2, inboxChest);
        inventory.setItem(3, sentEnderchest);
        inventory.setItem(4, tradingPost);
        return inventory;
    }

    @Override
    public void onInventoryClick(Player whoClicked, InventoryClickEvent clickedEvent) {
        if (!whoClicked.getName().equals(this.accountOwner.getPlayerName()) && !PermissionHandler.playerHasPermission(PermissionHandler.Perm.MAIL_READOTHER, (CommandSender)whoClicked, true)) {
            whoClicked.closeInventory();
            return;
        }
        int slot = clickedEvent.getSlot();
        switch (slot) {
            case 0: {
                if (clickedEvent.getClick() != ClickType.LEFT) break;
                whoClicked.closeInventory();
                whoClicked.performCommand(String.valueOf(Language.Phrases.COMMAND_MAIL.toString()) + " " + Language.Phrases.COMMAND_ARG_HELP.toString());
                break;
            }
            case 1: {
                if (!this.accountOwner.getPlayerName().equals(whoClicked.getName())) break;
                if (clickedEvent.getClick() == ClickType.LEFT) {
                    BookMeta bm;
                    if (clickedEvent.getCursor() != null && clickedEvent.getCursor().getType() == Material.BOOK_AND_QUILL && (bm = (BookMeta)clickedEvent.getCursor().getItemMeta()).hasPages()) {
                        String pageData = bm.getPage(1).replaceAll(System.getProperty("line.separator"), "");
                        String regex = Language.getToRegex();
                        Matcher matcher = Pattern.compile(regex).matcher(pageData);
                        if (matcher.find()) {
                            String[] split = matcher.group().split(":");
                            String to = split[1].trim();
                            String message = pageData.replace(matcher.group(), "");
                            whoClicked.performCommand(String.valueOf(Language.Phrases.COMMAND_MAIL.toString()) + " " + Language.Phrases.MAILTYPE_LETTER.toString() + " " + (Object)((Object)Language.Phrases.COMMAND_ARG_TO) + ":" + to + " " + Language.Phrases.COMMAND_ARG_MESSAGE.toString() + ":" + message.trim());
                            MailManager.getInstance().willDropBook.add(whoClicked);
                            whoClicked.closeInventory();
                            break;
                        }
                    }
                    whoClicked.closeInventory();
                    whoClicked.performCommand(String.valueOf(Language.Phrases.COMMAND_MAIL.toString()) + " " + Language.Phrases.COMMAND_ARG_COMPOSE.toString());
                    break;
                }
                if (clickedEvent.getClick() != ClickType.RIGHT || !Config.packagesAreEnabled()) break;
                GUIManager.getInstance().showGUI(new DropboxGUI(), whoClicked);
                break;
            }
            case 2: {
                if (this.accountOwner.getPlayerName().equals(whoClicked.getName())) {
                    this.accountOwner.markAllMailAsRead();
                }
                GUIManager.getInstance().showGUI(new InboxTypeGUI(this.accountOwner, MailManager.BoxType.INBOX, 1), whoClicked);
                break;
            }
            case 3: {
                GUIManager.getInstance().showGUI(new InboxTypeGUI(this.accountOwner, MailManager.BoxType.SENT, 1), whoClicked);
                break;
            }
        }
    }

    @Override
    public void onInventoryClose(Player whoClosed, InventoryCloseEvent closeEvent) {
    }

    @Override
    public boolean ignoreForeignItems() {
        return false;
    }
}

