/*
 * Decompiled with CFR 0.152.
 */
package com.ebiggz.postalservice.screens;

import com.ebiggz.postalservice.apis.guiAPI.GUI;
import com.ebiggz.postalservice.apis.guiAPI.GUIManager;
import com.ebiggz.postalservice.apis.guiAPI.GUIUtils;
import com.ebiggz.postalservice.backend.UserFactory;
import com.ebiggz.postalservice.config.Language;
import com.ebiggz.postalservice.exceptions.MailException;
import com.ebiggz.postalservice.mail.Mail;
import com.ebiggz.postalservice.mail.MailManager;
import com.ebiggz.postalservice.screens.InboxTypeGUI;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class SummaryScreenGUI
implements GUI {
    private Mail mail;
    private MailManager.BoxType previous;
    private int prevPage;
    private ItemStack[] contents;

    public SummaryScreenGUI(Mail mail, MailManager.BoxType previous, int prevPage) {
        this.mail = mail;
        this.previous = previous;
        this.prevPage = prevPage;
    }

    @Override
    public ItemStack[] loadContents(Player player) {
        return this.contents;
    }

    @Override
    public Inventory createBaseInventory(Player player) {
        Inventory inventory = Bukkit.createInventory(null, (int)45, (String)this.mail.getType().getSummaryScreenTitle());
        ItemStack[] itemStackArray = this.mail.getType().getSummaryIcons();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack item = itemStackArray[n2];
            inventory.addItem(new ItemStack[]{item});
            ++n2;
        }
        ItemStack seperator = GUIUtils.createButton(Material.STONE_BUTTON, ChatColor.STRIKETHROUGH + "---", null);
        int i = 27;
        while (i < 36) {
            inventory.setItem(i, seperator);
            ++i;
        }
        if (this.previous == MailManager.BoxType.INBOX) {
            ItemStack claim = GUIUtils.createButton(this.mail.getType().getIcon(), this.mail.getType().getSummaryClaimButtonTitle(), Arrays.asList(Language.Phrases.CLICK_ACTION_LEFTCLAIM.toString(), Language.Phrases.CLICK_ACTION_RIGHTRETURN.toString()));
            inventory.setItem(40, claim);
        } else {
            ItemStack mainMenu = GUIUtils.createButton(Material.CHEST, Language.Phrases.BUTTON_MAINMENU.toString(), Arrays.asList(Language.Phrases.CLICK_ACTION_LEFTRETURN.toString()));
            inventory.setItem(40, mainMenu);
        }
        this.contents = inventory.getContents();
        return inventory;
    }

    @Override
    public void onInventoryClick(Player whoClicked, InventoryClickEvent clickedEvent) {
        if (clickedEvent.getSlot() == 40) {
            if (clickedEvent.getClick() == ClickType.LEFT) {
                try {
                    this.mail.getType().administerAttachments(whoClicked);
                    UserFactory.getUser(whoClicked.getName()).markMailAsClaimed(this.mail);
                    whoClicked.sendMessage(String.valueOf(Language.Phrases.PREFIX.toString()) + " " + this.mail.getType().getAttachmentClaimMessage());
                    whoClicked.closeInventory();
                }
                catch (MailException e) {
                    whoClicked.sendMessage((Object)((Object)Language.Phrases.PREFIX) + " " + e.getErrorMessage());
                    whoClicked.closeInventory();
                }
            } else {
                GUIManager.getInstance().showGUI(new InboxTypeGUI(UserFactory.getUser(whoClicked.getName()), this.previous, this.prevPage), whoClicked);
            }
        }
    }

    @Override
    public void onInventoryClose(Player whoClosed, InventoryCloseEvent closeEvent) {
    }

    @Override
    public boolean ignoreForeignItems() {
        return false;
    }
}

