/*
 * Decompiled with CFR 0.152.
 */
package com.ebiggz.postalservice.tradingpost;

import com.ebiggz.postalservice.apis.guiAPI.GUIButton;
import java.util.Arrays;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class AcceptOfferButton
extends GUIButton {
    private boolean isAccepted = false;
    private boolean isWaiting = true;
    private String playerName;
    private String otherPlayer;
    private ItemStack unaccepted = new ItemStack(Material.getMaterial((int)160), 1, 0);
    private ItemStack accepted = new ItemStack(Material.getMaterial((int)160), 1, 5);

    public AcceptOfferButton(String playerName, String otherPlayer) {
        super(new ItemStack(Material.getMaterial((int)160), 1, 0), ChatColor.YELLOW + ChatColor.BOLD + playerName + " Accept Offer Button", Arrays.asList(ChatColor.WHITE + "Current Status: " + ChatColor.GOLD + "Can't accept", ChatColor.GRAY + "(Waiting for " + otherPlayer + " to", ChatColor.GRAY + "lock in their offer)"));
        this.playerName = playerName;
        this.otherPlayer = otherPlayer;
    }

    public void setAccept(boolean shouldAccept) {
        this.isAccepted = shouldAccept;
        if (shouldAccept) {
            this.setBaseIcon(this.accepted);
            this.setLore(Arrays.asList(ChatColor.WHITE + "Current Status: " + ChatColor.GOLD + "Accepted", ChatColor.GRAY + "* " + this.playerName + ", click this to", ChatColor.GRAY + "unaccept " + this.otherPlayer + "'s offer *"));
        } else {
            this.setBaseIcon(this.unaccepted);
            if (this.isWaiting) {
                this.setLore(Arrays.asList(ChatColor.WHITE + "Current Status: " + ChatColor.GOLD + "Can't accept", ChatColor.GRAY + "(Waiting for " + this.otherPlayer + " to", ChatColor.GRAY + "lock in their offer)"));
            } else {
                this.setLore(Arrays.asList(ChatColor.WHITE + "Current Status: " + ChatColor.GOLD + "Not accepted", ChatColor.GRAY + "* " + this.playerName + ", click this to", ChatColor.GRAY + "accept " + this.otherPlayer + "'s offer *"));
            }
        }
    }

    public boolean isAccepted() {
        return this.isAccepted;
    }

    public boolean isWaiting() {
        return this.isWaiting;
    }

    public void setWaiting(boolean isWaiting) {
        this.isWaiting = isWaiting;
        if (this.isAccepted) {
            return;
        }
        if (isWaiting) {
            this.setLore(Arrays.asList(ChatColor.WHITE + "Current Status: " + ChatColor.GOLD + "Can't accept", ChatColor.GRAY + "(Waiting for " + this.otherPlayer + " to", ChatColor.GRAY + "lock in their offer)"));
        } else {
            this.setLore(Arrays.asList(ChatColor.WHITE + "Current Status: " + ChatColor.GOLD + "Not accepted", ChatColor.GRAY + "* " + this.playerName + ", click this to", ChatColor.GRAY + "accept " + this.otherPlayer + "'s offer *"));
        }
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public String getOtherPlayer() {
        return this.otherPlayer;
    }
}

