/*
 * Decompiled with CFR 0.152.
 */
package com.ebiggz.postalservice.utils;

import com.ebiggz.postalservice.apis.InteractiveMessageAPI.FormattedText;
import com.ebiggz.postalservice.apis.InteractiveMessageAPI.InteractiveMessage;
import com.ebiggz.postalservice.apis.InteractiveMessageAPI.InteractiveMessageElement;
import com.ebiggz.postalservice.config.Language;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class FancyMenu {
    private List<InteractiveMessage> commands = new ArrayList<InteractiveMessage>();
    private String commandLabel;
    private String header;
    private InteractiveMessageElement previous;
    private InteractiveMessageElement next;

    public FancyMenu(String header, String commandLabel) {
        this.commandLabel = commandLabel;
        this.header = header;
        this.previous = new InteractiveMessageElement(new FormattedText(Language.Phrases.HELPMENU_PREVIOUS_BUTTON.toString(), ChatColor.YELLOW), InteractiveMessageElement.HoverEvent.SHOW_TEXT, new FormattedText(Language.Phrases.HELPMENU_PREVIOUS_DESC.toString()), InteractiveMessageElement.ClickEvent.RUN_COMMAND, "");
        this.next = new InteractiveMessageElement(new FormattedText(Language.Phrases.HELPMENU_NEXT_BUTTON.toString(), ChatColor.YELLOW), InteractiveMessageElement.HoverEvent.SHOW_TEXT, new FormattedText(Language.Phrases.HELPMENU_NEXT_DESC.toString()), InteractiveMessageElement.ClickEvent.RUN_COMMAND, "");
    }

    public void addCommand(String text, String hoverText, InteractiveMessageElement.ClickEvent clickAction, String command) {
        InteractiveMessage newCmd = new InteractiveMessage();
        if (command == null || command.isEmpty()) {
            command = text;
        }
        newCmd.addElement(new InteractiveMessageElement(new FormattedText(text, ChatColor.GREEN), hoverText != null ? InteractiveMessageElement.HoverEvent.SHOW_TEXT : InteractiveMessageElement.HoverEvent.NONE, new FormattedText(hoverText), clickAction, command));
        this.commands.add(newCmd);
    }

    public void addText(String text) {
        this.commands.add(new InteractiveMessage().addElement(text));
    }

    public int getTotalPages() {
        return (int)Math.ceil((double)this.commands.size() / 7.0);
    }

    public void sendPage(int pageNumber, CommandSender sender) {
        int totalPages = this.getTotalPages();
        if (pageNumber > totalPages) {
            sender.sendMessage(Language.Phrases.ERROR_INVALID_NUMBER.toPrefixedString());
            return;
        }
        sender.sendMessage(ChatColor.GOLD + ChatColor.STRIKETHROUGH + "-----" + ChatColor.GOLD + "[" + ChatColor.YELLOW + this.header + ChatColor.GOLD + " | " + ChatColor.YELLOW + Language.Phrases.HELPMENU_PAGE.toString() + " " + pageNumber + "/" + totalPages + ChatColor.GOLD + "]");
        int count = 0 + 7 * (pageNumber - 1);
        while (count < 7 * pageNumber && count < this.commands.size()) {
            InteractiveMessage command = this.commands.get(count);
            command.sendTo(sender);
            ++count;
        }
        if (totalPages <= 1) {
            return;
        }
        this.next.setCommand("/" + this.commandLabel + " " + Integer.toString(pageNumber + 1));
        this.previous.setCommand("/" + this.commandLabel + " " + Integer.toString(pageNumber - 1));
        InteractiveMessage navButtons = new InteractiveMessage();
        navButtons.addElement(new FormattedText("-----").setColor(ChatColor.GOLD).setStrikethrough(true)).addElement("[", ChatColor.GOLD);
        if (pageNumber == 1) {
            navButtons.addElement(this.next);
        } else if (pageNumber < totalPages) {
            navButtons.addElement(this.previous);
            navButtons.addElement(" | ", ChatColor.GOLD);
            navButtons.addElement(this.next);
        } else {
            navButtons.addElement(this.previous);
        }
        navButtons.addElement("]", ChatColor.GOLD);
        navButtons.sendTo(sender);
    }
}

