/*
 * Decompiled with CFR 0.152.
 */
package com.ebiggz.postalservice.utils;

import com.ebiggz.postalservice.PostalService;
import com.ebiggz.postalservice.config.ConfigAccessor;
import com.ebiggz.postalservice.utils.NameFetcher;
import com.ebiggz.postalservice.utils.UUIDFetcher;
import com.ebiggz.postalservice.utils.Utils;
import java.io.File;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.PluginManager;

public class UUIDUtils {
    public static UUID findUUID(String playerName) {
        Utils.debugMessage("Attemping to get uuid from online player... ");
        Player player = Bukkit.getPlayerExact((String)playerName);
        if (player != null) {
            return player.getUniqueId();
        }
        Utils.debugMessage("Player is offline. Attempting to get uuid from local cache...");
        UUID cachedID = UUIDUtils.searchCacheForID(playerName);
        if (cachedID != null) {
            return cachedID;
        }
        Utils.debugMessage("Cache is empty. Attempting to get uuid from Mojang server...");
        try {
            return UUIDFetcher.getUUIDOf(playerName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String findPlayerName(UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player != null) {
            return player.getName();
        }
        String cachedName = UUIDUtils.searchCacheForName(uuid);
        if (cachedName != null) {
            return cachedName;
        }
        try {
            return NameFetcher.getNameOf(uuid);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String searchCacheForName(UUID id) {
        ConfigAccessor uuidCache = new ConfigAccessor("data" + File.separator + "UUIDCache.yml");
        if (uuidCache.getConfig().contains(id.toString())) {
            return uuidCache.getConfig().getString(id.toString());
        }
        return null;
    }

    public static UUID searchCacheForID(String playerName) {
        ConfigAccessor uuidCache = new ConfigAccessor("data" + File.separator + "UUIDCache.yml");
        if (uuidCache.getConfig().contains(playerName)) {
            return UUID.fromString(uuidCache.getConfig().getString(playerName));
        }
        return null;
    }

    public static void saveKnownNameAndUUID(String playerName, UUID id) {
        ConfigAccessor uuidCache = new ConfigAccessor("data" + File.separator + "UUIDCache.yml");
        uuidCache.getConfig().set(id.toString(), (Object)playerName);
        uuidCache.getConfig().set(playerName, (Object)id.toString());
        uuidCache.saveConfig();
    }

    public static void loadFile() {
        PluginManager pm = PostalService.getPlugin().getServer().getPluginManager();
        String pluginFolder = PostalService.getPlugin().getDataFolder().getAbsolutePath();
        new File(pluginFolder).mkdirs();
        String playerFolder = String.valueOf(pluginFolder) + File.separator + "data";
        new File(playerFolder).mkdirs();
        File playerDataFile = new File(playerFolder, "UUIDCache.yml");
        ConfigAccessor playerData = new ConfigAccessor("data" + File.separator + "UUIDCache.yml");
        if (!playerDataFile.exists()) {
            try {
                playerData.saveDefaultConfig();
            }
            catch (Exception e) {
                Bukkit.getLogger().log(Level.SEVERE, "Exception while loading PostalService/data/UUIDCache.yml", e);
                pm.disablePlugin(PostalService.getPlugin());
            }
            return;
        }
        try {
            playerData.getConfig().options().header("This file caches playername/uuid combos so PostalService doesn't have to contact Mojang servers as often.");
            playerData.getConfig().options().copyHeader();
            playerData.reloadConfig();
        }
        catch (Exception e) {
            Bukkit.getLogger().log(Level.SEVERE, "Exception while loading PostalService/data/UUIDCache.yml", e);
            pm.disablePlugin(PostalService.getPlugin());
        }
    }
}

