/*
 * Decompiled with CFR 0.152.
 */
package com.ebiggz.postalservice.utils;

import com.ebiggz.postalservice.PostalService;
import com.ebiggz.postalservice.apis.InteractiveMessageAPI.FormattedText;
import com.ebiggz.postalservice.apis.InteractiveMessageAPI.InteractiveMessage;
import com.ebiggz.postalservice.apis.InteractiveMessageAPI.InteractiveMessageElement;
import com.ebiggz.postalservice.backend.User;
import com.ebiggz.postalservice.config.Config;
import com.ebiggz.postalservice.config.Language;
import com.ebiggz.postalservice.mail.MailManager;
import com.ebiggz.postalservice.mail.MailType;
import com.ebiggz.postalservice.permissions.PermissionHandler;
import com.ebiggz.postalservice.utils.FancyMenu;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public class Utils {
    public static void debugMessage(String message) {
        if (Config.ENABLE_DEBUG) {
            PostalService.getPlugin().getLogger().info("DEBUG: " + message);
        }
    }

    public static String wrap(String str, int wrapLength, String newLineStr, boolean wrapLongWords) {
        if (str == null) {
            return null;
        }
        if (wrapLength < 1) {
            wrapLength = 1;
        }
        int inputLineLength = str.length();
        int offset = 0;
        StringBuilder wrappedLine = new StringBuilder(inputLineLength + 32);
        while (inputLineLength - offset > wrapLength) {
            if (str.charAt(offset) == ' ') {
                ++offset;
                continue;
            }
            int spaceToWrapAt = str.lastIndexOf(32, wrapLength + offset);
            if (spaceToWrapAt >= offset) {
                wrappedLine.append(str.substring(offset, spaceToWrapAt));
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            if (wrapLongWords) {
                wrappedLine.append(str.substring(offset, wrapLength + offset));
                wrappedLine.append(newLineStr);
                offset += wrapLength;
                continue;
            }
            spaceToWrapAt = str.indexOf(32, wrapLength + offset);
            if (spaceToWrapAt >= 0) {
                wrappedLine.append(str.substring(offset, spaceToWrapAt));
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            wrappedLine.append(str.substring(offset));
            offset = inputLineLength;
        }
        wrappedLine.append(str.substring(offset));
        return wrappedLine.toString();
    }

    public static String capitalize(String str, char ... delimiters) {
        int delimLen;
        int n = delimLen = delimiters == null ? -1 : delimiters.length;
        if (StringUtils.isEmpty((String)str) || delimLen == 0) {
            return str;
        }
        char[] buffer = str.toCharArray();
        boolean capitalizeNext = true;
        int i = 0;
        while (i < buffer.length) {
            char ch = buffer[i];
            if (Utils.isDelimiter(ch, delimiters)) {
                capitalizeNext = true;
            } else if (capitalizeNext) {
                buffer[i] = Character.toTitleCase(ch);
                capitalizeNext = false;
            }
            ++i;
        }
        return new String(buffer);
    }

    private static boolean isDelimiter(char ch, char[] delimiters) {
        if (delimiters == null) {
            return Character.isWhitespace(ch);
        }
        char[] cArray = delimiters;
        int n = delimiters.length;
        int n2 = 0;
        while (n2 < n) {
            char delimiter = cArray[n2];
            if (ch == delimiter) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static List<String> getAllStartsWith(String key, List<String> list) {
        if (key == null || key.trim().isEmpty()) {
            return list;
        }
        ArrayList<String> filtered = new ArrayList<String>();
        for (String item : list) {
            if (!item.toLowerCase().trim().startsWith(key.toLowerCase().trim())) continue;
            filtered.add(item);
        }
        return filtered;
    }

    public static InteractiveMessage getUpdateAvailableMessage() {
        InteractiveMessage im = new InteractiveMessage(new InteractiveMessageElement(new FormattedText(Language.Phrases.ALERT_UPDATE_AVAILABLE.toPrefixedString()).setColor(Language.Phrases.ALERT_UPDATE_AVAILABLE.getFirstColor()).setFormat(Language.Phrases.ALERT_UPDATE_AVAILABLE.getFirstFormat())));
        im.addElement("\n");
        im.addElement(String.valueOf(Language.Phrases.PREFIX.toString()) + " ");
        im.addElement(new InteractiveMessageElement(Language.Phrases.UPDATE_BUTTON_VIEW_NOTES.toString(), InteractiveMessageElement.HoverEvent.SHOW_TEXT, Language.Phrases.UPDATE_BUTTON_VIEW_NOTES_HOVER.toString(), InteractiveMessageElement.ClickEvent.OPEN_URL, PostalService.getUpdater().getLatestReleaseNotesLink()));
        im.addElement(" ");
        im.addElement(new InteractiveMessageElement(Language.Phrases.UPDATE_BUTTON_DOWNLOAD.toString(), InteractiveMessageElement.HoverEvent.SHOW_TEXT, Language.Phrases.UPDATE_BUTTON_DOWNLOAD_HOVER.toString(), InteractiveMessageElement.ClickEvent.RUN_COMMAND, "/" + Language.Phrases.COMMAND_MAIL.toString() + " " + Language.Phrases.COMMAND_ARG_DOWNLOAD.toString()));
        return im;
    }

    public static InteractiveMessage getUpdateDownloadedMessage() {
        InteractiveMessage im = new InteractiveMessage(new InteractiveMessageElement(new FormattedText(Language.Phrases.ALERT_UPDATE_DOWNLOAD_SUCCESS.toPrefixedString()).setColor(Language.Phrases.ALERT_UPDATE_DOWNLOAD_SUCCESS.getFirstColor()).setFormat(Language.Phrases.ALERT_UPDATE_DOWNLOAD_SUCCESS.getFirstFormat())));
        im.addElement("\n");
        im.addElement(String.valueOf(Language.Phrases.PREFIX.toString()) + " ");
        im.addElement(new InteractiveMessageElement(Language.Phrases.UPDATE_BUTTON_VIEW_NOTES.toString(), InteractiveMessageElement.HoverEvent.SHOW_TEXT, Language.Phrases.UPDATE_BUTTON_VIEW_NOTES_HOVER.toString(), InteractiveMessageElement.ClickEvent.OPEN_URL, PostalService.getUpdater().getLatestReleaseNotesLink()));
        return im;
    }

    public static InteractiveMessage getComposeMessage(boolean isReply, Player player) {
        InteractiveMessage im = new InteractiveMessage();
        if (isReply) {
            im.addElement(String.valueOf(Language.Phrases.REPLY_TEXT.toPrefixedString()) + ": ");
        } else {
            im.addElement(String.valueOf(Language.Phrases.COMPOSE_TEXT.toPrefixedString()) + ": ");
        }
        MailType[] types = MailManager.getInstance().getMailTypes();
        int count = 0;
        MailType[] mailTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            MailType type = mailTypeArray[n2];
            if (PermissionHandler.playerCanMailType(type.getDisplayName().toLowerCase().trim(), player)) {
                if (count > 0) {
                    im.addElement(", ", ChatColor.AQUA);
                }
                String attachArg = "";
                if (type.getAttachmentCommandArgument() != null && !type.getAttachmentCommandArgument().isEmpty()) {
                    attachArg = " " + type.getAttachmentCommandArgument() + ":";
                }
                InteractiveMessageElement ime = new InteractiveMessageElement(new FormattedText(ChatColor.stripColor((String)type.getDisplayName()), ChatColor.AQUA), InteractiveMessageElement.HoverEvent.SHOW_TEXT, new FormattedText(ChatColor.stripColor((String)type.getHoveroverDescription()), ChatColor.GOLD), InteractiveMessageElement.ClickEvent.SUGGEST_COMMAND, "/" + Language.Phrases.COMMAND_MAIL.toString() + " " + type.getDisplayName().toLowerCase() + " " + Language.Phrases.COMMAND_ARG_TO.toString() + ": " + Language.Phrases.COMMAND_ARG_MESSAGE.toString() + ":" + attachArg);
                im.addElement(ime);
                ++count;
            }
            ++n2;
        }
        return im;
    }

    public static FancyMenu fancyHelpMenu(CommandSender player, String commandLabel) {
        FancyMenu fancyMenu = new FancyMenu(Language.Phrases.HELPMENU_TITLE.toString(), commandLabel);
        fancyMenu.addText(Language.Phrases.HELPMENU_TIP.toString());
        if (!Config.REQUIRE_MAILBOX && PermissionHandler.playerHasPermission(PermissionHandler.Perm.MAIL_READ, player, false)) {
            fancyMenu.addCommand("/" + Language.Phrases.COMMAND_MAIL.toString(), Language.Phrases.HELPMENU_MAIL_DESC.toString(), InteractiveMessageElement.ClickEvent.RUN_COMMAND, null);
        }
        if (PermissionHandler.playerHasPermission(PermissionHandler.Perm.RELOAD, player, false)) {
            fancyMenu.addCommand("/" + Language.Phrases.COMMAND_MAIL.toString() + " " + Language.Phrases.COMMAND_ARG_RELOAD.toString(), Language.Phrases.HELPMENU_RELOAD_DESC.toString(), InteractiveMessageElement.ClickEvent.RUN_COMMAND, null);
        }
        if (PermissionHandler.playerHasPermission(PermissionHandler.Perm.UPDATE, player, false)) {
            fancyMenu.addCommand("/" + Language.Phrases.COMMAND_MAIL.toString() + " " + Language.Phrases.COMMAND_ARG_UPDATE.toString(), Language.Phrases.HELPMENU_UPDATE_DESC.toString(), InteractiveMessageElement.ClickEvent.RUN_COMMAND, null);
            fancyMenu.addCommand("/" + Language.Phrases.COMMAND_MAIL.toString() + " " + Language.Phrases.COMMAND_ARG_DOWNLOAD.toString(), Language.Phrases.HELPMENU_DOWNLOAD_DESC.toString(), InteractiveMessageElement.ClickEvent.RUN_COMMAND, null);
        }
        if (PermissionHandler.playerHasPermission(PermissionHandler.Perm.MAIL_READOTHER, player, false)) {
            fancyMenu.addCommand("/" + Language.Phrases.COMMAND_MAIL.toString() + " " + Language.Phrases.HELPMENU_PLAYER_VARIABLE.toString(), Language.Phrases.HELPMENU_READOTHER_DESC.toString(), InteractiveMessageElement.ClickEvent.SUGGEST_COMMAND, "/" + Language.Phrases.COMMAND_MAIL.toString() + " ");
        }
        if (PermissionHandler.playerHasPermission(PermissionHandler.Perm.HELP, player, false)) {
            fancyMenu.addCommand("/" + Language.Phrases.COMMAND_MAIL.toString() + " " + Language.Phrases.COMMAND_ARG_HELP.toString(), Language.Phrases.HELPMENU_HELP_DESC.toString(), InteractiveMessageElement.ClickEvent.RUN_COMMAND, null);
        }
        if (PermissionHandler.playerCanMailSomething(player)) {
            fancyMenu.addCommand("/" + Language.Phrases.COMMAND_MAIL.toString() + " " + Language.Phrases.COMMAND_ARG_COMPOSE.toString(), Language.Phrases.HELPMENU_COMPOSE_DESC.toString(), InteractiveMessageElement.ClickEvent.RUN_COMMAND, null);
        }
        if (PermissionHandler.playerHasPermission(PermissionHandler.Perm.MAIL_CHECK, player, false)) {
            fancyMenu.addCommand("/" + Language.Phrases.COMMAND_MAIL.toString() + " " + Language.Phrases.COMMAND_ARG_CHECK.toString(), Language.Phrases.HELPMENU_CHECK_DESC.toString(), InteractiveMessageElement.ClickEvent.RUN_COMMAND, null);
        }
        fancyMenu.addCommand("/" + Language.Phrases.COMMAND_MAIL.toString() + " " + Language.Phrases.COMMAND_ARG_TIMEZONE.toString() + " " + Language.Phrases.HELPMENU_TIMEZONE_VARIABLE.toString(), Language.Phrases.HELPMENU_TIMEZONE_DESC.toString(), InteractiveMessageElement.ClickEvent.SUGGEST_COMMAND, "/" + Language.Phrases.COMMAND_MAIL.toString() + " " + Language.Phrases.COMMAND_ARG_TIMEZONE.toString() + " ");
        if (Config.ENABLE_MAILBOXES) {
            if (PermissionHandler.playerHasPermission(PermissionHandler.Perm.MAILBOX_SET, player, false)) {
                fancyMenu.addCommand("/" + Language.Phrases.COMMAND_MAILBOX.toString() + " " + Language.Phrases.COMMAND_ARG_SET.toString(), Language.Phrases.HELPMENU_SET_DESC.toString(), InteractiveMessageElement.ClickEvent.RUN_COMMAND, null);
            }
            if (PermissionHandler.playerHasPermission(PermissionHandler.Perm.MAILBOX_REMOVE, player, false)) {
                fancyMenu.addCommand("/" + Language.Phrases.COMMAND_MAILBOX.toString() + " " + Language.Phrases.COMMAND_ARG_REMOVE.toString(), Language.Phrases.HELPMENU_REMOVE_DESC.toString(), InteractiveMessageElement.ClickEvent.RUN_COMMAND, null);
            }
            if (PermissionHandler.playerHasPermission(PermissionHandler.Perm.MAILBOX_REMOVEALL, player, false)) {
                fancyMenu.addCommand("/" + Language.Phrases.COMMAND_MAILBOX.toString() + " " + Language.Phrases.COMMAND_ARG_REMOVEALL.toString(), Language.Phrases.HELPMENU_REMOVEALL_DESC.toString(), InteractiveMessageElement.ClickEvent.RUN_COMMAND, null);
            }
            if (PermissionHandler.playerHasPermission(PermissionHandler.Perm.MAILBOX_REMOVEALLOTHER, player, false)) {
                fancyMenu.addCommand("/" + Language.Phrases.COMMAND_MAILBOX.toString() + " " + Language.Phrases.COMMAND_ARG_REMOVEALL.toString() + " " + Language.Phrases.HELPMENU_PLAYER_VARIABLE.toString(), Language.Phrases.HELPMENU_REMOVEALLOTHER_DESC.toString(), InteractiveMessageElement.ClickEvent.SUGGEST_COMMAND, "/" + Language.Phrases.COMMAND_MAILBOX.toString() + " " + Language.Phrases.COMMAND_ARG_REMOVEALL.toString() + " ");
            }
            if (PermissionHandler.playerHasPermission(PermissionHandler.Perm.MAILBOX_FIND, player, false)) {
                fancyMenu.addCommand("/" + Language.Phrases.COMMAND_MAILBOX.toString() + " " + Language.Phrases.COMMAND_ARG_FIND.toString(), Language.Phrases.HELPMENU_FIND_DESC.toString(), InteractiveMessageElement.ClickEvent.RUN_COMMAND, null);
            }
        }
        return fancyMenu;
    }

    public static Player getPlayerFromIdentifier(String identifier) {
        Player player = Config.USE_UUIDS ? Bukkit.getPlayer((UUID)UUID.fromString(identifier)) : Bukkit.getPlayer((String)identifier);
        return player;
    }

    public static boolean playerIsOnline(String identifier) {
        Player player = Utils.getPlayerFromIdentifier(identifier);
        return player != null && player.isOnline();
    }

    public static void messagePlayerIfOnline(String identifier, String message) {
        Player player = Utils.getPlayerFromIdentifier(identifier);
        if (player != null && player.isOnline()) {
            player.sendMessage(message);
        }
    }

    public static int getPlayerOpenInvSlots(Player player) {
        PlayerInventory inv = player.getInventory();
        ItemStack[] contents = inv.getContents();
        int count = 0;
        ItemStack[] itemStackArray = contents;
        int n = contents.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack content = itemStackArray[n2];
            if (content == null) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    public static void unreadMailAlert(User user, boolean onlyUnreadAlert) {
        int unread = user.getUnreadMailCount();
        if (unread == 0) {
            if (!onlyUnreadAlert) {
                Utils.messagePlayerIfOnline(user.getIdentifier(), Language.Phrases.ALERT_NO_UNREAD_MAIL.toPrefixedString());
            }
        } else {
            Utils.messagePlayerIfOnline(user.getIdentifier(), Language.Phrases.ALERT_UNREAD_MAIL.toPrefixedString().replace("%count%", Integer.toString(unread)));
        }
    }

    public static Player[] getOnlinePlayers() {
        block3: {
            try {
                if (Bukkit.class.getMethod("getOnlinePlayers", new Class[0]).getReturnType() != Collection.class) {
                    return (Player[])Bukkit.class.getMethod("getOnlinePlayers", new Class[0]).invoke(null, new Object[0]);
                }
                Collection players = (Collection)Bukkit.class.getMethod("getOnlinePlayers", new Class[0]).invoke(null, new Object[0]);
                players.toArray(new Player[players.size()]);
            }
            catch (Exception e) {
                if (!Config.ENABLE_DEBUG) break block3;
                e.printStackTrace();
            }
        }
        return new Player[0];
    }

    public static List<String> getNamesThatStartWith(String prefix) {
        ArrayList<String> matches = new ArrayList<String>();
        if (prefix == null || prefix.trim().isEmpty()) {
            return matches;
        }
        boolean prefixTo = false;
        if (prefix.startsWith(String.valueOf(Language.Phrases.COMMAND_ARG_TO.toString()) + ":")) {
            prefix = prefix.replace(String.valueOf(Language.Phrases.COMMAND_ARG_TO.toString()) + ":", "");
            prefixTo = true;
        }
        Player[] playerArray = Utils.getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            if (player.getName().startsWith(prefix) && !player.getName().equals(prefix)) {
                if (prefixTo) {
                    matches.add(String.valueOf(Language.Phrases.COMMAND_ARG_TO.toString()) + ":" + player.getName());
                } else {
                    matches.add(player.getName());
                }
            }
            ++n2;
        }
        return matches;
    }

    public static String completeName(String playername) {
        try {
            if (Bukkit.class.getMethod("getOnlinePlayers", new Class[0]).getReturnType() == Collection.class) {
                for (Player onlinePlayer : (Collection)Bukkit.class.getMethod("getOnlinePlayers", new Class[0]).invoke(null, new Object[0])) {
                    if (!onlinePlayer.getName().toLowerCase().startsWith(playername.toLowerCase())) continue;
                    return onlinePlayer.getName();
                }
            } else {
                Player[] playerArray = (Player[])Bukkit.class.getMethod("getOnlinePlayers", new Class[0]).invoke(null, new Object[0]);
                int n = playerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Player onlinePlayer = playerArray[n2];
                    if (onlinePlayer.getName().toLowerCase().startsWith(playername.toLowerCase())) {
                        return onlinePlayer.getName();
                    }
                    ++n2;
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    public static byte[] itemsToBytes(List<ItemStack> items) {
        ByteArrayOutputStream baos;
        block2: {
            baos = new ByteArrayOutputStream();
            try {
                BukkitObjectOutputStream boos = new BukkitObjectOutputStream((OutputStream)baos);
                boos.writeObject(items);
                boos.close();
            }
            catch (IOException ioexception) {
                if (!Config.ENABLE_DEBUG) break block2;
                ioexception.printStackTrace();
            }
        }
        return baos.toByteArray();
    }

    public static List<ItemStack> bytesToItems(byte[] bytes) {
        Object backFromTheDead;
        block4: {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            backFromTheDead = null;
            try {
                BukkitObjectInputStream bois = new BukkitObjectInputStream((InputStream)bais);
                backFromTheDead = bois.readObject();
                bois.close();
            }
            catch (IOException ioexception) {
                if (Config.ENABLE_DEBUG) {
                    ioexception.printStackTrace();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!Config.ENABLE_DEBUG) break block4;
                classNotFoundException.printStackTrace();
            }
        }
        return (List)backFromTheDead;
    }

    public static String locationToString(Location location) {
        return String.valueOf(location.getBlockX()) + "," + location.getBlockY() + "," + location.getBlockZ() + "," + location.getWorld().getName();
    }

    public static Location stringToLocation(String string) {
        String[] split = string.split(",");
        Utils.debugMessage("Attempting to find world: \"" + split[3].trim() + "\"");
        World world = Bukkit.getWorld((String)split[3].trim());
        if (world == null) {
            Utils.debugMessage("Unable to find world!! Here are the worlds I can find: ");
            String worlds = "";
            for (World w : Bukkit.getWorlds()) {
                worlds = String.valueOf(worlds) + "\"" + w.getName() + "\", ";
                if (!split[3].trim().equals(w.getName().trim())) continue;
                world = w;
            }
            Utils.debugMessage(worlds);
            if (world != null) {
                Utils.debugMessage("A manual match was made!! Found world: " + world.getName());
            } else {
                Utils.debugMessage("A match could not be found.");
            }
        } else {
            Utils.debugMessage("A match was made!! Found world: " + world.getName());
        }
        return new Location(Bukkit.getServer().getWorld(split[3].trim()), Double.parseDouble(split[0]), Double.parseDouble(split[1]), Double.parseDouble(split[2]));
    }
}

