/*
 * Decompiled with CFR 0.152.
 */
package com.ebiggz.postalservice.utils;

class Version {
    private int major = 0;
    private int minor = 0;
    private int maintenance = 0;

    public Version(String[] splitVersion) {
        if (splitVersion.length > 1) {
            this.major = Integer.parseInt(splitVersion[0]);
            this.minor = Integer.parseInt(splitVersion[1]);
            if (splitVersion.length > 2) {
                this.maintenance = Integer.parseInt(splitVersion[2]);
            }
        }
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMaintenance() {
        return this.maintenance;
    }

    public boolean isMaintenanceUpdateTo(Version older) {
        return older.getMajor() == this.major && older.getMinor() == this.minor && older.getMaintenance() < this.maintenance;
    }

    public boolean isMinorUpdateTo(Version older) {
        return older.getMajor() == this.major && older.getMinor() < this.minor;
    }

    public boolean isMajorUpdateTo(Version older) {
        return older.getMajor() < this.major;
    }

    public boolean isUpdateTo(Version older) {
        return this.isMaintenanceUpdateTo(older) || this.isMinorUpdateTo(older) || this.isMajorUpdateTo(older);
    }
}

