/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.Restructured.assets;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.mod.Restructured.ModLog;
import org.blockartistry.mod.Restructured.ModOptions;
import org.blockartistry.mod.Restructured.Restructured;
import org.blockartistry.mod.Restructured.assets.SchematicProperties;
import org.blockartistry.mod.Restructured.assets.SchematicWeightItem;
import org.blockartistry.mod.Restructured.assets.ZipProcessor;
import org.blockartistry.mod.Restructured.component.SchematicStructureCreationHandler;
import org.blockartistry.mod.Restructured.util.ItemStackHelper;
import org.blockartistry.mod.Restructured.util.StreamUtils;
import org.blockartistry.mod.Restructured.util.WeightTable;
import org.blockartistry.mod.Restructured.world.SchematicWorldGenHandler;

public final class Assets {
    private static final String STANDARD_PACK = "StandardPack.zip";
    private static final List<SchematicProperties> schematicList = new ArrayList<SchematicProperties>();
    private static List<ChestGenHooks> chestHooks = null;
    private static final File accessPath = Restructured.dataDirectory();
    private static Configuration config = new Configuration(new File(accessPath, "schematics.cfg"));
    private static Configuration chests = new Configuration(new File(accessPath, "chests.cfg"));
    private static final WeightTable<SchematicWeightItem> villageSchematics = new WeightTable();
    private static final WeightTable<SchematicWeightItem> worldSchematics = new WeightTable();

    public static SchematicProperties getProperties(String schematic) {
        for (SchematicProperties p : schematicList) {
            if (!p.name.equals(schematic)) continue;
            return p;
        }
        return null;
    }

    private static boolean isContainerNode(ConfigCategory c) {
        return !c.getChildren().isEmpty();
    }

    private static void processEntry(ConfigCategory p, ConfigCategory cc, List<ChestGenHooks> list) {
        String chestHookName = null;
        chestHookName = p == null || cc.getName().startsWith("^") ? StringUtils.removeStart((String)cc.getName(), (String)"^") : p.getName() + "." + cc.getName();
        for (Map.Entry item : cc.getValues().entrySet()) {
            ItemStack stack = ItemStackHelper.getItemStack((String)item.getKey());
            if (stack == null || stack.func_77960_j() == Short.MAX_VALUE) {
                ModLog.warn("Invalid item: %s", item.getKey());
                continue;
            }
            try {
                String values = ((Property)item.getValue()).getString();
                String[] parms = values.split(",");
                if (parms.length == 3) {
                    int min = Integer.valueOf(parms[0]);
                    int max = Integer.valueOf(parms[1]);
                    int weight = Integer.valueOf(parms[2]);
                    ChestGenHooks.addItem((String)chestHookName, (WeightedRandomChestContent)new WeightedRandomChestContent(stack, min, max, weight));
                    continue;
                }
                ModLog.warn("Invalid number of values in parameter string: %s", values);
            }
            catch (Exception e) {
                ModLog.error("Unable to parse chest entry", e);
            }
        }
        list.add(ChestGenHooks.getInfo((String)chestHookName));
        ModLog.info("Loaded chest loot table '%s'", chestHookName);
    }

    private static List<ChestGenHooks> getChestGenerationHooks() {
        if (chestHooks != null) {
            return chestHooks;
        }
        chestHooks = new ArrayList<ChestGenHooks>();
        ConfigCategory c = chests.getCategory("chests");
        for (ConfigCategory p : c.getChildren()) {
            if (!Assets.isContainerNode(p)) {
                Assets.processEntry(null, p, chestHooks);
                continue;
            }
            for (ConfigCategory cc : p.getChildren()) {
                Assets.processEntry(p, cc, chestHooks);
            }
        }
        return chestHooks;
    }

    public static boolean areSchematicsInstalled() {
        return villageSchematics.size() != 0 || worldSchematics.size() != 0;
    }

    private static int villageStructureCount() {
        return villageSchematics.size();
    }

    private static int worldStructureCount() {
        return worldSchematics.size();
    }

    public static WeightTable<SchematicWeightItem> getTableForVillageGen() {
        WeightTable<SchematicWeightItem> table = new WeightTable<SchematicWeightItem>();
        for (SchematicWeightItem e : villageSchematics.getEntries()) {
            try {
                table.add((SchematicWeightItem)e.clone());
            }
            catch (CloneNotSupportedException e1) {
                e1.printStackTrace();
            }
        }
        return table;
    }

    public static WeightTable<SchematicWeightItem> getTableForWorldGen(int dimId, BiomeGenBase biome) {
        WeightTable<SchematicWeightItem> table = new WeightTable<SchematicWeightItem>();
        for (SchematicWeightItem e : worldSchematics.getEntries()) {
            SchematicProperties p = e.properties;
            if (!p.dimensions.isOk(dimId) || !p.biomes.isOk(biome.field_76756_M)) continue;
            try {
                table.add((SchematicWeightItem)e.clone());
            }
            catch (CloneNotSupportedException e1) {
                e1.printStackTrace();
            }
        }
        return table;
    }

    protected static void dumpBiomeList() {
        ModLog.info("Detected biomes:", new Object[0]);
        for (BiomeGenBase b : BiomeGenBase.func_150565_n()) {
            if (b == null) continue;
            ModLog.info("Biome [%s] id=%d", b.field_76791_y, b.field_76756_M);
        }
    }

    public static void initialize() {
        ZipProcessor.initialize(accessPath, config, chests, schematicList);
        for (SchematicProperties p : schematicList) {
            if (p.villageWeight > 0) {
                villageSchematics.add(new SchematicWeightItem(p, true));
            }
            if (p.worldWeight > 0) {
                worldSchematics.add(new SchematicWeightItem(p, false));
            }
            if (p.villageWeight <= 0 && p.worldWeight <= 0) continue;
            ModLog.info(p.toString(), new Object[0]);
            if (!ModOptions.getEnableDebugLogging()) continue;
            Map<Block, Integer> analysis = p.analyze();
            for (Map.Entry<Block, Integer> e : analysis.entrySet()) {
                ModLog.info("Block: [%s], count=%d", e.getKey().func_149732_F(), e.getValue());
            }
        }
        Assets.getChestGenerationHooks();
        config.save();
        chests.save();
        if (Assets.villageStructureCount() > 0) {
            ModLog.info("Registering village structure handler", new Object[0]);
            new SchematicStructureCreationHandler();
        }
        if (Assets.worldStructureCount() > 0) {
            ModLog.info("Regsitering world generation handler", new Object[0]);
            new SchematicWorldGenHandler();
        }
        Assets.dumpBiomeList();
        config = null;
        chests = null;
    }

    static {
        ModLog.info("Schematic ZIPs present: %s", Boolean.toString(ZipProcessor.areZipsPresent(accessPath)));
        ModLog.info("Schematic Files present: %s", Boolean.toString(ZipProcessor.areSchematicsPresent(accessPath)));
        if (!ZipProcessor.areZipsPresent(accessPath) && !ZipProcessor.areSchematicsPresent(accessPath)) {
            ModLog.info("Extracting %s to configuration directory", STANDARD_PACK);
            try {
                InputStream input = Assets.class.getResourceAsStream("/assets/recycling/StandardPack.zip");
                if (input != null) {
                    StreamUtils.copy(input, new File(accessPath, STANDARD_PACK));
                    input.close();
                } else {
                    ModLog.warn("Unable to obtain %s input stream from jar!", STANDARD_PACK);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

