/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.Restructured.assets;

import com.google.common.base.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.mod.Restructured.assets.SchematicProperties;
import org.blockartistry.mod.Restructured.schematica.SchematicFormat;
import org.blockartistry.mod.Restructured.util.ElementRule;
import org.blockartistry.mod.Restructured.util.JarConfiguration;
import org.blockartistry.mod.Restructured.util.MyUtils;

public final class ConfigProcessor {
    public static final String CONFIG_CHESTS = "chests";
    private static final String DEFAULT_OPTIONS = "suppressFire;suppressEggs";
    private static final int DEFAULT_VILLAGE_WEIGHT = 10;
    private static final int DEFAULT_WORLD_WEIGHT = 0;
    private static final int DEFAULT_LIMIT = 1;
    private static final int DEFAULT_OFFSET = 1;
    private static final int DEFAULT_VILLAGER_COUNT = 1;
    private static final int DEFAULT_VILLAGER_PROFESSION = -1;
    private static final String DEFAULT_CHEST_CONTENTS = "";
    private static final int DEFAULT_CHEST_CONTENTS_COUNT = 1;
    private static final int DEFAULT_SPAWNER_ENABLE_CHANCE = 15;
    private static final boolean DEFAULT_BIOME_LIST_TYPE = true;
    private static final boolean DEFAULT_DIMENSION_LIST_TYPE = true;
    private static final int[] DEFAULT_BIOME_LIST = new int[]{BiomeGenBase.field_150575_M.field_76756_M, BiomeGenBase.field_76776_l.field_76756_M, BiomeGenBase.field_76777_m.field_76756_M, BiomeGenBase.field_76771_b.field_76756_M, BiomeGenBase.field_76781_i.field_76756_M, BiomeGenBase.field_76780_h.field_76756_M, BiomeGenBase.field_76787_r.field_76756_M};
    private static final int[] DEFAULT_DIMENSION_LIST = new int[]{1, -1};
    private static final String CONFIG_STRUCTURES = "structures";
    private static final String OPTION_OPTIONS = "generationOptions";
    private static final String OPTION_OPTIONS_SUPPRESS_FIRE = "suppressFire";
    private static final String OPTION_OPTIONS_SUPPRESS_EGGS = "suppressEggs";
    private static final String OPTION_VILLAGE_WEIGHT = "villageWeight";
    private static final String OPTION_WORLD_WEIGHT = "worldWeight";
    private static final String OPTION_LIMIT = "limit";
    private static final String OPTION_VILLAGER_COUNT = "villagerCount";
    private static final String OPTION_VILLAGER_PROFESSION = "villagerProfession";
    private static final String OPTION_OFFSET = "groundOffset";
    private static final String OPTION_CHEST_CONTENTS = "chestContents";
    private static final String OPTION_CHEST_CONTENTS_COUNT = "chestContentsCount";
    private static final String OPTION_SPAWNER_ENABLE_CHANCE = "spawnerEnableChance";
    private static final String OPTION_BIOME_LIST_TYPE = "biomeListAsBlacklist";
    private static final String OPTION_DIMENSION_LIST_TYPE = "dimensionListAsBlacklist";
    private static final String OPTION_BIOME_LIST = "biomeList";
    private static final String OPTION_DIMENSION_LIST = "dimensionList";
    private static final String SCHEMATIC_RESOURCE_EXTENSION = ".schematic";

    private ConfigProcessor() {
    }

    public static class SchematicsProcess
    implements Predicate<Object[]> {
        private final Configuration target;
        private final List<SchematicProperties> schematicList;

        public SchematicsProcess(Configuration config, List<SchematicProperties> list) {
            this.target = config;
            this.schematicList = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean apply(Object[] input) {
            String prefix = (String)input[0];
            String entry = (String)input[1];
            InputStream stream = (InputStream)input[2];
            SchematicProperties props = new SchematicProperties();
            props.name = prefix.isEmpty() ? entry : prefix + "." + entry;
            String category = "structures." + props.name;
            props.villageWeight = this.target.getInt(ConfigProcessor.OPTION_VILLAGE_WEIGHT, category, 10, 0, Integer.MAX_VALUE, "Relative selection weight for village structure generation");
            props.worldWeight = this.target.getInt(ConfigProcessor.OPTION_WORLD_WEIGHT, category, 0, 0, Integer.MAX_VALUE, "Relative selection weight for world generation");
            props.villagerCount = this.target.getInt(ConfigProcessor.OPTION_VILLAGER_COUNT, category, 1, -1, Integer.MAX_VALUE, "Number of villagers to spawn for the structure (-1 random)");
            props.villagerProfession = this.target.getInt(ConfigProcessor.OPTION_VILLAGER_PROFESSION, category, -1, -1, 4, "Villager profession: -1 random, 0 farmer, 1 librarian, 2 priest, 3 smith, 4 butcher");
            props.limit = this.target.getInt(ConfigProcessor.OPTION_LIMIT, category, 1, 0, Integer.MAX_VALUE, "Maximum number of this type of structure to have in a village");
            props.groundOffset = this.target.getInt(ConfigProcessor.OPTION_OFFSET, category, 1, 0, Integer.MAX_VALUE, "The number of blocks below ground the structure extends");
            props.chestContents = this.target.getString(ConfigProcessor.OPTION_CHEST_CONTENTS, category, ConfigProcessor.DEFAULT_CHEST_CONTENTS, "What chest generation hook to use when filling chests");
            if (props.chestContents.startsWith("^")) {
                props.chestContents = StringUtils.removeStart((String)props.chestContents, (String)"^");
            }
            props.chestContentsCount = this.target.getInt(ConfigProcessor.OPTION_CHEST_CONTENTS_COUNT, category, 1, 0, Integer.MAX_VALUE, "The number of stacks to pull from the generation table");
            props.spawnerEnableChance = this.target.getInt(ConfigProcessor.OPTION_SPAWNER_ENABLE_CHANCE, category, 15, 0, 100, "Chance that a spawner will be preserved when placed");
            boolean asBlackList = this.target.getBoolean(ConfigProcessor.OPTION_BIOME_LIST_TYPE, category, true, "Treat the biome list as a blacklist vs. whitelist");
            String def = StringUtils.join((int[])DEFAULT_BIOME_LIST, (char)';');
            String list = this.target.getString(ConfigProcessor.OPTION_BIOME_LIST, category, def, "List of biome IDs");
            try {
                props.biomes = new ElementRule(asBlackList ? ElementRule.Rule.MUST_NOT_BE_IN : ElementRule.Rule.MUST_BE_IN, MyUtils.splitToInts(list, ';'));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            asBlackList = this.target.getBoolean(ConfigProcessor.OPTION_DIMENSION_LIST_TYPE, category, true, "Treat the dimension list as a blacklist vs. whitelist");
            def = StringUtils.join((int[])DEFAULT_DIMENSION_LIST, (char)';');
            list = this.target.getString(ConfigProcessor.OPTION_DIMENSION_LIST, category, def, "List of dimension IDs");
            String options = this.target.getString(ConfigProcessor.OPTION_OPTIONS, category, ConfigProcessor.DEFAULT_OPTIONS, "Options for generation");
            props.suppressFire = options.contains(ConfigProcessor.OPTION_OPTIONS_SUPPRESS_FIRE);
            props.suppressMonsterEgg = options.contains(ConfigProcessor.OPTION_OPTIONS_SUPPRESS_EGGS);
            try {
                props.dimensions = new ElementRule(asBlackList ? ElementRule.Rule.MUST_NOT_BE_IN : ElementRule.Rule.MUST_BE_IN, MyUtils.splitToInts(list, ';'));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            try {
                props.schematic = SchematicFormat.readFromStream(stream);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (props.schematic != null) {
                if (props.suppressMonsterEgg) {
                    props.schematic.scrubEggs();
                }
                if (props.suppressFire) {
                    props.schematic.scrubFireSources();
                }
                this.schematicList.add(props);
            }
            return true;
        }
    }

    public static class SchematicsConfigProcess
    implements Predicate<Object[]> {
        private final Configuration target;

        public SchematicsConfigProcess(Configuration config) {
            this.target = config;
        }

        public boolean apply(Object[] input) {
            String prefix = (String)input[0];
            InputStream stream = (InputStream)input[2];
            JarConfiguration src = new JarConfiguration(stream);
            ConfigCategory c = src.getCategory(ConfigProcessor.CONFIG_STRUCTURES);
            for (ConfigCategory p : c.getChildren()) {
                String name = "structures." + prefix + "." + p.getName();
                ConfigCategory temp = this.target.getCategory(name);
                if (!temp.isEmpty()) continue;
                for (Map.Entry item : p.getValues().entrySet()) {
                    Property prop = (Property)item.getValue();
                    if (((String)item.getKey()).equals(ConfigProcessor.OPTION_CHEST_CONTENTS)) {
                        String chestName = ((Property)item.getValue()).getString();
                        if (chestName.startsWith("^")) {
                            prop = new Property(ConfigProcessor.OPTION_CHEST_CONTENTS, ((Property)item.getValue()).getString().substring(1), Property.Type.STRING);
                        } else if (!chestName.isEmpty()) {
                            prop = new Property(ConfigProcessor.OPTION_CHEST_CONTENTS, prefix + "." + ((Property)item.getValue()).getString(), Property.Type.STRING);
                        }
                    }
                    temp.put((String)item.getKey(), prop);
                }
            }
            return true;
        }
    }

    public static class ChestsConfigProcess
    implements Predicate<Object[]> {
        private final Configuration target;

        public ChestsConfigProcess(Configuration config) {
            this.target = config;
        }

        public boolean apply(Object[] input) {
            String prefix = (String)input[0];
            InputStream stream = (InputStream)input[2];
            JarConfiguration src = new JarConfiguration(stream);
            ConfigCategory c = src.getCategory(ConfigProcessor.CONFIG_CHESTS);
            for (ConfigCategory p : c.getChildren()) {
                String name = "chests." + prefix + "." + p.getName();
                ConfigCategory temp = this.target.getCategory(name);
                if (!temp.isEmpty()) continue;
                for (Map.Entry item : p.getValues().entrySet()) {
                    temp.put((String)item.getKey(), (Property)item.getValue());
                }
            }
            return true;
        }
    }

    public static class SchematicFilter
    implements Predicate<ZipEntry> {
        public boolean apply(ZipEntry t) {
            return t.getName().endsWith(ConfigProcessor.SCHEMATIC_RESOURCE_EXTENSION);
        }
    }

    public static class SchematicsConfigFilter
    implements Predicate<ZipEntry> {
        public boolean apply(ZipEntry t) {
            return t.getName().contains("schematics.cfg");
        }
    }

    public static class ChestsConfigFilter
    implements Predicate<ZipEntry> {
        public boolean apply(ZipEntry t) {
            return t.getName().contains("chests.cfg");
        }
    }
}

